/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.entity.EntityArc;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class ControlPoint {
    private final World world;
    protected EntityArc arc;
    protected EntityLivingBase owner;
    protected float size;
    private Vector internalVelocity;
    private Vector internalPosition = new Vector();
    private Vector lastPos;
    private AxisAlignedBB hitbox;

    public ControlPoint(EntityArc arc, float size, double x, double y, double z) {
        this.internalVelocity = new Vector();
        this.arc = arc;
        this.world = arc.field_70170_p;
        this.size = size;
        double sizeHalfed = size / 2.0f;
        this.hitbox = new AxisAlignedBB(this.position().x() - sizeHalfed, this.position().y() - sizeHalfed, this.position().z() - sizeHalfed, this.position().x() + sizeHalfed, this.position().y() + sizeHalfed, this.position().z() + sizeHalfed);
        this.lastPos = new Vector();
    }

    public Vector velocity() {
        return this.internalVelocity;
    }

    public void setVelocity(Vector velocity) {
        this.internalVelocity = velocity;
    }

    public Vector position() {
        return this.internalPosition;
    }

    public Vector lastPosition() {
        return this.lastPos;
    }

    public double x() {
        return this.position().x();
    }

    public double y() {
        return this.position().y();
    }

    public double z() {
        return this.position().z();
    }

    public void setDead() {
        this.arc.func_70106_y();
    }

    public AxisAlignedBB getBoundingBox() {
        return this.hitbox;
    }

    public float size() {
        return this.size;
    }

    public void onUpdate() {
        double sizeHalfed = this.size / 2.0f;
        this.hitbox = new AxisAlignedBB(this.position().x() - sizeHalfed, this.position().y() - sizeHalfed, this.position().z() - sizeHalfed, this.position().x() + sizeHalfed, this.position().y() + sizeHalfed, this.position().z() + sizeHalfed);
        this.lastPos = this.position();
        this.move(this.velocity().times(0.05));
        this.setVelocity(this.velocity().times(0.4));
    }

    public void setPosition(Vector pos) {
        this.internalPosition = pos;
    }

    public void move(double x, double y, double z) {
        this.setPosition(this.position().plus(x, y, z));
    }

    public void move(Vector offset) {
        this.move(offset.x(), offset.y(), offset.z());
    }

    public double getDistance(ControlPoint point) {
        return this.position().dist(point.position());
    }

    public EntityArc getArc() {
        return this.arc;
    }

    public void setArc(EntityArc arc) {
        this.arc = arc;
    }

    public EntityLivingBase getOwner() {
        return this.owner;
    }

    public void setOwner(EntityLivingBase owner) {
        this.owner = owner;
    }

    public Vector getInterpolatedPosition(float partialTicks) {
        return this.lastPosition().plus(this.position().minus(this.lastPosition()).times(partialTicks));
    }
}

