/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityIceShield;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.EntityShield;
import com.crowsofwar.avatar.entity.IOffensiveEntity;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAirBubble
extends EntityShield {
    public static final DataParameter<Integer> SYNC_DISSIPATE = EntityDataManager.func_187226_a(EntityAirBubble.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Boolean> SYNC_HOVERING = EntityDataManager.func_187226_a(EntityAirBubble.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final UUID SLOW_ATTR_ID = UUID.fromString("40354c68-6e88-4415-8a6b-e3ddc56d6f50");
    public static final AttributeModifier SLOW_ATTR = new AttributeModifier(SLOW_ATTR_ID, "airbubble_slowness", -0.3, 2);
    private int airLeft;

    public EntityAirBubble(World world) {
        super(world);
        this.func_70105_a(2.5f, 2.5f);
        this.field_70145_X = true;
        this.airLeft = 600;
        this.putsOutFires = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_DISSIPATE, (Object)0);
        this.field_70180_af.func_187214_a(SYNC_HOVERING, (Object)false);
    }

    @Override
    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        assert (this.getOwner() != null);
        this.setPosition(Vector.getEntityPos((Entity)this.getOwner()));
    }

    @Override
    public BendingStyle getElement() {
        return new Airbending();
    }

    @Override
    public EntityLivingBase getController() {
        return !this.isDissipating() ? this.getOwner() : null;
    }

    public boolean doesAllowHovering() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_HOVERING);
    }

    public void setAllowHovering(boolean floating) {
        this.field_70180_af.func_187227_b(SYNC_HOVERING, (Object)floating);
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        Bender ownerBender;
        AxisAlignedBB box;
        List nearby;
        super.func_70071_h_();
        EntityLivingBase owner = this.getOwner();
        if (owner == null && !this.isDissipating()) {
            this.func_70106_y();
            this.cleanup();
        }
        if (owner == null) {
            return;
        }
        if (owner.field_70128_L) {
            this.dissipateSmall();
            this.cleanup();
            return;
        }
        this.setPosition(AvatarEntityUtils.getBottomMiddleOfEntity((Entity)this.getOwner()));
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        if (this.field_70170_p.field_72995_K && this.getOwner() != null) {
            for (int i = 0; i < 10; ++i) {
                double theta = this.field_70173_aa % 180 * 10 + i * 36;
                double dphi = 30.0 / Math.sin(Math.toRadians(theta));
                double phi = (double)(this.field_70173_aa % 360) * dphi + (double)(i * 36);
                double rphi = Math.toRadians(phi);
                double rtheta = Math.toRadians(theta);
                double x1 = (double)this.getSize() * Math.cos(rphi) * Math.sin(rtheta);
                double y1 = (double)this.getSize() * Math.sin(rphi) * Math.sin(rtheta);
                double z1 = (double)this.getSize() * Math.cos(rtheta);
                double xVel = x1 * this.field_70170_p.field_73012_v.nextGaussian() / 200.0;
                double yVel = y1 * this.field_70170_p.field_73012_v.nextGaussian() / 200.0;
                double zVel = z1 * this.field_70170_p.field_73012_v.nextGaussian() / 200.0;
                Vec3d centre = AvatarEntityUtils.getMiddleOfEntity(this);
                double x = centre.field_72450_a;
                double y = centre.field_72448_b;
                double z = centre.field_72449_c;
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(x1 + x, y1 + y, z1 + z).vel(xVel, yVel, zVel).clr(0.95f, 0.95f, 0.95f, 0.1f).time(15 + AvatarUtils.getRandomNumberInRange(0, 10)).spawnEntity((Entity)this.getOwner()).scale(0.75f * this.getSize() * (1.0f / this.getSize())).element(this.getElement()).spawn(this.field_70170_p);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(x1 + x, y1 + y, z1 + z).vel(xVel, yVel, zVel).clr(0.95f, 0.95f, 0.95f, 0.1f).time(15 + AvatarUtils.getRandomNumberInRange(0, 10)).spawnEntity((Entity)this.getOwner()).scale(0.75f * this.getSize() * (1.0f / this.getSize())).element(this.getElement()).spawn(this.field_70170_p);
            }
        }
        if (this.getOwner() != null) {
            EntityAirBubble bubble = AvatarEntity.lookupControlledEntity(this.field_70170_p, EntityAirBubble.class, this.getOwner());
            BendingData bD = BendingData.getFromEntity(this.getOwner());
            if (bubble == null && bD != null && (bD.hasStatusControl(StatusControlController.BUBBLE_CONTRACT) || bD.hasStatusControl(StatusControlController.BUBBLE_EXPAND))) {
                bD.removeStatusControl(StatusControlController.BUBBLE_CONTRACT);
                bD.removeStatusControl(StatusControlController.BUBBLE_EXPAND);
            }
            if (bubble != null && bD != null && !bD.hasStatusControl(StatusControlController.BUBBLE_CONTRACT) && !bD.hasStatusControl(StatusControlController.BUBBLE_EXPAND)) {
                bD.addStatusControl(StatusControlController.BUBBLE_CONTRACT);
                bD.addStatusControl(StatusControlController.BUBBLE_EXPAND);
            }
        }
        if (!(nearby = this.field_70170_p.func_72872_a(Entity.class, box = new AxisAlignedBB(this.func_174813_aQ().field_72340_a - (double)(this.getSize() / 8.0f), this.func_174813_aQ().field_72338_b - (double)(this.getSize() / 8.0f), this.func_174813_aQ().field_72339_c - (double)(this.getSize() / 8.0f), this.func_174813_aQ().field_72336_d + (double)(this.getSize() / 8.0f), this.func_174813_aQ().field_72337_e + (double)(this.getSize() / 8.0f), this.func_174813_aQ().field_72334_f + (double)(this.getSize() / 8.0f)))).isEmpty()) {
            for (Entity collided : nearby) {
                if (collided == this || collided == this.getOwner() || !collided.func_70104_M()) continue;
                this.onCollideWithEntity(collided);
            }
        }
        if (!this.field_70170_p.field_72995_K && owner.func_70055_a(Material.field_151586_h)) {
            owner.func_70050_g(Math.min(this.airLeft, 300));
            --this.airLeft;
        }
        if ((ownerBender = Bender.get(this.getOwner())) != null && this.getAbility() != null) {
            boolean elytraOk;
            AbilityData abilityData = AbilityData.get(this.getOwner(), this.getAbilityName());
            if (!this.field_70170_p.field_72995_K && !ownerBender.consumeChi(this.getAbility().getProperty("chiPerSecond", abilityData).floatValue() / 20.0f)) {
                this.dissipateSmall();
            }
            ItemStack chest = owner.func_184582_a(EntityEquipmentSlot.CHEST);
            boolean bl = elytraOk = ConfigStats.STATS_CONFIG.allowAirBubbleElytra || chest.func_77973_b() != Items.field_185160_cR;
            if (!elytraOk) {
                ownerBender.sendMessage("avatar.airBubbleElytra");
                this.dissipateSmall();
            }
            EntityIceShield a = AvatarEntity.lookupControlledEntity(this.field_70170_p, EntityIceShield.class, owner);
            if (!this.isDissipating() && a == null) {
                IAttributeInstance attribute = owner.func_110148_a(SharedMonsterAttributes.field_111263_d);
                if (attribute.func_111127_a(SLOW_ATTR_ID) == null) {
                    attribute.func_111121_a(SLOW_ATTR);
                }
                if (!ownerBender.isFlying() && !this.getOwner().func_189652_ae()) {
                    owner.field_70181_x += 0.03;
                    if (this.doesAllowHovering()) {
                        if (this.doesAllowHovering() && !owner.func_70093_af()) {
                            this.handleHovering();
                        } else if (!owner.func_70093_af()) {
                            owner.field_70181_x += 0.03;
                        }
                    }
                }
            }
        }
        float size = this.getSize();
        if (this.isDissipatingLarge()) {
            this.setDissipateTime(this.getDissipateTime() + 1);
            float mult = 1.0f + (float)this.getDissipateTime() / 10.0f;
            this.func_70105_a(size * mult, size * mult);
            if (this.getDissipateTime() >= 10) {
                this.func_70106_y();
            }
        } else if (this.isDissipatingSmall()) {
            this.setDissipateTime(this.getDissipateTime() - 1);
            float mult = 1.0f + (float)this.getDissipateTime() / 40.0f;
            this.func_70105_a(size * mult, size * mult);
            if (this.getDissipateTime() <= -10) {
                this.func_70106_y();
            }
        } else {
            this.func_70105_a(size, size);
        }
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    private void handleHovering() {
        if (this.getOwner() == null) {
            return;
        }
        if (this.getOwner() != null) {
            this.getOwner().field_70143_R = 0.0f;
        }
        double minFloatHeight = 1.2;
        double maxFloatHeight = 3.0;
        EntityLivingBase owner = this.getOwner();
        assert (owner != null);
        double x = owner.field_70165_t;
        double y = owner.field_70163_u;
        double z = owner.field_70161_v;
        AxisAlignedBB hitbox = new AxisAlignedBB(x, y, z, x, y, z);
        hitbox = hitbox.func_72314_b(0.2, 0.0, 0.2);
        hitbox = hitbox.func_72321_a(0.0, -3.0, 0.0);
        List blockCollisions = this.field_70170_p.func_184144_a(null, hitbox);
        BlockPos pos = new BlockPos((double)this.func_180425_c().func_177958_n(), (double)this.func_180425_c().func_177956_o() - 3.0, (double)this.func_180425_c().func_177952_p());
        BlockPos below = pos.func_177972_a(EnumFacing.DOWN);
        Block belowBlock = this.field_70170_p.func_180495_p(below).func_177230_c();
        if (!blockCollisions.isEmpty()) {
            double groundPosition = Double.MIN_VALUE;
            for (AxisAlignedBB blockHitbox : blockCollisions) {
                if (!(blockHitbox.field_72337_e > groundPosition)) continue;
                groundPosition = blockHitbox.field_72337_e;
            }
            double distanceFromGround = owner.field_70163_u - groundPosition;
            if (distanceFromGround < 1.2) {
                owner.field_70181_x += 0.11;
            }
            if (distanceFromGround >= 1.2 && distanceFromGround < 3.0) {
                owner.field_70181_x *= 0.8;
            }
            if (distanceFromGround >= 3.0) {
                owner.field_70181_x += 0.07;
                if (owner.field_70181_x < -0.15) {
                    owner.field_70181_x = 0.0;
                }
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.cleanup();
    }

    @Override
    public boolean isShield() {
        return true;
    }

    @Override
    public boolean canPush() {
        return false;
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        if (entity instanceof AvatarEntity && ((AvatarEntity)entity).getOwner() != this.getOwner()) {
            ((AvatarEntity)entity).onAirContact();
        }
        if (this.canCollideWith(entity) && entity != this.getOwner() && this.getOwner() != null) {
            Vector velocity = Vector.getEntityPos(entity).minus(Vector.getEntityPos((Entity)this.getOwner()));
            double dist = this.getOwner().func_70032_d(entity);
            double sizeMult = this.isDissipatingLarge() ? (double)(4.0f * (this.getSize() * 2.0f / 3.0f)) : (double)(2.0f * (this.getSize() * 2.0f / 3.0f));
            double mult = (dist - (double)this.getSize()) * sizeMult > 1.0 ? (dist - (double)this.getSize()) * sizeMult : 1.0 * sizeMult;
            velocity = velocity.normalize().times(mult / 8.0).withY(this.getSize() / 5.0f);
            entity.func_70024_g(velocity.x() / 2.0, velocity.y(), velocity.z() / 2.0);
            if (entity instanceof AvatarEntity) {
                AvatarEntity avent = (AvatarEntity)entity;
                avent.setVelocity(velocity);
            }
            entity.field_70160_al = true;
            AvatarUtils.afterVelocityAdded(entity);
            if (this.getOwner().field_70737_aN == 0) {
                float damage = 0.0f;
                DamageSource source = DamageSource.field_76377_j;
                if (entity instanceof EntityLivingBase) {
                    IAttributeInstance attribute = this.getOwner().func_110148_a(SharedMonsterAttributes.field_111264_e);
                    damage = (float)attribute.func_111126_e();
                } else if (entity instanceof EntityOffensive && ((EntityOffensive)entity).getOwner() != null) {
                    damage = ((IOffensiveEntity)entity).getDamage();
                    source = ((IOffensiveEntity)entity).getDamageSource(entity, ((EntityOffensive)entity).getOwner());
                }
                if (!this.field_70170_p.field_72995_K) {
                    Bender bender;
                    EntityLivingBase owner = this.getOwner();
                    if (!UNPROTECTED_DAMAGE.contains(source.func_76355_l()) && !owner.func_180431_b(source) && Bender.isBenderSupported(owner) && (bender = Bender.get(owner)) != null) {
                        BendingData data = bender.getData();
                        if (bender.consumeChi(this.getChiDamageCost() * damage)) {
                            AbilityData aData = data.getAbilityData(this.getAbilityName());
                            aData.addXp(this.getProtectionXp());
                            aData.addBurnout(this.getAbility().getBurnOut(aData));
                            this.setHealth(this.getHealth() - damage);
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        if (entity instanceof AvatarEntity && ((AvatarEntity)entity).getOwner() == this.getOwner()) {
            return false;
        }
        if (entity.func_184188_bt().contains(this.getOwner())) {
            return false;
        }
        return entity != this.getOwner() && !(entity instanceof EntityXPOrb) && !(entity instanceof EntityItem);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setDissipateTime(nbt.func_74762_e("Dissipate"));
        this.setAllowHovering(nbt.func_74767_n("AllowHovering"));
        this.setSize(nbt.func_74760_g("Size"));
        this.airLeft = nbt.func_74762_e("AirLeft");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Dissipate", this.getDissipateTime());
        nbt.func_74757_a("AllowHovering", this.doesAllowHovering());
        nbt.func_74776_a("Size", this.getSize());
        nbt.func_74768_a("AirLeft", this.airLeft);
    }

    @Override
    protected float getChiDamageCost() {
        float dmgPercent = 0.5f;
        if (this.getOwner() != null && this.getAbility() != null) {
            AbilityData abilityData = AbilityData.get(this.getOwner(), this.getAbilityName());
            dmgPercent = this.getAbility().getProperty("chiPercentOnHit", abilityData).floatValue();
            dmgPercent = (1.0f - (float)abilityData.getPowerRating() / 200.0f) * dmgPercent;
        }
        return dmgPercent;
    }

    @Override
    protected float getProtectionXp() {
        if (this.getOwner() != null && this.getAbility() != null) {
            return this.getAbility().getProperty("xpOnUse", AbilityData.get(this.getOwner(), this.getAbilityName())).floatValue();
        }
        return 2.0f;
    }

    @Override
    protected String getAbilityName() {
        return this.getAbility().getName();
    }

    @Override
    protected void onDeath() {
        this.dissipateLarge();
    }

    public int getDissipateTime() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_DISSIPATE);
    }

    public void setDissipateTime(int dissipate) {
        this.field_70180_af.func_187227_b(SYNC_DISSIPATE, (Object)dissipate);
    }

    public void dissipateLarge() {
        if (!this.isDissipating()) {
            this.setDissipateTime(1);
        }
        this.cleanup();
    }

    public void dissipateSmall() {
        if (!this.isDissipating()) {
            this.setDissipateTime(-1);
        }
        this.cleanup();
    }

    private boolean isDissipating() {
        return this.getDissipateTime() != 0;
    }

    public boolean isDissipatingLarge() {
        return this.getDissipateTime() > 0;
    }

    public boolean isDissipatingSmall() {
        return this.getDissipateTime() < 0;
    }

    private void cleanup() {
        AbilityData abilityData;
        if (this.getOwner() != null && this.getAbility() != null && (abilityData = AbilityData.get(this.getOwner(), this.getAbilityName())) != null) {
            int cooldown = this.getAbility().getCooldown(abilityData);
            if (this.getOwner() instanceof EntityPlayer && ((EntityPlayer)this.getOwner()).func_184812_l_()) {
                cooldown = 0;
            }
            abilityData.setAbilityCooldown(cooldown);
            abilityData.setRegenBurnout(true);
        }
        this.removeStatCtrl();
    }

    private void removeStatCtrl() {
        if (this.getOwner() != null) {
            BendingData data = Bender.get(this.getOwner()).getData();
            data.removeStatusControl(StatusControlController.BUBBLE_EXPAND);
            data.removeStatusControl(StatusControlController.BUBBLE_CONTRACT);
            IAttributeInstance attribute = this.getOwner().func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (attribute.func_111127_a(SLOW_ATTR_ID) != null) {
                attribute.func_111124_b(SLOW_ATTR);
            }
        }
    }
}

