/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityAirBubble;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.IOffensiveEntity;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAirGust
extends EntityOffensive {
    private static final DataParameter<Boolean> SYNC_SLOWS = EntityDataManager.func_187226_a(EntityAirGust.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SYNC_DESTROYS = EntityDataManager.func_187226_a(EntityAirGust.class, (DataSerializer)DataSerializers.field_187198_h);
    private boolean pushStone;
    private boolean pushIronTrapDoor;
    private boolean pushIronDoor;
    private boolean destroyGrass;
    private float exWidth;
    private float exHeight;

    public EntityAirGust(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.putsOutFires = true;
        this.field_70145_X = true;
        this.pushStoneButton = this.pushStone;
        this.pushDoor = this.pushIronDoor;
        this.pushTrapDoor = this.pushIronTrapDoor;
        this.exWidth = 0.5f;
        this.exHeight = 0.5f;
        this.destroyGrass = false;
        this.setDamage(0.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_DESTROYS, (Object)false);
        this.field_70180_af.func_187214_a(SYNC_SLOWS, (Object)false);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSlowProjectiles(nbt.func_74767_n("SlowProjectiles"));
        this.setDestroyProjectiles(nbt.func_74767_n("DestroyProjectiles"));
        this.exWidth = nbt.func_74760_g("Expanded Width");
        this.exHeight = nbt.func_74760_g("Expanded Height");
        this.destroyGrass = nbt.func_74767_n("Destroy Grass");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("SlowProjectiles", this.getSlowProjectiles());
        nbt.func_74757_a("DestroyProjectiles", this.getDestroyProjectiles());
        nbt.func_74776_a("Expanded Width", this.exWidth);
        nbt.func_74776_a("Expanded Height", this.exHeight);
        nbt.func_74757_a("Destroy Grass", this.destroyGrass);
    }

    @Override
    public BendingStyle getElement() {
        return new Airbending();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.destroyGrass && !this.field_70170_p.func_180495_p(this.func_180425_c()).func_185913_b() && this.field_70170_p.func_180495_p(this.func_180425_c()).func_185887_b(this.field_70170_p, this.func_180425_c()) <= 0.0f) {
            this.breakBlock(this.func_180425_c());
        }
        if (this.field_70173_aa <= 2) {
            this.pushStoneButton = this.pushStone;
            this.pushDoor = this.pushIronDoor;
            this.pushTrapDoor = this.pushIronTrapDoor;
        }
    }

    @Override
    public boolean pushLevers(BlockPos pos) {
        if (super.pushLevers(pos) && this.getElement() instanceof Airbending && this.getOwner() != null && this.getAbility() != null) {
            AbilityData.get(this.getOwner(), this.getAbility().getName()).addXp(this.getXpPerHit() / 2.0f);
        }
        return super.pushLevers(pos);
    }

    @Override
    public boolean pushButtons(BlockPos pos) {
        if (super.pushButtons(pos) && this.getElement() instanceof Airbending && this.getOwner() != null && this.getAbility() != null) {
            AbilityData.get(this.getOwner(), this.getAbility().getName()).addXp(this.getXpPerHit() / 2.0f);
        }
        return super.pushButtons(pos);
    }

    @Override
    public boolean pushTrapDoors(BlockPos pos) {
        if (super.pushTrapDoors(pos) && this.getElement() instanceof Airbending && this.getOwner() != null && this.getAbility() != null) {
            AbilityData.get(this.getOwner(), this.getAbility().getName()).addXp(this.getXpPerHit() / 2.0f);
        }
        return super.pushTrapDoors(pos);
    }

    @Override
    public boolean pushDoors(BlockPos pos) {
        if (super.pushGates(pos) && this.getElement() instanceof Airbending && this.getOwner() != null && this.getAbility() != null) {
            AbilityData.get(this.getOwner(), this.getAbility().getName()).addXp(this.getXpPerHit() / 2.0f);
        }
        return super.pushGates(pos);
    }

    public float getExpandedWidth() {
        return this.exWidth;
    }

    public void setExpandedWidth(float width) {
        this.exWidth = width;
    }

    public float getExpandedHeight() {
        return this.exHeight;
    }

    public void setExpandedHeight(float height) {
        this.field_70131_O = height;
    }

    public boolean getSlowProjectiles() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_SLOWS);
    }

    public void setSlowProjectiles(boolean slowProjectiles) {
        this.field_70180_af.func_187227_b(SYNC_SLOWS, (Object)slowProjectiles);
    }

    public boolean getDestroyProjectiles() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_DESTROYS);
    }

    public void setDestroyProjectiles(boolean destroyProjectiles) {
        this.field_70180_af.func_187227_b(SYNC_DESTROYS, (Object)destroyProjectiles);
    }

    public void setPushStone(boolean pushStone) {
        this.pushStone = pushStone;
    }

    public void setPushIronDoor(boolean pushIronDoor) {
        this.pushIronDoor = pushIronDoor;
    }

    public void setPushIronTrapDoor(boolean pushIronTrapDoor) {
        this.pushIronTrapDoor = pushIronTrapDoor;
    }

    public void setDestroyGrass(boolean grass) {
        this.destroyGrass = grass;
    }

    @Override
    public boolean shouldExplode() {
        return false;
    }

    @Override
    public boolean shouldDissipate() {
        return true;
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    @Override
    public void spawnDissipateParticles(World world, Vec3d pos) {
        if (world.field_72995_K && this.getOwner() != null) {
            for (int i = 0; i < 8; ++i) {
                Vec3d mid = AvatarEntityUtils.getMiddleOfEntity(this);
                double spawnX = mid.field_72450_a + world.field_73012_v.nextGaussian() / 10.0;
                double spawnY = mid.field_72448_b + world.field_73012_v.nextGaussian() / 10.0;
                double spawnZ = mid.field_72449_c + world.field_73012_v.nextGaussian() / 10.0;
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0).time(4).clr(0.95f, 0.95f, 0.95f, 0.1f).spawnEntity((Entity)this.getOwner()).scale(this.getAvgSize() * 1.25f).element(this.getElement()).collide(true).spawn(world);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextGaussian() / 20.0).time(12).clr(0.95f, 0.95f, 0.95f, 0.1f).spawnEntity((Entity)this.getOwner()).scale(this.getAvgSize() * 1.25f).element(this.getElement()).collide(true).spawn(world);
            }
        }
    }

    @Override
    public void spawnPiercingParticles(World world, Vec3d pos) {
    }

    @Override
    public void applyElementalContact(AvatarEntity entity) {
        super.applyElementalContact(entity);
        entity.onAirContact();
        if (this.getDestroyProjectiles()) {
            if (entity instanceof IOffensiveEntity && ((IOffensiveEntity)((Object)entity)).getDamage() < 6.0f * this.getAvgSize() || entity instanceof EntityOffensive && (double)this.getAvgSize() < 1.25 * (double)this.getAvgSize() || entity.isProjectile() && entity.velocity().sqrMagnitude() < this.velocity().sqrMagnitude() || entity.getTier() < this.getTier()) {
                ((IOffensiveEntity)((Object)entity)).Dissipate(entity);
            }
            if (entity.getTier() == this.getTier()) {
                this.Dissipate();
                if (entity instanceof IOffensiveEntity) {
                    ((IOffensiveEntity)((Object)entity)).Dissipate(entity);
                }
            }
        }
    }

    @Override
    public boolean multiHit() {
        return false;
    }

    @Override
    public boolean setVelocity() {
        return true;
    }

    @Override
    public SoundEvent[] getSounds() {
        SoundEvent[] events = new SoundEvent[]{SoundEvents.field_187646_bt};
        return events;
    }

    @Override
    public float getVolume() {
        return super.getVolume() * 1.5f;
    }

    @Override
    public int getFireTime() {
        return 0;
    }

    @Override
    public boolean onCollideWithSolid() {
        if (super.onCollideWithSolid()) {
            this.setVelocity(Vector.ZERO);
            this.setLifeTime(1);
        }
        return super.onCollideWithSolid();
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        super.onCollideWithEntity(entity);
        if ((entity instanceof AvatarEntity && ((AvatarEntity)entity).isProjectile() || entity instanceof EntityArrow || entity instanceof EntityThrowable) && this.getSlowProjectiles()) {
            entity.field_70159_w *= 0.4;
            entity.field_70181_x *= 0.4;
            entity.field_70179_y *= 0.4;
        }
        if (entity instanceof EntityAirBubble && ((EntityAirBubble)entity).getTier() <= this.getTier()) {
            super.onCollideWithEntity((Entity)((EntityAirBubble)entity).getOwner());
            if (!this.isPiercing()) {
                this.Dissipate();
            }
        } else if (entity instanceof EntityAirBubble) {
            this.Dissipate();
        }
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        if (entity == this.getOwner()) {
            return false;
        }
        if (entity instanceof AvatarEntity && ((AvatarEntity)entity).getOwner() == this.getOwner()) {
            return false;
        }
        if (entity instanceof EntityLivingBase && entity.func_184179_bs() == this.getOwner()) {
            return false;
        }
        return this.getOwner() == null || this.getOwner().func_96124_cp() == null || entity.func_96124_cp() == null || entity.func_96124_cp() != this.getOwner().func_96124_cp();
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public double getExpandedHitboxWidth() {
        return this.exWidth;
    }

    @Override
    public double getExpandedHitboxHeight() {
        return this.exHeight;
    }

    @Override
    public Vec3d getKnockback() {
        double x = this.getKnockbackMult().field_72450_a * this.field_70159_w;
        double y = Math.max(0.25, Math.min((this.field_70181_x + 0.15) * this.getKnockbackMult().field_72448_b, 0.25));
        double z = this.getKnockbackMult().field_72449_c * this.field_70179_y;
        double scale = 0.5f + (float)this.getTier() / 4.0f;
        return new Vec3d(x * scale, y * scale, z * scale);
    }

    @Override
    public Vec3d getKnockbackMult() {
        return new Vec3d((double)this.getPush(), (double)this.getPush(), (double)this.getPush());
    }

    @Override
    public boolean canDamageEntity(Entity entity) {
        return this.canCollideWith(entity) && this.getDamage() > 0.0f;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }
}

