/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.air.AbilityAirblade;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAirblade
extends EntityOffensive {
    private static final DataParameter<Float> SYNC_SIZE_MULT = EntityDataManager.func_187226_a(EntityAirblade.class, (DataSerializer)DataSerializers.field_187193_c);
    private float chopBlocksThreshold;
    private boolean pierceArmor;

    public EntityAirblade(World world) {
        super(world);
        this.func_70105_a(0.2f, 1.5f);
        this.chopBlocksThreshold = -1.0f;
        this.field_70145_X = true;
        this.putsOutFires = true;
    }

    public float getSizeMult() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_SIZE_MULT)).floatValue();
    }

    public void setSizeMult(float sizeMult) {
        this.field_70180_af.func_187227_b(SYNC_SIZE_MULT, (Object)Float.valueOf(sizeMult));
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    public void func_174829_m() {
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_SIZE_MULT, (Object)Float.valueOf(1.0f));
    }

    @Override
    public BendingStyle getElement() {
        return new Airbending();
    }

    @Override
    public void applyElementalContact(AvatarEntity entity) {
        super.applyElementalContact(entity);
        entity.onAirContact();
    }

    @Override
    public boolean shouldExplode() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.chopBlocksThreshold >= 0.0f) {
            this.breakCollidingBlocks();
        }
    }

    private void breakCollidingBlocks() {
        double expansion = this.getSizeMult() / 20.0f;
        AxisAlignedBB hitbox = this.func_174813_aQ().func_72314_b(expansion, expansion, expansion);
        int iy = 0;
        while ((float)iy <= this.getSizeMult() * 1.5f) {
            for (int ix = 0; ix <= 1; ++ix) {
                for (int iz = 0; iz <= 1; ++iz) {
                    double x = ix == 0 ? hitbox.field_72340_a : hitbox.field_72336_d;
                    double y = iy == 0 ? hitbox.field_72338_b : hitbox.field_72337_e;
                    double z = iz == 0 ? hitbox.field_72339_c : hitbox.field_72334_f;
                    BlockPos pos = new BlockPos(x, y, z);
                    this.tryBreakBlock(this.field_70170_p.func_180495_p(pos), pos);
                }
            }
            ++iy;
        }
    }

    private void tryBreakBlock(IBlockState state, BlockPos pos) {
        if (state.func_177230_c() == Blocks.field_150350_a || !ConfigStats.STATS_CONFIG.airBladeBreakableBlocks.contains(state.func_177230_c())) {
            return;
        }
        float hardness = state.func_185887_b(this.field_70170_p, pos);
        if (hardness <= this.chopBlocksThreshold) {
            this.breakBlock(pos);
            this.setVelocity(this.velocity().times(0.95));
        }
    }

    public Bender getOwnerBender() {
        return Bender.get(this.getOwner());
    }

    public float getChopBlocksThreshold() {
        return this.chopBlocksThreshold;
    }

    public void setChopBlocksThreshold(float chopBlocksThreshold) {
        this.chopBlocksThreshold = chopBlocksThreshold;
    }

    public boolean getPierceArmor() {
        return this.pierceArmor;
    }

    public void setPierceArmor(boolean piercing) {
        this.pierceArmor = piercing;
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.chopBlocksThreshold = nbt.func_74760_g("ChopBlocksThreshold");
        this.pierceArmor = nbt.func_74767_n("Piercing");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("ChopBlocksThreshold", this.chopBlocksThreshold);
        nbt.func_74757_a("Piercing", this.pierceArmor);
    }

    @Override
    public boolean onCollideWithSolid() {
        if (this.chopBlocksThreshold > 0.0f) {
            return super.onCollideWithSolid();
        }
        return false;
    }

    @Override
    public void spawnExplosionParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnDissipateParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnPiercingParticles(World world, Vec3d pos) {
    }

    @Override
    public boolean shouldDissipate() {
        return true;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean isPiercing() {
        return this.getAbility() instanceof AbilityAirblade && AbilityData.get(this.getOwner(), this.getAbility().getName()).getLevel() == 3;
    }

    @Override
    public Vec3d getKnockbackMult() {
        return new Vec3d(ConfigStats.STATS_CONFIG.airbladeSettings.push, ConfigStats.STATS_CONFIG.airbladeSettings.push * 2.0, ConfigStats.STATS_CONFIG.airbladeSettings.push);
    }

    @Override
    public int getFireTime() {
        return 0;
    }

    @Override
    public double getExpandedHitboxWidth() {
        return this.field_70130_N / 2.0f;
    }

    @Override
    public double getExpandedHitboxHeight() {
        return this.getHeight() / 4.0f;
    }

    @Override
    public SoundEvent[] getSounds() {
        SoundEvent[] events = new SoundEvent[]{SoundEvents.field_187646_bt};
        return events;
    }

    @Override
    public float getVolume() {
        return super.getVolume() * 6.0f;
    }
}

