/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.entity.ControlPoint;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.gorecore.util.Vector;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityArc<T extends ControlPoint>
extends EntityOffensive {
    private static final DataParameter<Integer> SYNC_POINTS = EntityDataManager.func_187226_a(EntityArc.class, (DataSerializer)DataSerializers.field_187192_b);
    public List<T> points;
    private int brightness = 0xF000F0;

    public EntityArc(World world) {
        super(world);
        float size = 0.2f;
        this.func_70105_a(size, size);
        this.points = new ArrayList<T>();
        for (int i = 0; i < this.getAmountOfControlPoints(); ++i) {
            this.points.add(this.createControlPoint(size, i));
        }
    }

    public void setNumberofPoints(int points) {
        this.field_70180_af.func_187227_b(SYNC_POINTS, (Object)points);
    }

    public int getNumberofPoints() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_POINTS);
    }

    protected T createControlPoint(float size, int index) {
        return (T)new ControlPoint(this, size, 0.0, 0.0, 0.0);
    }

    protected Consumer<EntityLivingBase> getNewOwnerCallback() {
        return newOwner -> {};
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa == 1) {
            for (ControlPoint point : this.points) {
                point.setPosition(this.position());
            }
        }
        this.brightness = !this.field_70170_p.func_72935_r() ? 500 : 0xF000F0;
        this.field_70158_ak = true;
        this.updateControlPoints();
    }

    private void updateControlPoints() {
        this.updateCpBehavior();
        for (ControlPoint cp : this.points) {
            cp.onUpdate();
        }
    }

    protected void updateCpBehavior() {
        ((ControlPoint)this.getLeader()).setPosition(this.position().plusY(this.field_70131_O / 2.0f));
        ((ControlPoint)this.getLeader()).setVelocity(this.velocity());
        for (int i = 1; i < this.points.size(); ++i) {
            ControlPoint leader = (ControlPoint)this.points.get(i - 1);
            ControlPoint p = (ControlPoint)this.points.get(i);
            Vector leadPos = leader.position();
            double sqrDist = p.position().sqrDist(leadPos);
            if (sqrDist > this.getControlPointTeleportDistanceSq() && this.getControlPointTeleportDistanceSq() != -1.0) {
                Vector toFollowerDir = p.position().minus(leader.position()).normalize();
                double idealDist = Math.sqrt(this.getControlPointTeleportDistanceSq());
                if (idealDist > 1.0) {
                    idealDist -= 1.0;
                }
                Vector revisedOffset = leader.position().plus(toFollowerDir.times(idealDist));
                p.setPosition(revisedOffset);
                leader.setPosition(revisedOffset);
                p.setVelocity(Vector.ZERO);
                continue;
            }
            if (!(sqrDist > this.getControlPointMaxDistanceSq()) || this.getControlPointMaxDistanceSq() == -1.0) continue;
            Vector diff = leader.position().minus(p.position());
            diff = diff.normalize().times(this.getVelocityMultiplier());
            p.setVelocity(p.velocity().plus(diff));
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
    }

    public void func_70634_a(double x, double y, double z) {
        super.func_70634_a(x, y, z);
        if (this.points != null) {
            ((ControlPoint)this.getLeader()).setPosition(new Vector(x, y, z));
        }
    }

    public List<T> getControlPoints() {
        return this.points;
    }

    public T getControlPoint(int index) {
        return (T)((ControlPoint)this.points.get(index));
    }

    public T getLeader() {
        return this.getControlPoint(0);
    }

    public T getLeader(int index) {
        return this.getControlPoint(index == 0 ? index : index - 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double d) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return this.brightness;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_POINTS, (Object)6);
    }

    @Override
    public void setOwner(EntityLivingBase owner) {
        super.setOwner(owner);
        for (ControlPoint cp : this.points) {
            cp.setOwner(owner);
        }
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    public int getAmountOfControlPoints() {
        return this.getNumberofPoints();
    }

    protected double getControlPointMaxDistanceSq() {
        return 1.0;
    }

    protected double getControlPointTeleportDistanceSq() {
        return 16.0;
    }

    protected double getVelocityMultiplier() {
        return 4.0;
    }
}

