/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.lightning.AbilityLightningRaze;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityLightningSpawner;
import com.crowsofwar.avatar.util.damageutils.AvatarDamageSource;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;

@Mod.EventBusSubscriber(modid="avatarmod")
@Optional.Interface(iface="com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity", modid="hammercore")
public class EntityAvatarLightning
extends EntityLightningBolt
implements IGlowingEntity {
    public long field_70264_a;
    private int lightningState;
    private int boltLivingTime;
    private EntityLightningSpawner spawner;

    EntityAvatarLightning(World world, double x, double y, double z) {
        super(world, x, y, z, false);
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.lightningState = 2;
        this.field_70264_a = this.field_70146_Z.nextLong();
        this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
        BlockPos blockpos = new BlockPos((Entity)this);
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doFireTick") && world.func_175697_a(blockpos, 10)) {
            if (world.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a && Blocks.field_150480_ab.func_176196_c(world, blockpos)) {
                world.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
            }
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1);
                if (world.func_180495_p(blockpos1).func_185904_a() != Material.field_151579_a || !Blocks.field_150480_ab.func_176196_c(world, blockpos1)) continue;
                world.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    void setSpawner(EntityLightningSpawner spawner) {
        this.spawner = spawner;
    }

    void setBoltLivingTime(int livingTime) {
        this.boltLivingTime = livingTime;
    }

    public void func_70088_a() {
        super.func_70088_a();
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.WEATHER;
    }

    public void func_70071_h_() {
        if (this.lightningState == 2) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.func_70106_y();
            } else if (this.lightningState < -this.field_70146_Z.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70264_a = this.field_70146_Z.nextLong();
                    BlockPos blockpos = new BlockPos((Entity)this);
                    if (this.field_70170_p.func_82736_K().func_82766_b("doFireTick") && this.field_70170_p.func_175697_a(blockpos, 10) && this.field_70170_p.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a && Blocks.field_150480_ab.func_176196_c(this.field_70170_p, blockpos)) {
                        this.field_70170_p.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                    }
                }
            }
        }
        if (this.lightningState >= 0) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175702_c(2);
            } else if (!this.field_70170_p.field_72995_K) {
                List list = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.field_70165_t - 1.5, this.field_70163_u - 1.5, this.field_70161_v - 1.5, this.field_70165_t + 1.5, this.field_70163_u + 6.0 + 1.5, this.field_70161_v + 1.5));
                for (Entity entity : list) {
                    if (entity instanceof AvatarEntity) {
                        ((AvatarEntity)entity).onFireContact();
                        continue;
                    }
                    if (entity instanceof EntityItem || entity instanceof EntityItemFrame || entity instanceof EntityPainting || entity instanceof EntityXPOrb) continue;
                    this.handleCollision(entity);
                }
            }
        }
    }

    private void handleCollision(Entity collided) {
        this.damageEntity(collided);
        collided.func_70015_d(8);
    }

    private void damageEntity(Entity entity) {
        BendingData data1;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        DamageSource damageSource = AvatarDamageSource.causeLightningDamage(entity, (Entity)this.spawner.getOwner());
        float damage = ConfigStats.STATS_CONFIG.lightningRazeSettings.damage;
        if (this.spawner.getAbility() instanceof AbilityLightningRaze) {
            AbilityData aD = AbilityData.get(this.spawner.getOwner(), this.spawner.getAbility().getName());
            if (aD.getLevel() >= 2) {
                damage = ConfigStats.STATS_CONFIG.lightningRazeSettings.damage * 1.5f;
            }
            if (aD.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
                damage = ConfigStats.STATS_CONFIG.lightningRazeSettings.damage * 2.5f;
            }
            if (aD.isMasterPath(AbilityData.AbilityTreePath.SECOND)) {
                damage = ConfigStats.STATS_CONFIG.lightningRazeSettings.damage * 0.25f;
            }
        }
        if (entity.func_70097_a(damageSource, damage) && this.spawner.getOwner() != null && (data1 = BendingData.getFromEntity(this.spawner.getOwner())) != null) {
            AbilityData abilityData1 = data1.getAbilityData("lightning_raze");
            abilityData1.addXp(ConfigSkills.SKILLS_CONFIG.struckWithLightning);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
    }

    @Optional.Method(modid="hammercore")
    public ColoredLight produceColoredLight(float v) {
        return ColoredLight.builder().color(1.0f, 2.0f, 3.0f).radius(15.0f).pos((Entity)this).build();
    }
}

