/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.bending.bending.air.powermods.CloudburstPowerModifier;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.entity.data.CloudburstBehavior;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.avatar.util.data.TickHandlerController;
import com.crowsofwar.avatar.util.data.ctx.BendingContext;
import com.crowsofwar.gorecore.util.Vector;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCloudBall
extends EntityOffensive {
    public static final DataParameter<Integer> SYNC_SIZE = EntityDataManager.func_187226_a(EntityCloudBall.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<CloudburstBehavior> SYNC_BEHAVIOR = EntityDataManager.func_187226_a(EntityCloudBall.class, CloudburstBehavior.DATA_SERIALIZER);
    private boolean absorbtion;
    private boolean chismash;
    private boolean pushStone;
    private boolean pushIronTrapDoor;
    private boolean pushIronDoor;

    public EntityCloudBall(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.8f);
        this.putsOutFires = true;
        this.pushStoneButton = this.pushStone;
        this.pushDoor = this.pushIronDoor;
        this.pushTrapDoor = this.pushIronTrapDoor;
    }

    @Override
    public BendingStyle getElement() {
        return new Airbending();
    }

    @Override
    public boolean pushLevers(BlockPos pos) {
        if (super.pushLevers(pos) && this.getElement() instanceof Airbending && this.getOwner() != null && this.getAbility() != null) {
            AbilityData.get(this.getOwner(), this.getAbility().getName()).addXp(this.getXpPerHit() / 2.0f);
        }
        return super.pushLevers(pos);
    }

    @Override
    public boolean pushButtons(BlockPos pos) {
        if (super.pushButtons(pos) && this.getElement() instanceof Airbending && this.getOwner() != null && this.getAbility() != null) {
            AbilityData.get(this.getOwner(), this.getAbility().getName()).addXp(this.getXpPerHit() / 2.0f);
        }
        return super.pushButtons(pos);
    }

    @Override
    public boolean pushTrapDoors(BlockPos pos) {
        if (super.pushTrapDoors(pos) && this.getElement() instanceof Airbending && this.getOwner() != null && this.getAbility() != null) {
            AbilityData.get(this.getOwner(), this.getAbility().getName()).addXp(this.getXpPerHit() / 2.0f);
        }
        return super.pushTrapDoors(pos);
    }

    @Override
    public boolean pushDoors(BlockPos pos) {
        if (super.pushGates(pos) && this.getElement() instanceof Airbending && this.getOwner() != null && this.getAbility() != null) {
            AbilityData.get(this.getOwner(), this.getAbility().getName()).addXp(this.getXpPerHit() / 2.0f);
        }
        return super.pushGates(pos);
    }

    public void setAbsorb(boolean canAbsorb) {
        this.absorbtion = canAbsorb;
    }

    public void setChiSmash(boolean canchiSmash) {
        this.chismash = canchiSmash;
    }

    public void setPushStoneButton(boolean pushStone) {
        this.pushStone = pushStone;
    }

    public void setPushIronDoor(boolean pushDoor) {
        this.pushIronDoor = pushDoor;
    }

    public void setPushIronTrapDoor(boolean trapDoor) {
        this.pushIronTrapDoor = trapDoor;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_BEHAVIOR, (Object)new CloudburstBehavior.Idle());
        this.field_70180_af.func_187214_a(SYNC_SIZE, (Object)30);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa <= 2) {
            this.pushStoneButton = this.pushStone;
            this.pushDoor = this.pushIronDoor;
            this.pushTrapDoor = this.pushIronTrapDoor;
        }
        if (this.getBehavior() == null) {
            this.setBehavior(new CloudburstBehavior.PlayerControlled());
        }
        this.setBehavior((CloudburstBehavior)this.getBehavior().onUpdate(this));
        if (this.field_70173_aa % 2 == 0) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.05f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        if (this.getOwner() == null) {
            this.Dissipate();
        }
        if (this.getOwner() != null && Bender.isBenderSupported(this.getOwner())) {
            EntityCloudBall ball = AvatarEntity.lookupControlledEntity(this.field_70170_p, EntityCloudBall.class, this.getOwner());
            BendingData bD = BendingData.getFromEntity(this.getOwner());
            if (ball == null && bD.hasStatusControl(StatusControlController.THROW_CLOUDBURST)) {
                bD.removeStatusControl(StatusControlController.THROW_CLOUDBURST);
            }
            if (ball != null && ball.getBehavior() instanceof CloudburstBehavior.PlayerControlled && !bD.hasStatusControl(StatusControlController.THROW_CLOUDBURST)) {
                bD.addStatusControl(StatusControlController.THROW_CLOUDBURST);
            }
        }
        if (this.field_70170_p.field_72995_K) {
            AxisAlignedBB boundingBox = this.func_174813_aQ();
            double spawnX = boundingBox.field_72340_a + this.field_70170_p.field_73012_v.nextDouble() * (boundingBox.field_72336_d - boundingBox.field_72340_a);
            double spawnY = boundingBox.field_72338_b + this.field_70170_p.field_73012_v.nextDouble() * (boundingBox.field_72337_e - boundingBox.field_72338_b);
            double spawnZ = boundingBox.field_72339_c + this.field_70170_p.field_73012_v.nextDouble() * (boundingBox.field_72334_f - boundingBox.field_72339_c);
            ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 60.0, this.field_70170_p.field_73012_v.nextGaussian() / 60.0, this.field_70170_p.field_73012_v.nextGaussian() / 60.0).time(12).clr(0.95f, 0.95f, 0.95f, 0.1f).scale((float)this.getSize() * 0.03125f * 2.0f).element(new Airbending()).spawn(this.field_70170_p);
            if (this.getBehavior() instanceof CloudburstBehavior.Thrown) {
                for (int i = 0; i < 4; ++i) {
                    Vec3d pos = Vector.getOrthogonalVector(this.func_70040_Z(), (double)(i * 90 + this.field_70173_aa % 360 * 10), (double)this.getAvgSize()).toMinecraft();
                    Vec3d entityPos = AvatarEntityUtils.getMiddleOfEntity(this);
                    pos = pos.func_178787_e(entityPos);
                    Vec3d velocity = pos.func_178788_d(entityPos).func_72432_b();
                    velocity = velocity.func_186678_a(AvatarUtils.getSqrMagnitude(this.getVelocity()) / 400000.0);
                    spawnX = pos.field_72450_a;
                    spawnY = pos.field_72448_b;
                    spawnZ = pos.field_72449_c;
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 80.0 + velocity.field_72450_a, this.field_70170_p.field_73012_v.nextGaussian() / 80.0 + velocity.field_72448_b, this.field_70170_p.field_73012_v.nextGaussian() / 80.0 + velocity.field_72449_c).time(6 + AvatarUtils.getRandomNumberInRange(0, 4)).clr(0.95f, 0.95f, 0.95f, 0.1f).spawnEntity((Entity)this.getOwner()).scale(0.75f * this.getAvgSize() * (1.0f / this.getAvgSize())).element(new Airbending()).collide(true).spawn(this.field_70170_p);
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 80.0 + velocity.field_72450_a, this.field_70170_p.field_73012_v.nextGaussian() / 80.0 + velocity.field_72448_b, this.field_70170_p.field_73012_v.nextGaussian() / 80.0 + velocity.field_72449_c).time(10 + AvatarUtils.getRandomNumberInRange(0, 6)).clr(0.95f, 0.95f, 0.95f, 0.1f).spawnEntity((Entity)this.getOwner()).scale(0.75f * this.getAvgSize() * (1.0f / this.getAvgSize())).element(new Airbending()).collide(true).spawn(this.field_70170_p);
                }
            }
        }
        this.setEntitySize((float)this.getSize() * 0.03125f);
    }

    public CloudburstBehavior getBehavior() {
        return (CloudburstBehavior)this.field_70180_af.func_187225_a(SYNC_BEHAVIOR);
    }

    public void setBehavior(CloudburstBehavior behavior) {
        this.field_70180_af.func_187227_b(SYNC_BEHAVIOR, (Object)behavior);
    }

    @Override
    public EntityLivingBase getController() {
        return this.getBehavior() instanceof CloudburstBehavior.PlayerControlled ? this.getOwner() : null;
    }

    public int getSize() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_SIZE);
    }

    public void setSize(int size) {
        this.field_70180_af.func_187227_b(SYNC_SIZE, (Object)size);
    }

    public void func_70106_y() {
        BendingData data;
        super.func_70106_y();
        if (this.getOwner() != null && !this.field_70170_p.field_72995_K && this.field_70128_L && (data = BendingData.getFromEntity(this.getOwner())) != null) {
            data.addTickHandler(TickHandlerController.AIR_STATCTRL_HANDLER, new BendingContext(data, this.getOwner(), new Raytrace.Result()));
        }
        this.removeStatCtrl();
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        if (this.getOwner() != null) {
            if (this.absorbtion) {
                if (entity instanceof EntityOffensive && ((EntityOffensive)entity).isProjectile() && (double)((EntityOffensive)entity).getDamage() <= 1.25 * (double)this.getDamage() && ((EntityOffensive)entity).velocity().sqrMagnitude() <= this.velocity().sqrMagnitude() * 1.25) {
                    ((EntityOffensive)entity).Dissipate();
                    this.setDamage(this.getDamage() + ((EntityOffensive)entity).getDamage() / 2.0f);
                }
                if (entity instanceof EntityArrow) {
                    entity.func_70106_y();
                    this.setDamage(this.getDamage() + 2.0f);
                }
                if (entity instanceof EntityThrowable) {
                    entity.func_70106_y();
                    this.setDamage(this.getDamage() + 1.0f);
                }
            }
            if (this.getBehavior() instanceof CloudburstBehavior.Thrown) {
                BendingData data;
                if (this.chismash && entity instanceof EntityLivingBase && (data = BendingData.getFromEntity((EntityLivingBase)entity)) != null) {
                    for (UUID uuid : data.getAllBendingIds()) {
                        CloudburstPowerModifier cloudModifier = new CloudburstPowerModifier();
                        cloudModifier.setTicks(100);
                        Objects.requireNonNull(data.getPowerRatingManager(uuid)).addModifier(cloudModifier, new BendingContext(data, (EntityLivingBase)entity, new Raytrace.Result()));
                    }
                }
                super.onCollideWithEntity(entity);
            }
        }
    }

    @Override
    public boolean func_70067_L() {
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setBehavior((CloudburstBehavior)Behavior.lookup(nbt.func_74762_e("Behavior"), this));
        this.setAbsorb(nbt.func_74767_n("Absorb"));
        this.setChiSmash(nbt.func_74767_n("ChiSmash"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Behavior", this.getBehavior().getId());
        nbt.func_74757_a("Absorb", this.absorbtion);
        nbt.func_74757_a("ChiSmash", this.chismash);
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return super.shouldRenderInPass(pass);
    }

    private void removeStatCtrl() {
        if (this.getOwner() != null) {
            BendingData data = Objects.requireNonNull(Bender.get(this.getOwner())).getData();
            data.removeStatusControl(StatusControlController.THROW_CLOUDBURST);
        }
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean pushButton(boolean pushStone) {
        return true;
    }

    @Override
    public boolean pushLever() {
        return true;
    }

    @Override
    public boolean pushTrapdoor(boolean pushIron) {
        return true;
    }

    @Override
    public boolean pushDoor(boolean pushIron) {
        return true;
    }

    @Override
    public boolean pushGate() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    @Override
    public double getExpandedHitboxWidth() {
        return (float)this.getSize() * 0.03125f / 2.0f;
    }

    @Override
    public double getExpandedHitboxHeight() {
        return (float)this.getSize() * 0.03125f / 2.0f;
    }

    @Override
    public void spawnExplosionParticles(World world, Vec3d pos) {
        if (world.field_72995_K) {
            for (int i = 0; i < this.getSize(); ++i) {
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).scale(this.getAvgSize()).collide(true).vel(world.field_73012_v.nextGaussian() / 10.0, world.field_73012_v.nextGaussian() / 10.0, world.field_73012_v.nextGaussian() / 10.0).time(8).pos(AvatarEntityUtils.getMiddleOfEntity(this)).clr(0.95f, 0.95f, 0.95f, 0.2f).element(this.getElement()).spawn(world);
            }
        }
    }

    @Override
    public void spawnDissipateParticles(World world, Vec3d pos) {
        if (world.field_72995_K) {
            for (int i = 0; i < this.getSize(); ++i) {
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).scale(this.getAvgSize()).collide(true).vel(world.field_73012_v.nextGaussian() / 40.0, world.field_73012_v.nextGaussian() / 40.0, world.field_73012_v.nextGaussian() / 40.0).time(8).pos(AvatarEntityUtils.getMiddleOfEntity(this)).clr(0.95f, 0.95f, 0.95f, 0.2f).element(this.getElement()).spawn(world);
            }
        }
    }

    @Override
    public boolean shouldDissipate() {
        return this.getBehavior() instanceof CloudburstBehavior.Thrown;
    }

    @Override
    public boolean shouldExplode() {
        return this.getBehavior() instanceof CloudburstBehavior.Thrown;
    }

    @Override
    public SoundEvent[] getSounds() {
        SoundEvent[] events = new SoundEvent[]{SoundEvents.field_187646_bt};
        return events;
    }

    @Override
    public float getVolume() {
        return super.getVolume() * 5.0f;
    }

    @Override
    public Vec3d getKnockbackMult() {
        return new Vec3d(1.5, 1.0, 1.5);
    }

    @Override
    public Vec3d getExplosionKnockbackMult() {
        return new Vec3d(0.5, 0.75, 0.5);
    }

    @Override
    public int getFireTime() {
        return 0;
    }
}

