/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityEarthspike
extends EntityOffensive {
    private static final DataParameter<Boolean> SYNC_ANGLED = EntityDataManager.func_187226_a(EntityEarthspike.class, (DataSerializer)DataSerializers.field_187198_h);
    int sizeTicks = 0;

    public EntityEarthspike(World world) {
        super(world);
        this.func_184189_br();
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    @Override
    public boolean shouldExplode() {
        return false;
    }

    @Override
    public boolean shouldDissipate() {
        return this.field_70173_aa >= this.getLifeTime();
    }

    @Override
    public boolean isPiercing() {
        return true;
    }

    @Override
    public BendingStyle getElement() {
        return new Earthbending();
    }

    @Override
    public void spawnDissipateParticles(World world, Vec3d pos) {
        if (world.field_72995_K) {
            int i = 0;
            while ((double)i < (double)this.getLifeTime() * 0.5) {
                world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, world.field_73012_v.nextGaussian() / 20.0, world.field_73012_v.nextDouble() / 20.0, world.field_73012_v.nextGaussian() / 20.0, new int[]{Block.func_176210_f((IBlockState)world.func_180495_p(this.func_180425_c().func_177977_b()))});
                ++i;
            }
        }
    }

    @Override
    public void spawnExplosionParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnPiercingParticles(World world, Vec3d pos) {
    }

    @Override
    public void Dissipate() {
        float heightMult = this.getHeight() >= 1.0f ? 0.8f * this.getHeight() : (float)Math.pow(this.getHeight(), 1.25);
        float widthMult = this.getWidth() >= 1.0f ? 0.8f * this.getWidth() : (float)Math.pow(this.getWidth(), 1.25);
        this.setEntitySize(heightMult / 1.075f, widthMult / 1.125f);
        if ((double)this.getHeight() < 0.125 && this.shouldDissipate()) {
            this.spawnDissipateParticles(this.field_70170_p, AvatarEntityUtils.getBottomMiddleOfEntity(this));
            this.func_70106_y();
        }
    }

    @Override
    @Nullable
    public SoundEvent[] getSounds() {
        return new SoundEvent[0];
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70159_w *= 0.0;
        this.field_70181_x *= 0.0;
        this.field_70179_y *= 0.0;
        IBlockState inBlock = this.field_70170_p.func_180495_p(this.func_180425_c());
        if (inBlock.func_177230_c() != Blocks.field_150350_a && !inBlock.func_185913_b()) {
            if (inBlock.func_185887_b(this.field_70170_p, this.func_180425_c()) == 0.0f) {
                this.breakBlock(this.func_180425_c());
            } else {
                this.func_70106_y();
            }
        }
        if (!this.shouldDissipate()) {
            float widthMult;
            float heightMult = this.getHeight() <= 1.0f ? 1.25f * this.getHeight() : (float)Math.pow(this.getHeight(), 1.25);
            float f = widthMult = this.getWidth() <= 1.0f ? 1.25f * this.getWidth() : (float)Math.pow(this.getWidth(), 1.25);
            if (this.getHeight() < this.getMaxHeight()) {
                this.setEntitySize(heightMult * 1.125f, this.getWidth());
            } else {
                this.setEntitySize(this.getMaxHeight(), this.getWidth());
            }
            if (this.getWidth() < this.getMaxWidth()) {
                this.setEntitySize(this.getHeight(), widthMult * 1.125f);
            } else {
                this.setEntitySize(this.getHeight(), this.getMaxWidth());
            }
            if (!Earthbending.isBendable(this.field_70170_p, this.func_180425_c(), this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()), 2)) {
                this.Dissipate();
            }
            if (this.getMaxWidth() == this.getWidth()) {
                ++this.sizeTicks;
            }
            if (this.sizeTicks <= 1) {
                this.spawnDissipateParticles(this.field_70170_p, AvatarEntityUtils.getBottomMiddleOfEntity(this));
            }
        }
    }

    @Override
    public Vec3d getKnockbackMult() {
        Vec3d vec = super.getKnockbackMult();
        vec = new Vec3d(vec.field_72450_a / 2.0, vec.field_72448_b * 4.0, vec.field_72448_b / 2.0);
        return vec;
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    @Override
    public int getFireTime() {
        return 0;
    }

    public void func_174829_m() {
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_ANGLED, (Object)false);
    }

    public void setAngled(boolean angled) {
        this.field_70180_af.func_187227_b(SYNC_ANGLED, (Object)angled);
    }

    public boolean isAngled() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_ANGLED);
    }
}

