/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.EarthspikesBehavior;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityEarthspikeSpawner
extends EntityOffensive {
    private static final DataParameter<EarthspikesBehavior> SPIKES_BEHAVIOR = EntityDataManager.func_187226_a(EntityEarthspikeSpawner.class, EarthspikesBehavior.SERIALIZER);
    private boolean unstoppable;
    private double maxTicksAlive;
    private SpikesType type;
    private double spikeSize;
    private final BlockPos targetPos;

    public EntityEarthspikeSpawner(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.targetPos = new BlockPos(0, 0, 0);
    }

    public SpikesType getType() {
        return this.type;
    }

    public void setType(SpikesType isType) {
        this.type = isType;
    }

    public boolean getUnstoppable() {
        return this.unstoppable;
    }

    public void setUnstoppable(boolean isUnstoppable) {
        this.unstoppable = isUnstoppable;
    }

    public double getDuration() {
        return this.maxTicksAlive;
    }

    public void setDuration(double ticks) {
        this.maxTicksAlive = ticks;
    }

    public double getSize() {
        return this.spikeSize;
    }

    public void setSize(double size) {
        this.spikeSize = size;
    }

    @Override
    public float getDamage() {
        return super.getDamage();
    }

    @Override
    public void setDamage(float damage) {
        super.setDamage(damage);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
    }

    @Override
    public EntityLivingBase getController() {
        return this.getOwner();
    }

    @Override
    public boolean func_70067_L() {
        return false;
    }

    @Override
    @Nullable
    public SoundEvent[] getSounds() {
        return new SoundEvent[0];
    }

    @Override
    public void spawnDissipateParticles(World world, Vec3d pos) {
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPIKES_BEHAVIOR, (Object)new EarthspikesBehavior.Init());
    }

    public EarthspikesBehavior getBehavior() {
        return (EarthspikesBehavior)this.field_70180_af.func_187225_a(SPIKES_BEHAVIOR);
    }

    public void setBehavior(EarthspikesBehavior behavior) {
        this.field_70180_af.func_187227_b(SPIKES_BEHAVIOR, (Object)behavior);
    }

    @Override
    public boolean isPiercing() {
        return true;
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
    }

    @Override
    public void func_70071_h_() {
        IBlockState inBlock;
        super.func_70071_h_();
        if ((double)this.field_70173_aa >= this.maxTicksAlive) {
            this.Dissipate();
        }
        if (this.func_180425_c() == this.targetPos || this.func_174818_b(this.targetPos) < 1.0) {
            this.Dissipate();
        }
        BlockPos below = this.func_180425_c().func_177972_a(EnumFacing.DOWN);
        Block belowBlock = this.field_70170_p.func_180495_p(below).func_177230_c();
        if (this.field_70173_aa % 3 == 0) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.func_180495_p(below).func_177230_c().func_185467_w().func_185845_c(), SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        }
        if (!this.field_70170_p.func_180495_p(below).func_185915_l()) {
            this.func_70106_y();
        }
        if (!(this.field_70170_p.field_72995_K || ConfigStats.STATS_CONFIG.bendableBlocks.contains(belowBlock) || this.unstoppable)) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && belowBlock == Blocks.field_150350_a) {
            this.func_70106_y();
        }
        if ((inBlock = this.field_70170_p.func_180495_p(this.func_180425_c())).func_185913_b()) {
            this.func_70106_y();
        }
        if (inBlock.func_177230_c() != Blocks.field_150350_a && !inBlock.func_185913_b()) {
            if (inBlock.func_185887_b(this.field_70170_p, this.func_180425_c()) == 0.0f) {
                this.breakBlock(this.func_180425_c());
            } else {
                this.func_70106_y();
            }
        }
        this.setBehavior((EarthspikesBehavior)this.getBehavior().onUpdate(this));
    }

    public void func_70106_y() {
        AttributeModifier modifier;
        if (this.getOwner() != null && (modifier = this.getOwner().func_110148_a(SharedMonsterAttributes.field_111263_d).func_111127_a(EarthspikesBehavior.MOVEMENT_MODIFIER_ID)) != null && this.getOwner().func_110148_a(SharedMonsterAttributes.field_111263_d).func_180374_a(modifier)) {
            this.getOwner().func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(EarthspikesBehavior.MOVEMENT_MODIFIER_ID);
        }
        super.func_70106_y();
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return false;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public BendingStyle getElement() {
        return new Earthbending();
    }

    public static enum SpikesType {
        LINE,
        OCTOPUS;

    }
}

