/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.AvatarEntity;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityExplosionSpawner
extends AvatarEntity {
    private double maxTicksAlive;
    private float explosionStrength;
    private float frequency;

    public EntityExplosionSpawner(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.func_180427_aV();
        this.func_82150_aj();
    }

    public void maxTicks(float ticks) {
        this.maxTicksAlive = ticks;
    }

    public void setExplosionStrength(float explosionStrength) {
        this.explosionStrength = explosionStrength;
    }

    public void setExplosionFrequency(float explosionFrequency) {
        this.frequency = explosionFrequency;
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.func_70106_y();
    }

    @Override
    public void func_70071_h_() {
        IBlockState inBlock;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && (double)this.field_70173_aa >= this.maxTicksAlive) {
            this.func_70106_y();
        }
        BlockPos below = this.func_180425_c().func_177972_a(EnumFacing.DOWN);
        Block belowBlock = this.field_70170_p.func_180495_p(below).func_177230_c();
        if (this.field_70173_aa % 3 == 0) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.func_180495_p(below).func_177230_c().func_185467_w().func_185845_c(), SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        }
        float explosionSize = ConfigStats.STATS_CONFIG.explosionSettings.explosionSize * this.explosionStrength;
        explosionSize = (float)((double)explosionSize + this.getPowerRating() * 2.0 / 100.0);
        if (this.field_70173_aa >= 5 && (float)this.field_70173_aa % this.frequency == 0.0f) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, explosionSize, false);
        }
        if (!this.field_70170_p.func_180495_p(below).func_185915_l()) {
            this.func_70106_y();
        }
        if ((inBlock = this.field_70170_p.func_180495_p(this.func_180425_c())).func_185913_b()) {
            this.func_70106_y();
        }
        if (inBlock.func_177230_c() != Blocks.field_150350_a && !inBlock.func_185913_b()) {
            if (inBlock.func_185887_b(this.field_70170_p, this.func_180425_c()) == 0.0f) {
                this.breakBlock(this.func_180425_c());
            } else {
                this.func_70106_y();
            }
        }
        for (int i = 0; i < 2; ++i) {
            double x = this.field_70165_t + this.field_70146_Z.nextGaussian() * 0.15;
            double z = this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.15;
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, this.field_70163_u, z, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.field_70146_Z.nextDouble() < 0.08) {
            double smokeX = this.field_70165_t + this.field_70146_Z.nextGaussian() * 0.15;
            double smokeZ = this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.15;
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, smokeX, this.field_70163_u, smokeZ, 0.0, 0.0, 0.0, new int[0]);
            for (int i = 0; i < 3; ++i) {
                double fireX = this.field_70165_t + this.field_70146_Z.nextGaussian() * 0.4;
                double fireY = this.field_70163_u + this.field_70146_Z.nextDouble() * 0.4;
                double fireZ = this.field_70161_v + this.field_70146_Z.nextGaussian() * 0.4;
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, fireX, fireY, fireZ, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return false;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean onCollideWithSolid() {
        this.func_70106_y();
        return false;
    }
}

