/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.FireballBehavior;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.gorecore.util.Vector;
import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity;
import java.util.Objects;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity", modid="hammercore")
public class EntityFireball
extends EntityOffensive
implements IGlowingEntity {
    private static final DataParameter<Integer> SYNC_ORBIT_ID = EntityDataManager.func_187226_a(EntityFireball.class, (DataSerializer)DataSerializers.field_187192_b);
    private static int nextFireballID = 0;

    public EntityFireball(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.8f);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.setOrbitID(nextFireballID++);
        }
        this.lightTnt = true;
    }

    @Override
    public BendingStyle getElement() {
        return new Firebending();
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_ORBIT_ID, (Object)1);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getBehaviour() == null) {
            this.func_70016_h(this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian(), this.field_70170_p.field_73012_v.nextGaussian());
            this.setBehaviour(new FireballBehavior.Thrown());
        }
        if (this.field_70173_aa % 30 == 0) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 6.0f, 0.8f);
        }
        if (this.field_70170_p.field_72995_K && this.getOwner() != null) {
            double spawnZ;
            double spawnY;
            double spawnX;
            AxisAlignedBB boundingBox;
            Random random;
            double h;
            int[] fade = this.getFade();
            int[] rgb = this.getRGB();
            int rRandom = fade[0] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[0] * 2) : AvatarUtils.getRandomNumberInRange(fade[0] / 2, fade[0] * 2);
            int gRandom = fade[1] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[1] * 2) : AvatarUtils.getRandomNumberInRange(fade[1] / 2, fade[1] * 2);
            int bRandom = fade[2] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[2] * 2) : AvatarUtils.getRandomNumberInRange(fade[2] / 2, fade[2] * 2);
            for (h = 0.0; h < (double)this.field_70130_N; h += 0.1) {
                random = new Random();
                boundingBox = this.func_174813_aQ();
                spawnX = boundingBox.field_72340_a + random.nextDouble() * (boundingBox.field_72336_d - boundingBox.field_72340_a);
                spawnY = boundingBox.field_72338_b + random.nextDouble() * (boundingBox.field_72337_e - boundingBox.field_72338_b);
                spawnZ = boundingBox.field_72339_c + random.nextDouble() * (boundingBox.field_72334_f - boundingBox.field_72339_c);
                ParticleBuilder.create(ParticleBuilder.Type.FIRE).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 30.0, this.field_70170_p.field_73012_v.nextGaussian() / 30.0, this.field_70170_p.field_73012_v.nextGaussian() / 30.0).time(12 + AvatarUtils.getRandomNumberInRange(0, 4)).scale((float)this.getSize() / 100.0f).element(this.getElement()).spawnEntity((Entity)this.getOwner()).spawn(this.field_70170_p);
                ParticleBuilder.create(ParticleBuilder.Type.FIRE).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 30.0, this.field_70170_p.field_73012_v.nextGaussian() / 30.0, this.field_70170_p.field_73012_v.nextGaussian() / 30.0).time(10 + AvatarUtils.getRandomNumberInRange(0, 4)).scale((float)this.getSize() / 100.0f).element(this.getElement()).spawnEntity((Entity)this.getOwner()).spawn(this.field_70170_p);
            }
            for (h = 0.0; h < (double)this.field_70130_N; h += 0.3) {
                random = new Random();
                boundingBox = this.func_174813_aQ();
                spawnX = boundingBox.field_72340_a + random.nextDouble() * (boundingBox.field_72336_d - boundingBox.field_72340_a);
                spawnY = boundingBox.field_72338_b + random.nextDouble() * (boundingBox.field_72337_e - boundingBox.field_72338_b);
                spawnZ = boundingBox.field_72339_c + random.nextDouble() * (boundingBox.field_72334_f - boundingBox.field_72339_c);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 60.0, this.field_70170_p.field_73012_v.nextGaussian() / 60.0, this.field_70170_p.field_73012_v.nextGaussian() / 60.0).time(12).clr(rgb[0], rgb[1], rgb[2]).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).scale((float)this.getSize() * 0.03125f).element(this.getElement()).spawnEntity((Entity)this.getOwner()).spawn(this.field_70170_p);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 60.0, this.field_70170_p.field_73012_v.nextGaussian() / 60.0, this.field_70170_p.field_73012_v.nextGaussian() / 60.0).time(12).clr(rgb[0], rgb[1], rgb[2]).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).scale((float)this.getSize() * 0.03125f).element(this.getElement()).spawnEntity((Entity)this.getOwner()).spawn(this.field_70170_p);
            }
            if (this.getBehaviour() instanceof FireballBehavior.Thrown) {
                for (int i = 0; i < 4; ++i) {
                    Vec3d pos = Vector.getOrthogonalVector(this.func_70040_Z(), (double)(i * 90 + this.field_70173_aa % 360 * 10), (double)(this.getAvgSize() / 1.25f)).toMinecraft();
                    Vec3d entityPos = AvatarEntityUtils.getMiddleOfEntity(this);
                    pos = pos.func_178787_e(entityPos);
                    Vec3d velocity = pos.func_178788_d(entityPos).func_72432_b();
                    velocity = velocity.func_186678_a(AvatarUtils.getSqrMagnitude(this.getVelocity()) / 400000.0);
                    spawnX = pos.field_72450_a;
                    spawnY = pos.field_72448_b;
                    spawnZ = pos.field_72449_c;
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 100.0 + velocity.field_72450_a, this.field_70170_p.field_73012_v.nextGaussian() / 100.0 + velocity.field_72448_b, this.field_70170_p.field_73012_v.nextGaussian() / 60.0 + velocity.field_72449_c).time(4 + AvatarUtils.getRandomNumberInRange(0, 4)).clr(rgb[0], rgb[1], rgb[2]).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).scale(this.getAvgSize()).element(this.getElement()).spawnEntity((Entity)this.getOwner()).spawn(this.field_70170_p);
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 100.0 + velocity.field_72450_a, this.field_70170_p.field_73012_v.nextGaussian() / 100.0 + velocity.field_72448_b, this.field_70170_p.field_73012_v.nextGaussian() / 60.0 + velocity.field_72449_c).time(4 + AvatarUtils.getRandomNumberInRange(0, 4)).clr(rgb[0], rgb[1], rgb[2]).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).scale(this.getAvgSize()).element(this.getElement()).spawnEntity((Entity)this.getOwner()).spawn(this.field_70170_p);
                }
            }
        }
    }

    @Override
    public boolean onMajorWaterContact() {
        this.spawnExtinguishIndicators();
        this.func_70106_y();
        return true;
    }

    @Override
    public boolean onMinorWaterContact() {
        this.spawnExtinguishIndicators();
        return false;
    }

    @Override
    public EntityLivingBase getController() {
        return this.getBehaviour() instanceof FireballBehavior.PlayerControlled ? this.getOwner() : null;
    }

    public int getSize() {
        return (int)(this.getAvgSize() * 16.0f);
    }

    public int getOrbitID() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_ORBIT_ID);
    }

    public void setOrbitID(int id) {
        this.field_70180_af.func_187227_b(SYNC_ORBIT_ID, (Object)id);
    }

    @Override
    public Vec3d getExplosionKnockbackMult() {
        return super.getExplosionKnockbackMult().func_186678_a((double)(ConfigStats.STATS_CONFIG.fireballSettings.explosionSize * (float)this.getSize() / 128.0f) + this.getPowerRating() * 0.02);
    }

    @Override
    public double getExplosionHitboxGrowth() {
        return (double)(ConfigStats.STATS_CONFIG.fireballSettings.explosionSize * (float)this.getSize() / 32.0f) + this.getPowerRating() * 0.02;
    }

    @Override
    public Vec3d getKnockbackMult() {
        return super.getKnockbackMult().func_186678_a(0.125 * ConfigStats.STATS_CONFIG.fireballSettings.push);
    }

    @Override
    public void applyElementalContact(AvatarEntity entity) {
        super.applyElementalContact(entity);
        entity.onFireContact();
    }

    @Override
    public boolean shouldExplode() {
        return this.getBehaviour() instanceof FireballBehavior.Thrown;
    }

    @Override
    public boolean shouldDissipate() {
        return false;
    }

    @Override
    public void spawnExplosionParticles(World world, Vec3d pos) {
        if (world.field_72995_K && this.getOwner() != null) {
            int[] fade = this.getFade();
            int[] rgb = this.getRGB();
            int rRandom = fade[0] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[0] * 2) : AvatarUtils.getRandomNumberInRange(fade[0] / 2, fade[0] * 2);
            int gRandom = fade[1] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[1] * 2) : AvatarUtils.getRandomNumberInRange(fade[1] / 2, fade[1] * 2);
            int bRandom = fade[2] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[2] * 2) : AvatarUtils.getRandomNumberInRange(fade[2] / 2, fade[2] * 2);
            for (double h = 0.0; h < (double)(this.field_70130_N * 2.0f); h += 0.2 / this.getExplosionHitboxGrowth()) {
                Random random = new Random();
                AxisAlignedBB boundingBox = this.func_174813_aQ();
                double spawnX = boundingBox.field_72340_a + random.nextDouble() * (boundingBox.field_72336_d - boundingBox.field_72340_a);
                double spawnY = boundingBox.field_72338_b + random.nextDouble() * (boundingBox.field_72337_e - boundingBox.field_72338_b);
                double spawnZ = boundingBox.field_72339_c + random.nextDouble() * (boundingBox.field_72334_f - boundingBox.field_72339_c);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 10.0 * this.getExplosionHitboxGrowth(), world.field_73012_v.nextGaussian() / 10.0 * this.getExplosionHitboxGrowth(), world.field_73012_v.nextGaussian() / 10.0 * this.getExplosionHitboxGrowth()).time(12 + AvatarUtils.getRandomNumberInRange(0, 4) + (int)this.getExplosionHitboxGrowth()).clr(rgb[0], rgb[1], rgb[2]).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).scale((float)this.getSize() * 0.03125f).element(this.getElement()).spawnEntity((Entity)this.getOwner()).spawn(world);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(world.field_73012_v.nextGaussian() / 10.0 * this.getExplosionHitboxGrowth(), world.field_73012_v.nextGaussian() / 10.0 * this.getExplosionHitboxGrowth(), world.field_73012_v.nextGaussian() / 10.0 * this.getExplosionHitboxGrowth()).time(12 + AvatarUtils.getRandomNumberInRange(0, 4) + (int)this.getExplosionHitboxGrowth()).clr(rgb[0], rgb[1], rgb[2]).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).scale((float)this.getSize() * 0.03125f).element(this.getElement()).spawnEntity((Entity)this.getOwner()).spawn(world);
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.removeStatCtrl();
    }

    @Override
    public boolean onCollideWithSolid() {
        return super.onCollideWithSolid();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
    }

    public int func_70070_b() {
        return 150;
    }

    @Override
    public double getExpandedHitboxWidth() {
        return this.getWidth() / 4.0f;
    }

    @Override
    public double getExpandedHitboxHeight() {
        return this.getHeight() / 4.0f;
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return super.shouldRenderInPass(pass);
    }

    private void removeStatCtrl() {
        BendingData data;
        if (this.getOwner() != null && (data = Objects.requireNonNull(Bender.get(this.getOwner())).getData()) != null) {
            data.removeStatusControl(StatusControlController.THROW_FIREBALL);
        }
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    @Optional.Method(modid="hammercore")
    public ColoredLight produceColoredLight(float partialTicks) {
        return ColoredLight.builder().pos((Entity)this).color(1.0f, 0.0f, 0.0f, 1.0f).radius((float)this.getSize() / 4.0f).build();
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        if (this.getBehaviour() instanceof FireballBehavior.Thrown) {
            return super.canCollideWith(entity);
        }
        return false;
    }

    @Override
    public boolean func_70067_L() {
        if (this.getBehaviour() instanceof FireballBehavior.Thrown) {
            return super.func_70067_L();
        }
        return false;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }
}

