/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.fire.AbilityFireShot;
import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.blocks.BlockTemp;
import com.crowsofwar.avatar.blocks.BlockUtils;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.ICustomHitbox;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.gorecore.util.Vector;
import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity;
import java.util.Objects;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity", modid="hammercore")
public class EntityFlames
extends EntityOffensive
implements IGlowingEntity,
ICustomHitbox {
    private static final DataParameter<Boolean> SYNC_REFLECT = EntityDataManager.func_187226_a(EntityFlames.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SYNC_TRAILING_FIRES = EntityDataManager.func_187226_a(EntityFlames.class, (DataSerializer)DataSerializers.field_187198_h);
    private boolean smelts;

    public EntityFlames(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.lightTnt = true;
        this.setsFires = false;
        this.smelts = false;
    }

    public boolean getTrailingFires() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_TRAILING_FIRES);
    }

    public void setTrailingFires(boolean fires) {
        this.setFires(this.setsFires);
        this.field_70180_af.func_187227_b(SYNC_TRAILING_FIRES, (Object)fires);
    }

    public boolean getReflect() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_REFLECT);
    }

    public void setReflect(boolean reflect) {
        this.field_70180_af.func_187227_b(SYNC_REFLECT, (Object)reflect);
    }

    public void setSmelts(boolean smelts) {
        this.smelts = smelts;
    }

    public boolean shouldSmelt() {
        return this.smelts;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_REFLECT, (Object)false);
        this.field_70180_af.func_187214_a(SYNC_TRAILING_FIRES, (Object)false);
    }

    @Override
    public BendingStyle getElement() {
        return new Firebending();
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        if (entity instanceof EntityItem && this.smelts && !this.field_70170_p.field_72995_K && !entity.field_70128_L) {
            AvatarEntityUtils.smeltItemEntity((EntityItem)entity, this.getTier());
        }
        super.onCollideWithEntity(entity);
    }

    @Override
    public boolean onCollideWithSolid() {
        if (this.field_70132_H && this.setsFires) {
            this.setFires();
        }
        return super.onCollideWithSolid() && !this.getReflect();
    }

    @Override
    public boolean multiHit() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        Raytrace.Result raytrace;
        super.func_70071_h_();
        if (this.velocity().sqrMagnitude() <= 0.5) {
            this.Dissipate();
        }
        if (this.getBehaviour() instanceof OffensiveBehaviour.Idle && this.field_70170_p.field_72995_K && this.field_70173_aa > 1) {
            int[] fade = this.getFade();
            int[] rgb = this.getRGB();
            for (double i = 0.0; i < (double)this.field_70130_N; i += 0.1 * (double)this.getAvgSize() * 4.0) {
                int rRandom = fade[0] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[0] * 2) : AvatarUtils.getRandomNumberInRange(fade[0] / 2, fade[0] * 2);
                int gRandom = fade[1] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[1] * 2) : AvatarUtils.getRandomNumberInRange(fade[1] / 2, fade[1] * 2);
                int bRandom = fade[2] < 100 ? AvatarUtils.getRandomNumberInRange(0, fade[2] * 2) : AvatarUtils.getRandomNumberInRange(fade[2] / 2, fade[2] * 2);
                Random random = new Random();
                Vec3d box = AvatarEntityUtils.getMiddleOfEntity(this);
                AxisAlignedBB boundingBox = this.func_174813_aQ();
                double spawnX = box.field_72450_a + random.nextDouble() * 1.5 * (boundingBox.field_72336_d - boundingBox.field_72340_a);
                double spawnY = box.field_72448_b + random.nextDouble() * 1.5 * (boundingBox.field_72337_e - boundingBox.field_72338_b);
                double spawnZ = box.field_72449_c + random.nextDouble() * 1.5 * (boundingBox.field_72334_f - boundingBox.field_72339_c);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 30.0, this.field_70170_p.field_73012_v.nextGaussian() / 30.0, this.field_70170_p.field_73012_v.nextGaussian() / 30.0).time(5 + AvatarUtils.getRandomNumberInRange(0, 2)).clr(rgb[0], rgb[1], rgb[2]).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).scale(this.getAvgSize() * 2.0f).element(this.getElement()).ability(this.getAbility()).spawnEntity((Entity)this.getOwner()).spawn(this.field_70170_p);
                ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 30.0, this.field_70170_p.field_73012_v.nextGaussian() / 30.0, this.field_70170_p.field_73012_v.nextGaussian() / 30.0).time(5 + AvatarUtils.getRandomNumberInRange(0, 2)).clr(rgb[0], rgb[1], rgb[2]).fade(rRandom, gRandom, bRandom, AvatarUtils.getRandomNumberInRange(100, 175)).scale(this.getAvgSize() * 2.0f).element(this.getElement()).ability(this.getAbility()).spawnEntity((Entity)this.getOwner()).spawn(this.field_70170_p);
                ParticleBuilder.create(ParticleBuilder.Type.FIRE).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 50.0, this.field_70170_p.field_73012_v.nextGaussian() / 50.0, this.field_70170_p.field_73012_v.nextGaussian() / 50.0).time(5 + AvatarUtils.getRandomNumberInRange(0, 2)).scale(this.getAvgSize() / 2.0f).element(this.getElement()).ability(this.getAbility()).spawnEntity((Entity)this.getOwner()).spawn(this.field_70170_p);
            }
        }
        if ((raytrace = Raytrace.raytrace(this.field_70170_p, this.position(), this.velocity().normalize(), 0.125, true)).hitSomething()) {
            EnumFacing sideHit = raytrace.getSide();
            if (this.getReflect()) {
                this.setVelocity(this.velocity().reflect(new Vector(Objects.requireNonNull(sideHit))).times(0.75));
            }
        }
        if (this.getTrailingFires() && !this.field_70170_p.field_72995_K && AvatarUtils.getRandomNumberInRange(1, 10) <= 5) {
            BlockPos pos2;
            BlockPos pos = this.func_180425_c();
            if (BlockUtils.canPlaceFireAt(this.field_70170_p, pos)) {
                BlockTemp.createTempBlock(this.field_70170_p, pos, 20, Blocks.field_150480_ab.func_176223_P());
            }
            if (BlockUtils.canPlaceFireAt(this.field_70170_p, pos2 = this.func_180425_c().func_177977_b())) {
                BlockTemp.createTempBlock(this.field_70170_p, pos2, 20, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setFade(nbt.func_74759_k("Fade"));
        this.setRGB(nbt.func_74759_k("RGB"));
        this.setReflect(nbt.func_74767_n("Reflect"));
        this.setTrailingFires(nbt.func_74767_n("TrailingFires"));
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74783_a("Fade", this.getFade());
        nbt.func_74783_a("RGB", this.getRGB());
        nbt.func_74757_a("Reflect", this.getReflect());
        nbt.func_74757_a("TrailingFires", this.getTrailingFires());
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return super.canCollideWith(entity) || entity instanceof EntityItem;
    }

    @Override
    public double getExpandedHitboxWidth() {
        return 0.35;
    }

    @Override
    public double getExpandedHitboxHeight() {
        return 0.35;
    }

    @Override
    public void spawnDissipateParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnPiercingParticles(World world, Vec3d pos) {
    }

    @Override
    public boolean onAirContact() {
        if (this.getTier() < 2) {
            this.func_70106_y();
            this.spawnExtinguishIndicators();
            return true;
        }
        if (this.field_70170_p.field_73012_v.nextBoolean()) {
            this.spawnExtinguishIndicators();
        }
        return false;
    }

    @Override
    public boolean shouldDissipate() {
        return !this.getReflect() || this.field_70173_aa > this.getLifeTime();
    }

    @Override
    public boolean shouldExplode() {
        return false;
    }

    @Override
    public boolean onMajorWaterContact() {
        this.func_70106_y();
        this.spawnExtinguishIndicators();
        return true;
    }

    @Override
    public boolean onMinorWaterContact() {
        if (this.getTier() < 3) {
            this.func_70106_y();
            if (this.field_70146_Z.nextDouble() < 0.8) {
                this.spawnExtinguishIndicators();
            }
            return true;
        }
        if (this.field_70146_Z.nextDouble() < 0.4) {
            this.spawnExtinguishIndicators();
        }
        return false;
    }

    public void setFires(boolean fires) {
        this.setsFires = fires;
    }

    @Override
    public void applyElementalContact(AvatarEntity entity) {
        entity.onFireContact();
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    @Override
    public boolean isPiercing() {
        return false;
    }

    @Optional.Method(modid="hammercore")
    public ColoredLight produceColoredLight(float partialTicks) {
        return ColoredLight.builder().pos((Entity)this).color(1.0f, 0.0f, 0.0f, 1.0f).radius(10.0f).build();
    }

    @Override
    public Vec3d calculateIntercept(Vec3d origin, Vec3d endpoint, float fuzziness) {
        return null;
    }

    @Override
    public boolean contains(Vec3d point) {
        return false;
    }

    @Override
    public float getVolume() {
        if (this.getAbility() instanceof AbilityFireShot) {
            return super.getVolume();
        }
        return 0.125f * this.field_70170_p.field_73012_v.nextFloat();
    }
}

