/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.entity.data.FloatingBlockBehavior;
import com.crowsofwar.avatar.util.AvatarDataSerializers;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.gorecore.util.GoreCoreNBTUtil;
import com.crowsofwar.gorecore.util.Vector;
import com.google.common.base.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFloatingBlock
extends EntityOffensive {
    public static final Block DEFAULT_BLOCK = Blocks.field_150348_b;
    private static final DataParameter<Integer> SYNC_ENTITY_ID = EntityDataManager.func_187226_a(EntityFloatingBlock.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Vector> SYNC_VELOCITY = EntityDataManager.func_187226_a(EntityFloatingBlock.class, AvatarDataSerializers.SERIALIZER_VECTOR);
    private static final DataParameter<Float> SYNC_FRICTION = EntityDataManager.func_187226_a(EntityFloatingBlock.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Optional<IBlockState>> SYNC_BLOCK = EntityDataManager.func_187226_a(EntityFloatingBlock.class, (DataSerializer)DataSerializers.field_187197_g);
    private static final DataParameter<Integer> SYNC_HITS_LEFT = EntityDataManager.func_187226_a(EntityFloatingBlock.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<FloatingBlockBehavior> SYNC_BEHAVIOR = EntityDataManager.func_187226_a(EntityFloatingBlock.class, FloatingBlockBehavior.DATA_SERIALIZER);
    private static final DataParameter<Boolean> SYNC_BOOMERANG = EntityDataManager.func_187226_a(EntityFloatingBlock.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SYNC_TURN_SOLID = EntityDataManager.func_187226_a(EntityFloatingBlock.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SYNC_EXPLOSION = EntityDataManager.func_187226_a(EntityFloatingBlock.class, (DataSerializer)DataSerializers.field_187198_h);
    private static int nextBlockID = 0;
    private EntityPlayer ownerCached;
    private boolean enableItemDrops;
    private AxisAlignedBB expandedHitbox;
    private float damageMult;
    private int ticksGround;

    public EntityFloatingBlock(World world) {
        super(world);
        float size = 0.9f;
        this.setEntitySize(size, size);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.setID(nextBlockID++);
        }
        this.enableItemDrops = true;
        this.damageMult = 1.0f;
        this.ticksGround = 0;
        this.field_70130_N = size;
        this.field_70131_O = size;
        this.field_70158_ak = true;
    }

    public EntityFloatingBlock(World world, IBlockState blockState) {
        this(world);
        this.setBlockState(blockState);
    }

    public EntityFloatingBlock(World world, IBlockState blockState, EntityPlayer owner) {
        this(world, blockState);
        this.setOwner((EntityLivingBase)owner);
    }

    public static EntityFloatingBlock getFromID(World world, int id) {
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity e = (Entity)world.field_72996_f.get(i);
            if (!(e instanceof EntityFloatingBlock) || ((EntityFloatingBlock)e).getID() != id) continue;
            return (EntityFloatingBlock)e;
        }
        return null;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_ENTITY_ID, (Object)0);
        this.field_70180_af.func_187214_a(SYNC_VELOCITY, (Object)Vector.ZERO);
        this.field_70180_af.func_187214_a(SYNC_FRICTION, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_BLOCK, (Object)Optional.of((Object)DEFAULT_BLOCK.func_176223_P()));
        this.field_70180_af.func_187214_a(SYNC_BEHAVIOR, (Object)new FloatingBlockBehavior.Idle());
        this.field_70180_af.func_187214_a(SYNC_HITS_LEFT, (Object)3);
        this.field_70180_af.func_187214_a(SYNC_BOOMERANG, (Object)false);
        this.field_70180_af.func_187214_a(SYNC_TURN_SOLID, (Object)false);
        this.field_70180_af.func_187214_a(SYNC_EXPLOSION, (Object)false);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setBlockState(Block.func_149729_e((int)nbt.func_74762_e("BlockId")).func_176203_a(nbt.func_74762_e("Metadata")));
        this.setFriction(nbt.func_74760_g("Friction"));
        this.setItemDropsEnabled(nbt.func_74767_n("DropItems"));
        this.setBehavior((FloatingBlockBehavior)Behavior.lookup(nbt.func_74762_e("Behavior"), this));
        this.getBehavior().load(nbt.func_74775_l("BehaviorData"));
        this.setBoomerang(nbt.func_74767_n("Boomerang"));
        this.setHitsLeft(nbt.func_74762_e("HitsLeft"));
        this.damageMult = nbt.func_74760_g("DamageMultiplier");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("BlockId", Block.func_149682_b((Block)this.getBlock()));
        nbt.func_74768_a("Metadata", this.getBlock().func_176201_c(this.getBlockState()));
        nbt.func_74776_a("Friction", this.getFriction());
        nbt.func_74757_a("DropItems", this.areItemDropsEnabled());
        nbt.func_74768_a("Behavior", this.getBehavior().getId());
        this.getBehavior().save(GoreCoreNBTUtil.nestedCompound(nbt, "BehaviorData"));
        nbt.func_74757_a("Boomerang", this.shouldBoomerang());
        nbt.func_74768_a("HitsLeft", this.getHitsLeft());
        nbt.func_74776_a("DamageMultiplier", this.damageMult);
    }

    @Override
    public boolean func_90999_ad() {
        return false;
    }

    public Block getBlock() {
        return this.getBlockState().func_177230_c();
    }

    public void setBlock(Block block) {
        this.setBlockState(block.func_176223_P());
    }

    public void setExplosion(boolean explosion) {
        this.field_70145_X = explosion;
        this.field_70180_af.func_187227_b(SYNC_EXPLOSION, (Object)explosion);
    }

    public boolean doesExplode() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_EXPLOSION);
    }

    public void setTurnSolid(boolean solid) {
        this.field_70180_af.func_187227_b(SYNC_TURN_SOLID, (Object)solid);
    }

    public boolean shouldTurnSolid() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_TURN_SOLID);
    }

    public void setBoomerang(boolean boomerang) {
        this.field_70180_af.func_187227_b(SYNC_BOOMERANG, (Object)boomerang);
    }

    public boolean shouldBoomerang() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_BOOMERANG);
    }

    public int getHitsLeft() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_HITS_LEFT);
    }

    public void setHitsLeft(int hits) {
        this.field_70180_af.func_187227_b(SYNC_HITS_LEFT, (Object)hits);
    }

    public IBlockState getBlockState() {
        Optional obs = (Optional)this.field_70180_af.func_187225_a(SYNC_BLOCK);
        return (IBlockState)obs.get();
    }

    public void setBlockState(IBlockState state) {
        this.field_70180_af.func_187227_b(SYNC_BLOCK, (Object)Optional.of((Object)state));
    }

    public int getID() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_ENTITY_ID);
    }

    public void setID(int id) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(SYNC_ENTITY_ID, (Object)id);
        }
    }

    public boolean areItemDropsEnabled() {
        return this.enableItemDrops;
    }

    public void setItemDropsEnabled(boolean enable) {
        this.enableItemDrops = enable;
    }

    public float getDamageMult() {
        return this.damageMult;
    }

    public void setDamageMult(float mult) {
        this.damageMult = mult;
    }

    private void spawnCrackParticle(double x, double y, double z, double mx, double my, double mz) {
        this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, x, y, z, mx, my, mz, new int[]{Block.func_176210_f((IBlockState)this.getBlockState())});
    }

    public void placeBlock() {
        if (!this.field_70170_p.field_72995_K && !ConfigStats.STATS_CONFIG.preventEarthGriefing) {
            Vec3d middle = AvatarEntityUtils.getMiddleOfEntity(this);
            BlockPos pos = new BlockPos(middle.field_72450_a, middle.field_72448_b, middle.field_72449_c);
            this.field_70170_p.func_175656_a(pos, this.getBlockState());
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.setBehavior((FloatingBlockBehavior)this.getBehavior().onUpdate(this));
        this.func_70066_B();
        if ((this.field_70122_E || this.doesExplode() && this.onCollideWithSolid()) && this.getBehavior() instanceof FloatingBlockBehavior.Thrown) {
            ++this.ticksGround;
        }
        if ((this.ticksGround > 1 || this.velocity().magnitude() < 10.0) && this.doesExplode() && this.onCollideWithSolid()) {
            this.Explode();
        }
        if (this.ticksGround > 13 && this.velocity().magnitude() < 0.5) {
            this.setPosition(this.func_174791_d());
            this.placeBlock();
            this.field_70170_p.func_180497_b(this.func_180425_c(), this.getBlock(), 0, 1);
        }
        if (this.ticksGround > 17 && this.velocity().magnitude() < 0.5) {
            this.Dissipate();
        }
        if (this.field_70173_aa == 1) {
            for (int i = 0; i < 10; ++i) {
                double spawnX = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5);
                double spawnY = this.field_70163_u - 0.0;
                double spawnZ = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5);
                this.spawnCrackParticle(spawnX, spawnY, spawnZ, 0.0, -0.1, 0.0);
            }
        }
        if (this.getBehavior() != null && this.getBehavior() instanceof FloatingBlockBehavior.Thrown) {
            if (this.field_70122_E) {
                this.setVelocity(this.velocity().times((double)this.getFriction() / 1.25));
            } else {
                this.setVelocity(this.velocity().times(this.getFriction()));
            }
        }
    }

    @Override
    @Nullable
    public SoundEvent[] getSounds() {
        return new SoundEvent[]{this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c().func_185467_w().func_185845_c()};
    }

    @Override
    public void playPiercingSounds(Entity entity) {
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        super.onCollideWithEntity(entity);
        if (this.canCollideWith(entity)) {
            if (this.shouldBoomerang() && this.getOwner() != null) {
                this.setBehavior(new FloatingBlockBehavior.PlayerControlled());
                Vec3d forward = this.getOwner().func_70676_i(1.0f);
                Vec3d eye = this.getOwner().func_174824_e(1.0f);
                Vec3d target = forward.func_186678_a(2.5).func_178787_e(eye);
                Vec3d motion = target.func_178788_d(entity.func_174791_d()).func_186678_a(0.05);
                this.setVelocity(motion);
            }
            this.setHitsLeft(this.getHitsLeft() - 1);
        }
    }

    @Override
    public int getFireTime() {
        return 0;
    }

    @Override
    public boolean onCollideWithSolid() {
        if (super.onCollideWithSolid() && this.getBehavior() instanceof FloatingBlockBehavior.Thrown) {
            this.setPosition(this.func_174791_d());
        }
        if (this.getBehavior() instanceof FloatingBlockBehavior.Fall) {
            this.placeBlock();
        }
        boolean collide = this.getBehavior() instanceof FloatingBlockBehavior.Thrown || this.getBehavior() instanceof FloatingBlockBehavior.Fall && this.velocity().magnitude() < 0.5;
        return super.onCollideWithSolid() && collide;
    }

    @Override
    public boolean shouldDissipate() {
        return (this.getHitsLeft() == 0 || !this.shouldTurnSolid()) && this.getBehavior() instanceof FloatingBlockBehavior.Thrown && !this.doesExplode();
    }

    @Override
    public boolean shouldExplode() {
        return false;
    }

    @Override
    public boolean isPiercing() {
        return true;
    }

    @Override
    public boolean func_70067_L() {
        return this.getBehavior() instanceof FloatingBlockBehavior.Thrown;
    }

    @Override
    public void Dissipate() {
        super.Dissipate();
        if (!this.shouldTurnSolid() && this.areItemDropsEnabled()) {
            EntityItem entity = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Item.func_150898_a((Block)this.getBlock()), 1));
            entity.func_174869_p();
            if (this.getOwner() != null) {
                entity.func_145797_a(this.getOwner().func_70005_c_());
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)entity);
            }
        }
    }

    @Override
    public boolean func_70104_M() {
        return !this.doesExplode();
    }

    @Override
    public void spawnDissipateParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnExplosionParticles(World world, Vec3d pos) {
        if (world.field_72995_K) {
            for (int i = 0; i < 50; ++i) {
                world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + world.field_73012_v.nextGaussian() * 0.75, this.field_70163_u + world.field_73012_v.nextGaussian() * 0.875, this.field_70161_v + world.field_73012_v.nextGaussian() * 0.75, world.field_73012_v.nextGaussian() * 0.75, world.field_73012_v.nextDouble() * 0.75, world.field_73012_v.nextGaussian() * 0.75, new int[]{Block.func_176210_f((IBlockState)this.getBlockState())});
            }
        }
    }

    @Override
    public void spawnPiercingParticles(World world, Vec3d pos) {
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        if (this.getBehavior() instanceof FloatingBlockBehavior.Thrown) {
            return super.canCollideWith(entity);
        }
        return false;
    }

    public float getFriction() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_FRICTION)).floatValue();
    }

    public void setFriction(float friction) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(SYNC_FRICTION, (Object)Float.valueOf(friction));
        }
    }

    public void drop() {
        this.setBehavior(new FloatingBlockBehavior.Fall());
    }

    public FloatingBlockBehavior getBehavior() {
        return (FloatingBlockBehavior)this.field_70180_af.func_187225_a(SYNC_BEHAVIOR);
    }

    public void setBehavior(FloatingBlockBehavior behavior) {
        if (behavior == null) {
            throw new IllegalArgumentException("Cannot have null behavior");
        }
        this.field_70180_af.func_187227_b(SYNC_BEHAVIOR, (Object)behavior);
    }

    @Override
    public EntityLivingBase getController() {
        return this.getOwner();
    }

    @Override
    public double getExpandedHitboxWidth() {
        return 0.35;
    }

    @Override
    public double getExpandedHitboxHeight() {
        return 0.35;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double d) {
        return true;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public float getDamage() {
        return (float)(AvatarUtils.getMagnitude(this.velocity().toMinecraft()) / 20.0 * (double)this.getDamageMult());
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.removeStatCtrl();
    }

    @Override
    public BendingStyle getElement() {
        return new Earthbending();
    }

    private void removeStatCtrl() {
        BendingData bD;
        if (this.getOwner() != null && (bD = BendingData.getFromEntity(this.getOwner())) != null) {
            bD.removeStatusControls(StatusControlController.THROW_BLOCK, StatusControlController.PLACE_BLOCK);
        }
    }
}

