/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.ice.Icebending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.data.SyncedEntity;
import com.crowsofwar.avatar.util.damageutils.AvatarDamageSource;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class EntityIcePrison
extends AvatarEntity {
    public static final DataParameter<Optional<UUID>> SYNC_IMPRISONED = EntityDataManager.func_187226_a(EntityIcePrison.class, (DataSerializer)DataSerializers.field_187203_m);
    public static final DataParameter<Integer> SYNC_IMPRISONED_TIME = EntityDataManager.func_187226_a(EntityIcePrison.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> SYNC_MAX_IMPRISONED_TIME = EntityDataManager.func_187226_a(EntityIcePrison.class, (DataSerializer)DataSerializers.field_187192_b);
    private double normalBaseValue;
    private final SyncedEntity<EntityLivingBase> imprisonedAttr = new SyncedEntity(this, SYNC_IMPRISONED);
    private boolean meltInSun;
    private boolean meltInFire;
    private boolean attackOnce;
    private boolean attackRepeat;

    public EntityIcePrison(World world) {
        super(world);
        this.func_70105_a(3.0f, 4.0f);
    }

    public static boolean isImprisoned(EntityLivingBase entity) {
        return EntityIcePrison.getPrison(entity) != null;
    }

    public static EntityIcePrison getPrison(EntityLivingBase entity) {
        World world = entity.field_70170_p;
        List prisons = world.func_175644_a(EntityIcePrison.class, prison -> prison.getImprisoned() == entity);
        return prisons.isEmpty() ? null : (EntityIcePrison)((Object)prisons.get(0));
    }

    public static void imprison(EntityLivingBase entity, EntityLivingBase owner, Ability ab) {
        World world = entity.field_70170_p;
        EntityIcePrison prison = new EntityIcePrison(world);
        prison.setImprisoned(entity);
        prison.setOwner(owner);
        prison.func_82149_j((Entity)entity);
        prison.setAbility(ab);
        Bender bender = Bender.get(owner);
        prison.setStats(bender.getData().getAbilityData("ice_prison"), bender.calcPowerRating(Icebending.ID));
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)prison);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_IMPRISONED, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SYNC_IMPRISONED_TIME, (Object)100);
        this.field_70180_af.func_187214_a(SYNC_MAX_IMPRISONED_TIME, (Object)100);
    }

    @Nullable
    public EntityLivingBase getImprisoned() {
        return this.imprisonedAttr.getEntity();
    }

    public void setImprisoned(EntityLivingBase entity) {
        this.imprisonedAttr.setEntity(entity);
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return false;
    }

    @Override
    public void func_70071_h_() {
        EntityLivingBase imprisoned = this.getImprisoned();
        if (imprisoned != null) {
            IAttributeInstance speed = imprisoned.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (speed.func_111125_b() != 0.0) {
                this.normalBaseValue = speed.func_111125_b();
                speed.func_111128_a(0.0);
            }
            imprisoned.field_70159_w *= 0.0;
            imprisoned.field_70181_x *= 0.0;
            imprisoned.field_70179_y *= 0.0;
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            imprisoned.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean inSky;
            this.setImprisonedTime(this.getImprisonedTime() - 1);
            if (this.meltInSun && this.field_70170_p.func_72935_r() && (inSky = this.field_70170_p.func_175710_j(this.func_180425_c())) && this.field_70173_aa % 2 == 0) {
                this.setImprisonedTime(this.getImprisonedTime() - 1);
            }
        }
        if (this.attackRepeat && !this.field_70170_p.field_72995_K && this.getImprisonedTime() % 20 == 19) {
            this.attackPrisoner(1.0f);
        }
        if (this.getImprisonedTime() <= 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K && imprisoned != null) {
                this.field_70170_p.func_184148_a(null, imprisoned.field_70165_t, imprisoned.field_70163_u, imprisoned.field_70161_v, SoundEvents.field_187561_bM, SoundCategory.PLAYERS, 1.0f, 1.0f);
                imprisoned.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"slowness"), 60, 1, false, false));
                if (this.attackOnce || this.attackRepeat) {
                    this.attackPrisoner(2.0f);
                }
            }
        }
        if (imprisoned == null || imprisoned.field_70128_L) {
            this.func_70106_y();
        }
    }

    private void attackPrisoner(float damageMultiplier) {
        EntityLivingBase imprisoned = this.getImprisoned();
        if (imprisoned != null) {
            DamageSource ds = AvatarDamageSource.causeIcePrisonDamage((Entity)imprisoned, (Entity)this.getOwner());
            imprisoned.func_70097_a(ds, ConfigStats.STATS_CONFIG.icePrisonDamage * damageMultiplier);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        EntityLivingBase imprisoned = this.getImprisoned();
        if (imprisoned != null) {
            IAttributeInstance speed = imprisoned.func_110148_a(SharedMonsterAttributes.field_111263_d);
            speed.func_111128_a(this.normalBaseValue);
        }
    }

    @Override
    public boolean onFireContact() {
        if (this.meltInFire && !this.field_70170_p.field_72995_K) {
            this.setImprisonedTime(this.getImprisonedTime() - 1);
        }
        return false;
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.imprisonedAttr.readFromNbt(nbt);
        this.normalBaseValue = nbt.func_74769_h("NormalSpeed");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.imprisonedAttr.writeToNbt(nbt);
        nbt.func_74780_a("NormalSpeed", this.normalBaseValue);
    }

    public int getImprisonedTime() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_IMPRISONED_TIME);
    }

    public void setImprisonedTime(int imprisonedTime) {
        this.field_70180_af.func_187227_b(SYNC_IMPRISONED_TIME, (Object)imprisonedTime);
    }

    public int getMaxImprisonedTime() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_MAX_IMPRISONED_TIME);
    }

    public void setMaxImprisonedTime(int maxImprisonedTime) {
        this.field_70180_af.func_187227_b(SYNC_MAX_IMPRISONED_TIME, (Object)maxImprisonedTime);
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    private void setStats(AbilityData data, double powerRating) {
        this.attackOnce = data.getLevel() >= 2;
        this.attackRepeat = data.isMasterPath(AbilityData.AbilityTreePath.FIRST);
        this.meltInSun = !data.isMasterPath(AbilityData.AbilityTreePath.SECOND);
        this.meltInFire = !data.isMasterPath(AbilityData.AbilityTreePath.SECOND);
        double imprisonedSeconds = (double)(3 + data.getLevel()) + powerRating / 35.0;
        this.setImprisonedTime((int)(imprisonedSeconds * 20.0));
        this.setMaxImprisonedTime(this.getImprisonedTime());
    }
}

