/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.damageutils.AvatarDamageSource;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class EntityIceShard
extends Entity {
    private double damageMult;

    public EntityIceShard(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70181_x -= 0.05;
        if (this.field_70132_H) {
            this.shatter();
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        Vector newRotation = Vector.getRotationTo(Vector.ZERO, new Vector(this.field_70159_w, this.field_70181_x, this.field_70179_y));
        this.field_70177_z = (float)Math.toDegrees(newRotation.y());
        this.field_70125_A = (float)Math.toDegrees(newRotation.x());
        Vector direction = Vector.toRectangular(Math.toRadians(this.field_70177_z), Math.toRadians(this.field_70125_A));
        List<Entity> collidedEntities = Raytrace.entityRaytrace(this.field_70170_p, new Vector(this), direction, 4.0, entity -> !(entity instanceof EntityPlayer) && !(entity instanceof EntityIceShard));
        if (!collidedEntities.isEmpty()) {
            Entity collided = collidedEntities.get(0);
            DamageSource source = AvatarDamageSource.causeIceShardDamage(collided, null);
            collided.func_70097_a(source, 5.0f * (float)this.damageMult);
            this.shatter();
        }
    }

    public void func_70108_f(Entity entity) {
    }

    private void shatter() {
        if (!this.field_70170_p.field_72995_K) {
            float volume = 0.3f + this.field_70146_Z.nextFloat() * 0.3f;
            float pitch = 1.1f + this.field_70146_Z.nextFloat() * 0.2f;
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187561_bM, SoundCategory.PLAYERS, volume, pitch);
        }
        this.func_70106_y();
    }

    public void aim(float yaw, float pitch, double speed) {
        this.field_70177_z = yaw;
        this.field_70125_A = pitch;
        double yawRad = Math.toRadians(yaw);
        double pitchRad = Math.toRadians(pitch);
        Vector velocity = Vector.toRectangular(yawRad, pitchRad).times(speed).dividedBy(20.0);
        this.field_70159_w = velocity.x();
        this.field_70181_x = velocity.y();
        this.field_70179_y = velocity.z();
    }

    public double getDamageMult() {
        return this.damageMult;
    }

    public void setDamageMult(double damageMult) {
        this.damageMult = damageMult;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }
}

