/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityIceShard;
import com.crowsofwar.avatar.entity.EntityShield;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityIceShield
extends EntityShield {
    private double normalBaseValue;
    private double damageMult;
    private boolean targetMobs;
    private float[] pitchAngles;

    public EntityIceShield(World world) {
        super(world);
    }

    public void shatter() {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187561_bM, SoundCategory.PLAYERS, 1.0f, 1.0f);
        this.func_70106_y();
        EntityLivingBase owner = this.getOwner();
        int shardsLeft = 12;
        if (this.targetMobs) {
            double range = 40.0;
            AxisAlignedBB aabb = new AxisAlignedBB(owner.field_70165_t - range / 2.0, owner.field_70163_u - range / 2.0, owner.field_70161_v - range / 2.0, owner.field_70165_t + range / 2.0, owner.field_70163_u + range / 2.0, owner.field_70161_v + range / 2.0);
            List targets = this.field_70170_p.func_72872_a(EntityMob.class, aabb);
            int shardsAtMobs = Math.min(targets.size(), 5);
            for (int i = 0; i < shardsAtMobs; ++i) {
                this.shootShardAt((Entity)targets.get(i));
                --shardsLeft;
            }
        }
        this.shootShardsAround(owner, 4, shardsLeft);
    }

    @Override
    public EntityLivingBase getController() {
        return this.getOwner();
    }

    @Override
    public boolean isShield() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        EntityLivingBase owner = this.getOwner();
        if (owner != null) {
            owner.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            owner.field_70159_w *= 0.0;
            owner.field_70179_y *= 0.0;
            this.field_70159_w *= 0.0;
            if (this.field_70122_E) {
                this.field_70181_x *= 0.0;
            }
            this.field_70179_y *= 0.0;
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        EntityLivingBase owner = this.getOwner();
    }

    @Override
    public boolean onFireContact() {
        this.setHealth(this.getHealth() - 0.2f);
        return this.getHealth() <= 0.0f;
    }

    @Override
    public boolean canPush() {
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.normalBaseValue = nbt.func_74769_h("NormalBaseValue");
        this.damageMult = nbt.func_74769_h("DamageMult");
        this.setTargetMobs(nbt.func_74767_n("TargetMobs"));
        NBTTagList pitchAngleList = nbt.func_150295_c("PitchAngles", 5);
        this.pitchAngles = new float[pitchAngleList.func_74745_c()];
        for (int i = 0; i < pitchAngleList.func_74745_c(); ++i) {
            this.pitchAngles[i] = pitchAngleList.func_150308_e(i);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74780_a("NormalBaseValue", this.normalBaseValue);
        nbt.func_74780_a("DamageMult", this.damageMult);
        nbt.func_74757_a("TargetMobs", this.isTargetMobs());
        NBTTagList pitchAngleList = new NBTTagList();
        for (float pitchAngle : this.pitchAngles) {
            pitchAngleList.func_74742_a((NBTBase)new NBTTagFloat(pitchAngle));
        }
        nbt.func_74782_a("PitchAngles", (NBTBase)pitchAngleList);
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    @Override
    protected float getChiDamageCost() {
        return ConfigStats.STATS_CONFIG.chiIceShieldProtect;
    }

    @Override
    protected float getProtectionXp() {
        return ConfigSkills.SKILLS_CONFIG.iceShieldProtected;
    }

    @Override
    protected String getAbilityName() {
        return "ice_burst";
    }

    @Override
    protected void onDeath() {
        BendingData data;
        this.shatter();
        if (this.getOwner() != null && (data = BendingData.getFromEntity(this.getOwner())) != null) {
            data.removeStatusControl(StatusControlController.SHIELD_SHATTER);
        }
    }

    private void shootShardAt(Entity target) {
        EntityLivingBase owner = this.getOwner();
        Vector targetPos = Vector.getEyePos(target);
        Vector ownerPos = Vector.getEyePos((Entity)owner);
        Vector direction = Vector.getRotationTo(ownerPos, targetPos);
        float yaw = (float)Math.toDegrees(direction.y());
        double horizDist = targetPos.withY(0.0).dist(ownerPos.withY(0.0));
        double vertDist = targetPos.y() - ownerPos.y();
        float pitch = (float)Math.toDegrees(Vector.getProjectileAngle(20.0, 20.0, horizDist, vertDist));
        EntityIceShard shard = new EntityIceShard(this.field_70170_p);
        shard.func_70012_b(owner.field_70165_t, owner.field_70163_u + (double)owner.func_70047_e(), owner.field_70161_v, yaw, pitch);
        shard.aim(yaw, pitch, 20.0);
        shard.setDamageMult(this.damageMult);
        this.field_70170_p.func_72838_d((Entity)shard);
    }

    private void shootShardsAround(EntityLivingBase shooter, int yawAngles, int shardsLimit) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        for (int i = 0; i < yawAngles; ++i) {
            float yaw = 360.0f / (float)yawAngles * (float)i;
            for (int j = 0; j < this.pitchAngles.length && shardsLimit != 0; --shardsLimit, ++j) {
                float pitch = this.pitchAngles[j];
                EntityIceShard shard = new EntityIceShard(this.field_70170_p);
                shard.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, 0.0f, 0.0f);
                shard.aim(yaw + shooter.field_70177_z, pitch + shooter.field_70125_A, 53.0);
                shard.setDamageMult(this.damageMult);
                this.field_70170_p.func_72838_d((Entity)shard);
            }
        }
    }

    public double getDamageMult() {
        return this.damageMult;
    }

    public void setDamageMult(double damageMult) {
        this.damageMult = damageMult;
    }

    public boolean isTargetMobs() {
        return this.targetMobs;
    }

    public void setTargetMobs(boolean targetMobs) {
        this.targetMobs = targetMobs;
    }

    public float[] getPitchAngles() {
        return this.pitchAngles;
    }

    public void setPitchAngles(float[] pitchAngles) {
        this.pitchAngles = pitchAngles;
    }
}

