/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.entity.data.LightOrbBehavior;
import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity", modid="hammercore")
public class EntityLightOrb
extends AvatarEntity
implements IGlowingEntity {
    private static final DataParameter<LightOrbBehavior> SYNC_BEHAVIOR = EntityDataManager.func_187226_a(EntityLightOrb.class, LightOrbBehavior.DATA_SERIALIZER);
    private static final DataParameter<String> SYNC_TEXTURE = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> SYNC_ANIMATED_TEXTURE_FRAMES_COUNT = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SYNC_TYPE = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SYNC_SIZE = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_INITIAL_SIZE = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> SYNC_RADIUS = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SYNC_COLOUR_R = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_COLOUR_G = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_COLOUR_B = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_COLOUR_A = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_INITIAL_COLOUR_R = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_INITIAL_COLOUR_G = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_INITIAL_COLOUR_B = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_INITIAL_COLOUR_A = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<String> SYNC_EMITTING_ENTITY = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> SYNC_COLOUR_RANGE = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_COLOUR_INTERVAL = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> SYNC_SPINNING = EntityDataManager.func_187226_a(EntityLightOrb.class, (DataSerializer)DataSerializers.field_187198_h);
    int ticks = 1;
    private int lifeTime = -1;

    public EntityLightOrb(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70145_X = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_BEHAVIOR, (Object)new LightOrbBehavior.Idle());
        this.field_70180_af.func_187214_a(SYNC_TEXTURE, (Object)"avatarmod:textures/entity/sphere.png");
        this.field_70180_af.func_187214_a(SYNC_ANIMATED_TEXTURE_FRAMES_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(SYNC_TYPE, (Object)EnumType.COLOR_SPHERE.ordinal());
        this.field_70180_af.func_187214_a(SYNC_SIZE, (Object)Float.valueOf(2.0f));
        this.field_70180_af.func_187214_a(SYNC_INITIAL_SIZE, (Object)Float.valueOf(2.0f));
        this.field_70180_af.func_187214_a(SYNC_RADIUS, (Object)20);
        this.field_70180_af.func_187214_a(SYNC_COLOUR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_COLOUR_G, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_COLOUR_B, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_COLOUR_A, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_INITIAL_COLOUR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_INITIAL_COLOUR_G, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_INITIAL_COLOUR_B, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_INITIAL_COLOUR_A, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_COLOUR_RANGE, (Object)Float.valueOf(0.1f));
        this.field_70180_af.func_187214_a(SYNC_COLOUR_INTERVAL, (Object)Float.valueOf(0.025f));
        this.field_70180_af.func_187214_a(SYNC_SPINNING, (Object)false);
        this.field_70180_af.func_187214_a(SYNC_EMITTING_ENTITY, (Object)"06256730-5d15-4e0f-b49b-997644ac6f59");
    }

    public LightOrbBehavior getBehavior() {
        return (LightOrbBehavior)this.field_70180_af.func_187225_a(SYNC_BEHAVIOR);
    }

    public void setBehavior(LightOrbBehavior behavior) {
        this.field_70180_af.func_187227_b(SYNC_BEHAVIOR, (Object)behavior);
    }

    public String getTexture() {
        return (String)this.field_70180_af.func_187225_a(SYNC_TEXTURE);
    }

    public void setTexture(String texture) {
        this.field_70180_af.func_187227_b(SYNC_TEXTURE, (Object)texture);
    }

    public String getTrueTexture() {
        if (this.getTextureFrameCount() > 0) {
            return this.getTexture().replace("%number%", String.valueOf(this.ticks));
        }
        return (String)this.field_70180_af.func_187225_a(SYNC_TEXTURE);
    }

    public int getTextureFrameCount() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_ANIMATED_TEXTURE_FRAMES_COUNT);
    }

    public int getCurrentTextureNumber() {
        return this.ticks;
    }

    public void setTextureFrameCount(int value) {
        this.field_70180_af.func_187227_b(SYNC_ANIMATED_TEXTURE_FRAMES_COUNT, (Object)value);
    }

    public EnumType getType() {
        return EnumType.values()[(Integer)this.field_70180_af.func_187225_a(SYNC_TYPE)];
    }

    public void setType(EnumType type) {
        this.field_70180_af.func_187227_b(SYNC_TYPE, (Object)type.ordinal());
    }

    public Entity getEmittingEntity() {
        return this.getOwner();
    }

    public void setEmittingEntity(Entity entity) {
        this.field_70180_af.func_187227_b(SYNC_EMITTING_ENTITY, (Object)entity.func_110124_au().toString());
    }

    public float getColourShiftRange() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_COLOUR_RANGE)).floatValue();
    }

    public void setColourShiftRange(float range) {
        this.field_70180_af.func_187227_b(SYNC_COLOUR_RANGE, (Object)Float.valueOf(range));
    }

    public float getColourShiftInterval() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_COLOUR_INTERVAL)).floatValue();
    }

    public void setColourShiftInterval(float interval) {
        this.field_70180_af.func_187227_b(SYNC_COLOUR_INTERVAL, (Object)Float.valueOf(interval));
    }

    public void setLifeTime(int ticks) {
        this.lifeTime = ticks;
    }

    public void setColor(float r, float g, float b, float a) {
        this.field_70180_af.func_187227_b(SYNC_COLOUR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(SYNC_COLOUR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(SYNC_COLOUR_B, (Object)Float.valueOf(b));
        this.field_70180_af.func_187227_b(SYNC_COLOUR_A, (Object)Float.valueOf(a));
        this.field_70180_af.func_187227_b(SYNC_INITIAL_COLOUR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(SYNC_INITIAL_COLOUR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(SYNC_INITIAL_COLOUR_B, (Object)Float.valueOf(b));
        this.field_70180_af.func_187227_b(SYNC_INITIAL_COLOUR_A, (Object)Float.valueOf(a));
    }

    public int getLightRadius() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_RADIUS);
    }

    public void setLightRadius(int radius) {
        this.field_70180_af.func_187227_b(SYNC_RADIUS, (Object)radius);
    }

    public float getOrbSize() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_SIZE)).floatValue();
    }

    public void setSpinning(boolean spinning) {
        this.field_70180_af.func_187227_b(SYNC_SPINNING, (Object)spinning);
    }

    public boolean isSpinning() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_SPINNING);
    }

    public void setOrbSize(float size) {
        this.field_70180_af.func_187227_b(SYNC_SIZE, (Object)Float.valueOf(size));
    }

    public void setInitialSize(float size) {
        this.field_70180_af.func_187227_b(SYNC_INITIAL_SIZE, (Object)Float.valueOf(size));
    }

    public float getInitialSize() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_INITIAL_SIZE)).floatValue();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.setBehavior((LightOrbBehavior)this.getBehavior().onUpdate(this));
        if (this.field_70170_p.field_72995_K && this.getTextureFrameCount() > 0) {
            ++this.ticks;
            if (this.ticks == this.getTextureFrameCount()) {
                this.ticks = 1;
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > this.lifeTime && this.lifeTime != -1) {
            this.func_70106_y();
        }
        if (this.getBehavior() instanceof LightOrbBehavior.FollowEntity && this.getEmittingEntity() == null) {
            this.func_70106_y();
        }
    }

    @Override
    public boolean func_70067_L() {
        return false;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTexture(nbt.func_74779_i("OrbTexture"));
        this.setType(EnumType.values()[nbt.func_74762_e("OrbType")]);
        this.setTextureFrameCount(nbt.func_74762_e("FrameCount"));
        this.setOrbSize(nbt.func_74760_g("OrbSize"));
        this.setLightRadius(nbt.func_74762_e("OrbRadius"));
        this.setColorR(nbt.func_74760_g("OrbColorR"));
        this.setColorG(nbt.func_74760_g("OrbColorG"));
        this.setColorB(nbt.func_74760_g("OrbColorB"));
        this.setColorA(nbt.func_74760_g("OrbColorA"));
        this.setBehavior((LightOrbBehavior)Behavior.lookup(nbt.func_74762_e("Behaviour"), this));
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("OrbTexture", this.getTexture());
        nbt.func_74768_a("OrbType", this.getType().ordinal());
        nbt.func_74768_a("FrameCount", this.getTextureFrameCount());
        nbt.func_74776_a("OrbSize", this.getOrbSize());
        nbt.func_74768_a("OrbRadius", this.getLightRadius());
        nbt.func_74776_a("OrbColorR", this.getColorR());
        nbt.func_74776_a("OrbColorG", this.getColorG());
        nbt.func_74776_a("OrbColorB", this.getColorB());
        nbt.func_74776_a("OrbColorA", this.getColorA());
        nbt.func_74768_a("Behaviour", this.getBehavior().getId());
    }

    public float getColorR() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_COLOUR_R)).floatValue();
    }

    public void setColorR(float value) {
        this.field_70180_af.func_187227_b(SYNC_COLOUR_R, (Object)Float.valueOf(value));
    }

    public float getColorG() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_COLOUR_G)).floatValue();
    }

    public void setColorG(float value) {
        this.field_70180_af.func_187227_b(SYNC_COLOUR_G, (Object)Float.valueOf(value));
    }

    public float getColorB() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_COLOUR_B)).floatValue();
    }

    public void setColorB(float value) {
        this.field_70180_af.func_187227_b(SYNC_COLOUR_B, (Object)Float.valueOf(value));
    }

    public float getColorA() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_COLOUR_A)).floatValue();
    }

    public void setColorA(float value) {
        this.field_70180_af.func_187227_b(SYNC_COLOUR_A, (Object)Float.valueOf(value));
    }

    public float getInitialColourR() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_INITIAL_COLOUR_R)).floatValue();
    }

    public float getInitialColourG() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_INITIAL_COLOUR_G)).floatValue();
    }

    public float getInitialColourB() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_INITIAL_COLOUR_B)).floatValue();
    }

    public float getInitialColourA() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_INITIAL_COLOUR_A)).floatValue();
    }

    public boolean shouldUseCustomTexture() {
        return this.getType() == EnumType.TEXTURE_CUBE || this.getType() == EnumType.TEXTURE_SPHERE;
    }

    public boolean isColorSphere() {
        return this.getType() == EnumType.COLOR_SPHERE;
    }

    public boolean isTextureSphere() {
        return this.getType() == EnumType.TEXTURE_SPHERE;
    }

    public boolean isSphere() {
        return this.isTextureSphere() || this.isColorSphere();
    }

    @Optional.Method(modid="hammercore")
    public ColoredLight produceColoredLight(float partialTicks) {
        return ColoredLight.builder().pos((Entity)this).color(this.getColorR(), this.getColorG(), this.getColorB()).radius((float)this.getLightRadius()).build();
    }

    public static enum EnumType {
        COLOR_SPHERE,
        COLOR_CUBE,
        TEXTURE_SPHERE,
        TEXTURE_CUBE,
        NOTHING;

    }
}

