/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BattlePerformanceScore;
import com.crowsofwar.avatar.bending.bending.lightning.AbilityLightningArc;
import com.crowsofwar.avatar.bending.bending.lightning.Lightningbending;
import com.crowsofwar.avatar.client.particle.AvatarParticles;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.entity.ControlPoint;
import com.crowsofwar.avatar.entity.EntityArc;
import com.crowsofwar.avatar.entity.EntityShockwave;
import com.crowsofwar.avatar.entity.data.LightningFloodFill;
import com.crowsofwar.avatar.joml.Matrix4d;
import com.crowsofwar.avatar.joml.SimplexNoise;
import com.crowsofwar.avatar.joml.Vector4d;
import com.crowsofwar.avatar.util.AvatarDataSerializers;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.damageutils.AvatarDamageSource;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.gorecore.util.Vector;
import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity", modid="hammercore")
public class EntityLightningArc
extends EntityArc<LightningControlPoint>
implements IGlowingEntity {
    private static final DataParameter<Vector> SYNC_ENDPOS = EntityDataManager.func_187226_a(EntityLightningArc.class, AvatarDataSerializers.SERIALIZER_VECTOR);
    private static final DataParameter<Float> SYNC_TURBULENCE = EntityDataManager.func_187226_a(EntityLightningArc.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_SIZE = EntityDataManager.func_187226_a(EntityLightningArc.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> SYNC_MAIN_ARC = EntityDataManager.func_187226_a(EntityLightningArc.class, (DataSerializer)DataSerializers.field_187198_h);
    @Nullable
    private EntityLivingBase stuckTo;
    private int stuckTime;
    private boolean wasRedirected;
    private boolean wasSuccessfullyRedirected;
    private boolean createdByRedirection;
    private float damage;
    private LightningFloodFill floodFill;

    public EntityLightningArc(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.damage = 8.0f;
        this.setsFires = true;
    }

    private void LightningBurst(double x, double y, double z) {
        EntityShockwave wave = new EntityShockwave(this.field_70170_p);
        wave.setAbility(this.getAbility());
        wave.setOwner(this.getOwner());
        wave.setParticleSpeed(this.getSizeMultiplier() / 4.0f / 5.0f);
        wave.setParticle(AvatarParticles.getParticleElectricity());
        wave.setSpeed(0.5f + this.getSizeMultiplier() / 10.0f);
        wave.setDamageSource("avatar_Lightning_shockwave");
        wave.func_70107_b(x, y + 0.3, z);
        wave.setParticleSpeed(0.05f);
        wave.setParticleAmount(1);
        wave.setParticleWaves(1);
        wave.setDamage(this.getDamage() / 2.0f);
        wave.setRange(6.0f + this.getSizeMultiplier() * 2.0f);
        wave.setRange(this.getSizeMultiplier());
        wave.func_70015_d(3 + AbilityData.get(this.getOwner(), this.getAbility().getName()).getLevel() + 1);
        wave.setParticleController(54.0f - this.getSizeMultiplier() * 7.0f);
        wave.setSphere(true);
        wave.setElement(new Lightningbending());
        wave.setPerformanceAmount(10);
        wave.setKnockbackHeight(0.02);
        this.field_70170_p.func_72838_d((Entity)wave);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_ENDPOS, (Object)Vector.ZERO);
        this.field_70180_af.func_187214_a(SYNC_TURBULENCE, (Object)Float.valueOf(0.6f));
        this.field_70180_af.func_187214_a(SYNC_SIZE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_MAIN_ARC, (Object)true);
    }

    @Override
    public int getAmountOfControlPoints() {
        return 12;
    }

    @Override
    public void func_70071_h_() {
        boolean stuckIsDead;
        super.func_70071_h_();
        if (this.isMainArc()) {
            this.onUpdateMainArc();
        }
        if (this.getOwner() != null) {
            Vector controllerPos = Vector.getEyePos((Entity)this.getOwner());
            Vector endPosition = this.getEndPos();
            Vector position = controllerPos;
            position = position.minusY(0.3);
            position = position.plus(endPosition.minus(position).dividedBy(10.0));
            this.setEndPos(position);
            Vector newRotations = Vector.getRotationTo(this.position(), this.getEndPos());
            this.field_70177_z = (float)Math.toDegrees(newRotations.y());
            this.field_70125_A = (float)Math.toDegrees(newRotations.x());
        }
        if (this.stuckTo != null && this.getOwner() != null) {
            this.setPosition(Vector.getEyePos((Entity)this.stuckTo));
            this.setVelocity(Vector.ZERO);
            if (!this.wasSuccessfullyRedirected) {
                this.damageEntity(this.stuckTo, 0.333f);
            }
            ((LightningControlPoint)this.getControlPoint(11)).setPosition(Vector.getLookRectangular((Entity)this.getOwner()).times(2.0).plus(Vector.getEntityPos((Entity)this.getOwner())));
            ((LightningControlPoint)this.getControlPoint(0)).setPosition(Vector.getEntityPos((Entity)this.stuckTo));
        }
        if (this.velocity().equals(Vector.ZERO)) {
            ++this.stuckTime;
            if (this.stuckTime == 1) {
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187754_de, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
        boolean existTooLong = this.stuckTime >= 40 || this.field_70173_aa >= 200;
        boolean bl = stuckIsDead = this.stuckTo != null && this.stuckTo.field_70128_L;
        if (existTooLong || stuckIsDead) {
            this.func_70106_y();
        }
        this.func_70105_a(0.33f * this.getSizeMultiplier(), 0.33f * this.getSizeMultiplier());
    }

    private void onUpdateMainArc() {
        if (this.field_70170_p.field_72995_K) {
            double threshold;
            double d = threshold = this.stuckTime >= 0 ? 0.2 : 0.3;
            if ((double)SimplexNoise.noise(this.field_70173_aa * 2, 0.0f) >= threshold) {
                this.field_70170_p.func_175702_c(2);
            }
        }
        if (this.field_70171_ac && !this.field_70170_p.field_72995_K) {
            if (this.floodFill == null) {
                this.floodFill = new LightningFloodFill(this.field_70170_p, this.func_180425_c(), 12, this::handleWaterElectrocution);
            }
            this.floodFill.tick();
        }
    }

    @Override
    protected void updateCpBehavior() {
        if (this.getOwner() != null) {
            for (LightningControlPoint controlPoint : this.getControlPoints()) {
                controlPoint.setPosition(controlPoint.getPosition(this.field_70173_aa));
            }
        }
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        AbilityData aD;
        if (this.getAbility() instanceof AbilityLightningArc && !this.field_70170_p.field_72995_K && this.getOwner() != null && (aD = AbilityData.get(this.getOwner(), "lightning_arc")).isMasterPath(AbilityData.AbilityTreePath.SECOND) && entity instanceof EntityLivingBase) {
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187754_de, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.damageEntity((EntityLivingBase)entity, 1.0f);
            this.LightningBurst(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entity.field_70145_X = false;
            this.func_70106_y();
        }
        if (this.stuckTo == null && entity instanceof EntityLivingBase) {
            this.stuckTo = (EntityLivingBase)entity;
        }
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return entity != this.getOwner();
    }

    @Override
    protected void collideWithNearbyEntities() {
        if (this.getOwner() != null) {
            List<Entity> collisions = Raytrace.entityRaytrace(this.field_70170_p, this.position(), Vector.getEntityPos((Entity)this.getOwner()).minus(this.position()), (double)this.func_70032_d((Entity)this.getOwner()), entity -> entity != this.getOwner() && entity != this);
            for (Entity collided : collisions) {
                if (!this.canCollideWith(collided)) continue;
                this.onCollideWithEntity(collided);
            }
        }
    }

    private void handleWaterElectrocution(EntityLivingBase entity) {
        double distance = entity.func_70032_d((Entity)this);
        float damageModifier = (float)(1.0 - distance / 12.0 * (distance / 12.0));
        this.damageEntity(entity, damageModifier);
    }

    private void damageEntity(EntityLivingBase entity, float damageModifier) {
        if (this.field_70170_p.field_72995_K || this.getOwner() == null) {
            return;
        }
        if (!this.isMainArc()) {
            return;
        }
        if (!this.wasRedirected && this.isMainArc() && entity == this.stuckTo && Bender.isBenderSupported(entity)) {
            this.wasSuccessfullyRedirected = Objects.requireNonNull(Bender.get(entity)).redirectLightning(this);
            this.wasRedirected = true;
        }
        DamageSource damageSource = this.createDamageSource(entity);
        if (!this.wasSuccessfullyRedirected && entity.func_70097_a(damageSource, this.damage * damageModifier)) {
            BendingData data;
            BattlePerformanceScore.addLargeScore(this.getOwner());
            entity.func_70015_d(4);
            Vector velocity = Vector.getEntityPos((Entity)entity).minus(this.position()).normalize();
            velocity = velocity.times(2.0);
            entity.func_70024_g(velocity.x(), 0.4, velocity.z());
            AvatarUtils.afterVelocityAdded((Entity)entity);
            if (this.getOwner() != null && (data = BendingData.getFromEntity(this.getOwner())) != null) {
                AbilityData abilityData = data.getAbilityData("lightning_arc");
                abilityData.addXp(ConfigSkills.SKILLS_CONFIG.struckWithLightning);
            }
        }
    }

    private DamageSource createDamageSource(EntityLivingBase target) {
        if (this.createdByRedirection) {
            return AvatarDamageSource.causeRedirectedLightningDamage((Entity)target, (Entity)this.getOwner());
        }
        return AvatarDamageSource.causeLightningDamage((Entity)target, (Entity)this.getOwner());
    }

    @Override
    public boolean onCollideWithSolid() {
        this.func_70106_y();
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.LightningBurst(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        return false;
    }

    @Override
    protected LightningControlPoint createControlPoint(float size, int index) {
        return new LightningControlPoint(this, index);
    }

    public Vector getEndPos() {
        return (Vector)this.field_70180_af.func_187225_a(SYNC_ENDPOS);
    }

    public void setEndPos(Vector endPos) {
        this.field_70180_af.func_187227_b(SYNC_ENDPOS, (Object)endPos);
    }

    public float getTurbulence() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_TURBULENCE)).floatValue();
    }

    public void setTurbulence(float turbulence) {
        this.field_70180_af.func_187227_b(SYNC_TURBULENCE, (Object)Float.valueOf(turbulence));
    }

    @Override
    public float getDamage() {
        return this.damage;
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getSizeMultiplier() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_SIZE)).floatValue();
    }

    public void setSizeMultiplier(float sizeMultiplier) {
        this.field_70180_af.func_187227_b(SYNC_SIZE, (Object)Float.valueOf(sizeMultiplier));
    }

    public boolean isMainArc() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_MAIN_ARC);
    }

    public void setMainArc(boolean mainArc) {
        this.field_70180_af.func_187227_b(SYNC_MAIN_ARC, (Object)mainArc);
    }

    public boolean isCreatedByRedirection() {
        return this.createdByRedirection;
    }

    public void setCreatedByRedirection(boolean createdByRedirection) {
        this.createdByRedirection = createdByRedirection;
    }

    @Optional.Method(modid="hammercore")
    public ColoredLight produceColoredLight(float partialTicks) {
        return ColoredLight.builder().pos((Entity)this).color(87.0f, 161.0f, 235.0f).radius(10.0f).build();
    }

    public class LightningControlPoint
    extends ControlPoint {
        private final int index;

        public LightningControlPoint(EntityArc arc, int index) {
            super(arc, 0.1f, 0.0, 0.0, 0.0);
            this.index = index;
        }

        public Vector getPosition(float ticks) {
            float partialTicks = ticks - (float)((int)ticks);
            Vector arcPos = this.arc.position().plus(this.arc.velocity().dividedBy(20.0).times(partialTicks));
            double targetDist = arcPos.dist(EntityLightningArc.this.getEndPos()) / (double)EntityLightningArc.this.getControlPoints().size();
            Vector dir = Vector.getLookRectangular(this.arc);
            Vector normalPosition = arcPos.plus(dir.times(targetDist).times(this.index));
            Vector randomize = Vector.ZERO;
            if (this.index != this.arc.getControlPoints().size() - 1 && this.index != 0) {
                double actualOffX = SimplexNoise.noise(ticks / 25.0f * EntityLightningArc.this.getTurbulence() + (float)this.index / 1.0f, EntityLightningArc.this.func_145782_y() * 1000) * EntityLightningArc.this.getTurbulence();
                double actualOffY = SimplexNoise.noise(ticks / 25.0f * EntityLightningArc.this.getTurbulence() + (float)this.index / 1.0f, EntityLightningArc.this.func_145782_y() * 2000) * EntityLightningArc.this.getTurbulence();
                Matrix4d matrix = new Matrix4d();
                matrix.rotate(Math.toRadians(EntityLightningArc.this.field_70177_z), 0.0, 1.0, 0.0);
                matrix.rotate(Math.toRadians(EntityLightningArc.this.field_70125_A), 1.0, 0.0, 0.0);
                Vector4d randomJoml = new Vector4d(actualOffX, actualOffY, 0.0, 1.0);
                randomJoml.mul(matrix);
                randomize = new Vector(randomJoml.x, randomJoml.y, randomJoml.z);
            }
            return normalPosition.plus(randomize);
        }

        @Override
        public Vector getInterpolatedPosition(float partialTicks) {
            return this.getPosition((float)this.arc.field_70173_aa + partialTicks);
        }
    }
}

