/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.lightning.Lightningbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.entity.data.LightningFloodFill;
import com.crowsofwar.avatar.entity.data.LightningSpearBehavior;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.damageutils.AvatarDamageSource;
import com.crowsofwar.avatar.util.damageutils.DamageUtils;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.gorecore.util.Vector;
import com.zeitheron.hammercore.api.lighting.ColoredLight;
import com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="com.zeitheron.hammercore.api.lighting.impl.IGlowingEntity", modid="hammercore")
public class EntityLightningSpear
extends EntityOffensive
implements IGlowingEntity {
    private static final DataParameter<LightningSpearBehavior> SYNC_BEHAVIOR = EntityDataManager.func_187226_a(EntityLightningSpear.class, LightningSpearBehavior.DATA_SERIALIZER);
    private static final DataParameter<Float> SYNC_DEGREES_PER_SECOND = EntityDataManager.func_187226_a(EntityLightningSpear.class, (DataSerializer)DataSerializers.field_187193_c);
    private boolean piercing = false;
    private boolean groupAttack;
    private LightningFloodFill floodFill;

    public EntityLightningSpear(World world) {
        super(world);
    }

    @Override
    public int getFireTime() {
        return 0;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_BEHAVIOR, (Object)new LightningSpearBehavior.Idle());
        this.field_70180_af.func_187214_a(SYNC_DEGREES_PER_SECOND, (Object)Float.valueOf(400.0f));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.setBehavior((LightningSpearBehavior)this.getBehavior().onUpdate(this));
        LightningSpearBehavior.PlayerControlled controlled = new LightningSpearBehavior.PlayerControlled();
        if (this.getOwner() != null) {
            EntityLightningSpear spear = AvatarEntity.lookupControlledEntity(this.field_70170_p, EntityLightningSpear.class, this.getOwner());
            BendingData bD = BendingData.get(this.getOwner());
            if (spear == null && bD.hasStatusControl(StatusControlController.THROW_LIGHTNINGSPEAR)) {
                bD.removeStatusControl(StatusControlController.THROW_LIGHTNINGSPEAR);
            }
            if (spear != null && spear.getBehavior().equals(controlled) && !bD.hasStatusControl(StatusControlController.THROW_LIGHTNINGSPEAR)) {
                bD.addStatusControl(StatusControlController.THROW_LIGHTNINGSPEAR);
            }
        }
        if (this.field_70170_p.field_72995_K && this.getOwner() != null) {
            int i;
            float mult = 0.5f;
            if (this.getBehavior() instanceof LightningSpearBehavior.Thrown) {
                mult = 1.0f;
            }
            for (i = 0; i < 4; ++i) {
                Vec3d mid = AvatarEntityUtils.getMiddleOfEntity(this);
                double spawnX = mid.field_72450_a + this.field_70170_p.field_73012_v.nextGaussian() / 20.0;
                double spawnY = mid.field_72448_b + this.field_70170_p.field_73012_v.nextGaussian() / 20.0;
                double spawnZ = mid.field_72449_c + this.field_70170_p.field_73012_v.nextGaussian() / 20.0;
                ParticleBuilder.create(ParticleBuilder.Type.SPARK).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 25.0, this.field_70170_p.field_73012_v.nextGaussian() / 25.0, this.field_70170_p.field_73012_v.nextGaussian() / 25.0).time(4 + AvatarUtils.getRandomNumberInRange(0, 6)).spawnEntity(this).scale(mult * this.getAvgSize() * (1.0f / this.getAvgSize() + 1.0f)).element(this.getElement()).collide(true).spawn(this.field_70170_p);
                ParticleBuilder.create(ParticleBuilder.Type.SPARK).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 45.0 + this.field_70159_w, this.field_70170_p.field_73012_v.nextGaussian() / 45.0 + this.field_70181_x, this.field_70170_p.field_73012_v.nextGaussian() / 45.0 + this.field_70179_y).time(14 + AvatarUtils.getRandomNumberInRange(0, 10)).spawnEntity(this).scale(mult * this.getAvgSize() * (1.0f / this.getAvgSize() + 0.5f)).element(this.getElement()).collide(true).spawn(this.field_70170_p);
            }
            for (i = 0; i < 2; ++i) {
                Vec3d pos = Vector.getOrthogonalVector(this.func_70040_Z(), (double)((float)(i * 180) + (float)(this.field_70173_aa % 360 * 20) * (1.0f / this.getAvgSize())), (double)(this.getAvgSize() / 1.5f)).toMinecraft();
                Vec3d entityPos = AvatarEntityUtils.getMiddleOfEntity(this);
                pos = pos.func_178787_e(entityPos);
                Vec3d velocity = pos.func_178788_d(entityPos).func_72432_b();
                velocity = velocity.func_186678_a(AvatarUtils.getSqrMagnitude(this.getVelocity()) / 400000.0);
                double spawnX = pos.field_72450_a;
                double spawnY = pos.field_72448_b;
                double spawnZ = pos.field_72449_c;
                ParticleBuilder.create(ParticleBuilder.Type.SPARK).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 80.0 + velocity.field_72450_a, this.field_70170_p.field_73012_v.nextGaussian() / 80.0 + velocity.field_72448_b, this.field_70170_p.field_73012_v.nextGaussian() / 80.0 + velocity.field_72449_c).time(6 + AvatarUtils.getRandomNumberInRange(0, 4)).spawnEntity(this).scale(mult * this.getAvgSize() * (1.0f / this.getAvgSize())).element(this.getElement()).collide(true).collideParticles(true).spawn(this.field_70170_p);
                ParticleBuilder.create(ParticleBuilder.Type.SPARK).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 80.0 + velocity.field_72450_a, this.field_70170_p.field_73012_v.nextGaussian() / 80.0 + velocity.field_72448_b, this.field_70170_p.field_73012_v.nextGaussian() / 80.0 + velocity.field_72449_c).time(10 + AvatarUtils.getRandomNumberInRange(0, 6)).spawnEntity(this).scale(mult * this.getAvgSize() * (1.0f / this.getAvgSize())).element(this.getElement()).collide(true).collideParticles(true).spawn(this.field_70170_p);
            }
        }
        if (this.field_70171_ac) {
            this.func_82142_c(true);
            this.setVelocity(Vector.ZERO);
        }
        if (this.field_70171_ac && !this.field_70170_p.field_72995_K) {
            if (this.floodFill == null) {
                this.floodFill = new LightningFloodFill(this.field_70170_p, this.func_180425_c(), 12, this::handleWaterElectrocution);
            }
            if (this.floodFill.tick()) {
                this.func_70106_y();
            }
        }
        this.setEntitySize(this.getAvgSize());
    }

    @Override
    public BendingStyle getElement() {
        return new Lightningbending();
    }

    @Override
    public SoundEvent[] getSounds() {
        SoundEvent[] events = new SoundEvent[]{SoundEvents.field_187752_dd, SoundEvents.field_187754_de};
        return events;
    }

    @Override
    public float getAoeDamage() {
        return this.getDamage() / 10.0f;
    }

    @Override
    public double getExpandedHitboxHeight() {
        return this.getAvgSize() / 4.0f;
    }

    @Override
    public double getExpandedHitboxWidth() {
        return this.getAvgSize() / 4.0f;
    }

    @Override
    public DamageSource getDamageSource(Entity target, EntityLivingBase owner) {
        return AvatarDamageSource.causeLightningSpearDamage(target, (Entity)owner);
    }

    private void handleWaterElectrocution(Entity entity) {
        DamageSource damageSource = AvatarDamageSource.causeLightningDamage(entity, (Entity)this.getOwner());
        DamageUtils.attackEntity(this.getOwner(), entity, damageSource, this.getDamage() / 5.0f, this.getPerformanceAmount(), this.getAbility(), this.getXpPerHit());
    }

    public LightningSpearBehavior getBehavior() {
        return (LightningSpearBehavior)this.field_70180_af.func_187225_a(SYNC_BEHAVIOR);
    }

    public void setBehavior(LightningSpearBehavior behavior) {
        this.field_70180_af.func_187227_b(SYNC_BEHAVIOR, (Object)behavior);
    }

    @Override
    public EntityLivingBase getController() {
        return this.getBehavior() instanceof LightningSpearBehavior.PlayerControlled ? this.getOwner() : null;
    }

    @Override
    public boolean isPiercing() {
        return this.piercing;
    }

    @Override
    public void setPiercing(boolean piercing) {
        this.piercing = piercing;
    }

    public boolean isGroupAttack() {
        return this.groupAttack;
    }

    public void setGroupAttack(boolean groupAttack) {
        this.groupAttack = groupAttack;
    }

    public float getDegreesPerSecond() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_DEGREES_PER_SECOND)).floatValue();
    }

    public void setDegreesPerSecond(float degrees) {
        this.field_70180_af.func_187227_b(SYNC_DEGREES_PER_SECOND, (Object)Float.valueOf(degrees));
    }

    @Override
    public boolean onCollideWithSolid() {
        if (this.getBehavior() instanceof LightningSpearBehavior.Thrown) {
            return super.onCollideWithSolid();
        }
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setBehavior((LightningSpearBehavior)Behavior.lookup(nbt.func_74762_e("Behavior"), this));
        this.setPiercing(nbt.func_74767_n("Piercing"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("Behavior", this.getBehavior().getId());
        nbt.func_74757_a("Piercing", this.piercing);
    }

    @Override
    public boolean func_70104_M() {
        return this.piercing;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_70128_L && !this.field_70170_p.field_72995_K) {
            Thread.dumpStack();
        }
        this.removeStatCtrl();
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        if (this.getBehavior() instanceof LightningSpearBehavior.Thrown && this.getBehavior() != null) {
            super.onCollideWithEntity(entity);
        }
    }

    public void removeStatCtrl() {
        if (this.getOwner() != null) {
            BendingData data = Objects.requireNonNull(Bender.get(this.getOwner())).getData();
            data.removeStatusControl(StatusControlController.THROW_LIGHTNINGSPEAR);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    public int func_70070_b() {
        return 0xF000F0;
    }

    @Override
    public boolean func_70067_L() {
        return !(this.getBehavior() instanceof LightningSpearBehavior.PlayerControlled);
    }

    @Override
    public boolean func_70075_an() {
        return !(this.getBehavior() instanceof LightningSpearBehavior.PlayerControlled);
    }

    @Override
    public void applyElementalContact(AvatarEntity entity) {
        super.applyElementalContact(entity);
        entity.onLightningContact();
    }

    @Override
    public float getXpPerHit() {
        return ConfigSkills.SKILLS_CONFIG.lightningspearHit;
    }

    @Override
    public int getPerformanceAmount() {
        return 15;
    }

    @Override
    public EnumParticleTypes getParticle() {
        return null;
    }

    @Override
    public boolean shouldExplode() {
        return this.getBehavior() instanceof LightningSpearBehavior.Thrown;
    }

    @Override
    public boolean shouldDissipate() {
        return this.getBehavior() instanceof LightningSpearBehavior.Thrown;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public float getVolume() {
        return super.getVolume() * 6.0f;
    }

    @Optional.Method(modid="hammercore")
    public ColoredLight produceColoredLight(float partialTicks) {
        return ColoredLight.builder().pos((Entity)this).color(87.0f, 161.0f, 235.0f).radius(10.0f).build();
    }
}

