/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.combustion.Combustionbending;
import com.crowsofwar.avatar.bending.bending.lightning.Lightningbending;
import com.crowsofwar.avatar.client.particle.AvatarParticles;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityShield;
import com.crowsofwar.avatar.entity.EntityWall;
import com.crowsofwar.avatar.entity.EntityWallSegment;
import com.crowsofwar.avatar.entity.IOffensiveEntity;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.damageutils.AvatarDamageSource;
import com.crowsofwar.gorecore.util.GoreCoreNBTUtil;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityOffensive
extends AvatarEntity
implements IOffensiveEntity {
    private static final DataParameter<Float> SYNC_DAMAGE = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> SYNC_LIFETIME = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SYNC_HEIGHT = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_WIDTH = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_MAX_HEIGHT = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_MAX_WIDTH = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<OffensiveBehaviour> SYNC_BEHAVIOR = EntityDataManager.func_187226_a(EntityOffensive.class, OffensiveBehaviour.DATA_SERIALIZER);
    private static final DataParameter<Boolean> SYNC_PIERCES = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> SYNC_EXPLOSION_SIZE = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> SYNC_R = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SYNC_G = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SYNC_B = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SYNC_FADE_R = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SYNC_FADE_G = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SYNC_FADE_B = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SYNC_REDIRECTABLE = EntityDataManager.func_187226_a(EntityOffensive.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final double SPREAD_FACTOR = 0.1;
    private static final double IMPACT_FRICTION = 0.4;
    private float xp = 3.0f;
    private float push;
    private float chiHit;
    private int fireTime = 3;
    private boolean dynamicSpreadingCollision = false;
    private boolean collidedWithSolid;
    private int performanceAmount = 20;
    private int ticks = 0;
    private int ticksMoving = 0;
    private double prevVelX = 0.0;
    private double prevVelY = 0.0;
    private double prevVelZ = 0.0;
    private Predicate<Entity> solidEntities = entity -> entity instanceof EntityWall || entity instanceof EntityWallSegment || entity instanceof EntityShield && ((EntityShield)entity).getOwner() != this.getOwner();
    private String damageSource;
    private float explosionStrength;
    private float explosionDamage;

    public EntityOffensive(World world) {
        super(world);
        this.field_70130_N = this.getWidth();
        this.field_70131_O = this.getHeight();
        this.damageSource = AvatarDamageSource.FIRE.func_76355_l();
        this.push = 1.0f;
        this.chiHit = 1.0f;
        this.explosionStrength = 0.4f;
        this.explosionDamage = 1.0f;
    }

    @Override
    public float getPush() {
        return this.push;
    }

    public void setPush(float push) {
        this.push = push;
    }

    public OffensiveBehaviour getBehaviour() {
        return (OffensiveBehaviour)this.field_70180_af.func_187225_a(SYNC_BEHAVIOR);
    }

    public void setBehaviour(OffensiveBehaviour behaviour) {
        this.field_70180_af.func_187227_b(SYNC_BEHAVIOR, (Object)behaviour);
    }

    public boolean getDynamicSpreadingCollision() {
        return this.dynamicSpreadingCollision;
    }

    public void setDynamicSpreadingCollision(boolean collision) {
        this.dynamicSpreadingCollision = collision;
    }

    public void setSolidEntityPredicate(Predicate<Entity> predicate) {
        this.solidEntities = predicate;
    }

    public void setSolidEntityPredicateOr(Predicate<Entity> predicate) {
        this.solidEntities = this.solidEntities.or(predicate);
    }

    public void setSolidEntityPredicateAnd(Predicate<Entity> predicate) {
        this.solidEntities = this.solidEntities.and(predicate);
    }

    public Predicate<Entity> getSolidEntities() {
        return this.solidEntities;
    }

    public float getHeight() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_HEIGHT)).floatValue();
    }

    public float getWidth() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_WIDTH)).floatValue();
    }

    public float getMaxHeight() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_MAX_HEIGHT)).floatValue();
    }

    public float getMaxWidth() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_MAX_WIDTH)).floatValue();
    }

    public float getAvgSize() {
        if (this.getHeight() == this.getWidth()) {
            return this.getHeight();
        }
        return (this.getHeight() + this.getWidth()) / 2.0f;
    }

    public void setEntitySize(float height, float width) {
        this.field_70180_af.func_187227_b(SYNC_HEIGHT, (Object)Float.valueOf(height));
        this.field_70180_af.func_187227_b(SYNC_WIDTH, (Object)Float.valueOf(width));
    }

    public void setEntitySize(float size) {
        this.field_70180_af.func_187227_b(SYNC_HEIGHT, (Object)Float.valueOf(size));
        this.field_70180_af.func_187227_b(SYNC_WIDTH, (Object)Float.valueOf(size));
    }

    public void setMaxEntitySize(float height, float width) {
        this.field_70180_af.func_187227_b(SYNC_MAX_HEIGHT, (Object)Float.valueOf(height));
        this.field_70180_af.func_187227_b(SYNC_MAX_WIDTH, (Object)Float.valueOf(width));
    }

    public void setMaxEntitySize(float size) {
        this.field_70180_af.func_187227_b(SYNC_MAX_HEIGHT, (Object)Float.valueOf(size));
        this.field_70180_af.func_187227_b(SYNC_MAX_WIDTH, (Object)Float.valueOf(size));
    }

    @Override
    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.field_70180_af.func_187227_b(SYNC_DAMAGE, (Object)Float.valueOf(damage));
    }

    public void setExplosionSize(float size) {
        this.field_70180_af.func_187227_b(SYNC_EXPLOSION_SIZE, (Object)Float.valueOf(size));
    }

    public void setExplosionStrength(float strength) {
        this.explosionStrength = strength;
    }

    public void setExplosionDamage(float damage) {
        this.explosionDamage = damage;
    }

    public void setRGB(int r, int g, int b) {
        this.field_70180_af.func_187227_b(SYNC_R, (Object)r);
        this.field_70180_af.func_187227_b(SYNC_G, (Object)g);
        this.field_70180_af.func_187227_b(SYNC_B, (Object)b);
    }

    public int[] getRGB() {
        int[] rgb = new int[]{(Integer)this.field_70180_af.func_187225_a(SYNC_R), (Integer)this.field_70180_af.func_187225_a(SYNC_G), (Integer)this.field_70180_af.func_187225_a(SYNC_B)};
        return rgb;
    }

    public void setRGB(int[] rgb) {
        this.field_70180_af.func_187227_b(SYNC_R, (Object)rgb[0]);
        this.field_70180_af.func_187227_b(SYNC_G, (Object)rgb[1]);
        this.field_70180_af.func_187227_b(SYNC_B, (Object)rgb[2]);
    }

    public void setFade(int fadeR, int fadeG, int fadeB) {
        this.field_70180_af.func_187227_b(SYNC_FADE_R, (Object)fadeR);
        this.field_70180_af.func_187227_b(SYNC_FADE_G, (Object)fadeG);
        this.field_70180_af.func_187227_b(SYNC_FADE_B, (Object)fadeB);
    }

    public int[] getFade() {
        int[] fade = new int[]{(Integer)this.field_70180_af.func_187225_a(SYNC_FADE_R), (Integer)this.field_70180_af.func_187225_a(SYNC_FADE_G), (Integer)this.field_70180_af.func_187225_a(SYNC_FADE_B)};
        return fade;
    }

    public void setFade(int[] fade) {
        this.field_70180_af.func_187227_b(SYNC_FADE_R, (Object)fade[0]);
        this.field_70180_af.func_187227_b(SYNC_FADE_G, (Object)fade[1]);
        this.field_70180_af.func_187227_b(SYNC_FADE_B, (Object)fade[2]);
    }

    public void setRedirectable(boolean redirectable) {
        this.field_70180_af.func_187227_b(SYNC_REDIRECTABLE, (Object)redirectable);
    }

    public boolean isRedirectable() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_REDIRECTABLE);
    }

    public void Explode() {
        this.Explode(this.field_70170_p, this, this.getOwner());
    }

    public void applyPiercingCollision() {
        this.applyPiercingCollision(this);
    }

    public void Dissipate() {
        this.Dissipate(this);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_DAMAGE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_LIFETIME, (Object)20);
        this.field_70180_af.func_187214_a(SYNC_WIDTH, (Object)Float.valueOf(0.1f));
        this.field_70180_af.func_187214_a(SYNC_HEIGHT, (Object)Float.valueOf(0.1f));
        this.field_70180_af.func_187214_a(SYNC_MAX_WIDTH, (Object)Float.valueOf(0.1f));
        this.field_70180_af.func_187214_a(SYNC_MAX_HEIGHT, (Object)Float.valueOf(0.1f));
        this.field_70180_af.func_187214_a(SYNC_BEHAVIOR, (Object)new OffensiveBehaviour.Idle());
        this.field_70180_af.func_187214_a(SYNC_PIERCES, (Object)false);
        this.field_70180_af.func_187214_a(SYNC_EXPLOSION_SIZE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_R, (Object)255);
        this.field_70180_af.func_187214_a(SYNC_G, (Object)255);
        this.field_70180_af.func_187214_a(SYNC_B, (Object)255);
        this.field_70180_af.func_187214_a(SYNC_FADE_R, (Object)255);
        this.field_70180_af.func_187214_a(SYNC_FADE_G, (Object)255);
        this.field_70180_af.func_187214_a(SYNC_FADE_B, (Object)255);
        this.field_70180_af.func_187214_a(SYNC_REDIRECTABLE, (Object)false);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setDamage(nbt.func_74760_g("Damage"));
        this.setLifeTime(nbt.func_74762_e("Lifetime"));
        this.setBehaviour((OffensiveBehaviour)Behavior.lookup(nbt.func_74762_e("Behaviour"), this));
        this.getBehaviour().load(nbt.func_74775_l("BehaviorData"));
        this.setDynamicSpreadingCollision(nbt.func_74767_n("Dynamic Collision"));
        this.setXp(nbt.func_74760_g("XP"));
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("Damage", this.getDamage());
        nbt.func_74768_a("Lifetime", this.getLifeTime());
        nbt.func_74768_a("Behaviour", this.getBehaviour().getId());
        this.getBehaviour().save(GoreCoreNBTUtil.nestedCompound(nbt, "BehaviorData"));
        nbt.func_74757_a("Dynamic Collision", this.getDynamicSpreadingCollision());
        nbt.func_74776_a("XP", this.getXpPerHit());
    }

    @Override
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return this.getExpandedHitbox();
    }

    @Override
    public void func_70071_h_() {
        BlockPos pos;
        double zPos;
        double yPos;
        double xPos;
        double y;
        double z;
        double x;
        super.func_70071_h_();
        if (this.getBehaviour() != null) {
            this.setBehaviour((OffensiveBehaviour)this.getBehaviour().onUpdate(this));
        } else {
            this.setBehaviour(new OffensiveBehaviour.Idle());
        }
        this.func_70105_a(this.getWidth(), this.getHeight());
        List targets = this.field_70170_p.func_72872_a(Entity.class, this.getExpandedHitbox());
        if (!targets.isEmpty()) {
            for (Entity hit : targets) {
                if (!this.canCollideWith(hit) || this == hit) continue;
                this.onCollideWithEntity(hit);
            }
        }
        if (this.field_70145_X) {
            IBlockState state = this.field_70170_p.func_180495_p(this.func_180425_c());
            if (this.onCollideWithSolid()) {
                ++this.ticks;
            }
            if (this.ticks > 0 || this.onCollideWithSolid()) {
                if (this.shouldDissipate()) {
                    this.Dissipate();
                } else if (this.shouldExplode()) {
                    this.Explode();
                }
            }
        }
        if (this.shouldDissipate() || this.shouldExplode()) {
            ++this.ticksMoving;
        }
        if (this.ticksMoving >= this.getLifeTime() && (this.shouldDissipate() || this.shouldExplode()) && this.getLifeTime() > 0) {
            if (this.shouldDissipate()) {
                this.Dissipate();
            } else if (this.shouldExplode()) {
                this.Explode();
            }
        }
        for (x = 0.0; x <= 1.0; x += 0.5) {
            for (z = 0.0; z <= 1.0; z += 0.5) {
                for (y = 0.0; y <= 1.0; y += 0.5) {
                    xPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72450_a;
                    yPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72448_b;
                    zPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72449_c;
                    pos = new BlockPos(xPos + x * this.getExpandedHitboxWidth() / 2.0, yPos + y * this.getExpandedHitboxHeight() / 2.0, zPos + z * this.getExpandedHitboxWidth() / 2.0);
                    this.pushLevers(pos);
                    this.pushTrapDoors(pos);
                    this.pushButtons(pos);
                    this.pushDoors(pos);
                    this.pushGates(pos);
                }
            }
        }
        for (x = 0.0; x >= -1.0; x -= 0.5) {
            for (z = 0.0; z >= -1.0; z -= 0.5) {
                for (y = 0.0; y >= -1.0; y -= 0.5) {
                    xPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72450_a;
                    yPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72448_b;
                    zPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72449_c;
                    pos = new BlockPos(xPos + x * this.getExpandedHitboxWidth() / 2.0, yPos + y * this.getExpandedHitboxHeight() / 2.0, zPos + z * this.getExpandedHitboxWidth() / 2.0);
                    this.pushLevers(pos);
                    this.pushTrapDoors(pos);
                    this.pushButtons(pos);
                    this.pushDoors(pos);
                    this.pushGates(pos);
                }
            }
        }
        if (this.dynamicSpreadingCollision) {
            if (this.field_70159_w == 0.0 && this.prevVelX != 0.0) {
                this.field_70181_x *= 0.4;
                this.field_70179_y *= 0.4;
                this.field_70181_x += (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * this.prevVelX * 0.1;
                this.field_70179_y += (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * this.prevVelX * 0.1;
                if (this.setsFires) {
                    this.setFires();
                }
            }
            if (this.field_70181_x == 0.0 && this.prevVelY != 0.0) {
                this.field_70159_w *= 0.4;
                this.field_70179_y *= 0.4;
                this.field_70159_w += (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * this.prevVelY * 0.1;
                this.field_70179_y += (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * this.prevVelY * 0.1;
                if (this.setsFires) {
                    this.setFires();
                }
            }
            if (this.field_70179_y == 0.0 && this.prevVelZ != 0.0) {
                this.field_70159_w *= 0.4;
                this.field_70181_x *= 0.4;
                this.field_70159_w += (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * this.prevVelZ * 0.1;
                this.field_70181_x += (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * this.prevVelZ * 0.1;
                if (this.setsFires) {
                    this.setFires();
                }
            }
            x = this.field_70159_w;
            double y2 = this.field_70181_x;
            double z2 = this.field_70179_y;
            double origX = x;
            double origY = y2;
            double origZ = z2;
            List list = this.field_70170_p.func_184144_a(null, this.func_174813_aQ().func_72321_a(x, y2, z2).func_186664_h(0.2));
            List entityList = this.field_70170_p.func_72872_a(Entity.class, this.func_174813_aQ().func_72321_a(x, y2, z2).func_186664_h(0.3));
            for (Entity hit : entityList) {
                if (hit == this.getOwner()) continue;
                if (this.solidEntities.test(hit)) {
                    this.collidedWithSolid = true;
                    continue;
                }
                if (!(hit instanceof EntityThrowable) && !(hit instanceof EntityArrow) && (!(hit instanceof EntityOffensive) || !this.canCollideWith(hit))) continue;
                Vec3d hitVel = new Vec3d(hit.field_70159_w, hit.field_70181_x, hit.field_70179_y);
                Vec3d pVel = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                if (AvatarUtils.getMagnitude(hitVel) >= AvatarUtils.getMagnitude(pVel)) {
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70159_w = 0.0;
                    continue;
                }
                this.field_70159_w += hit.field_70159_w;
                this.field_70181_x += hit.field_70181_x;
                this.field_70179_y += hit.field_70179_y;
            }
            if (!list.isEmpty() && !this.field_70122_E) {
                IBlockState state;
                BlockPos pos2;
                Vec3d mid;
                for (AxisAlignedBB axisalignedbb : list) {
                    mid = AvatarUtils.getMiddleVec3d(axisalignedbb);
                    pos2 = new BlockPos(mid.field_72450_a, mid.field_72448_b, mid.field_72449_c);
                    state = this.field_70170_p.func_180495_p(pos2);
                    if (this.field_70145_X && (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() instanceof BlockLiquid || !state.func_185913_b() || !state.func_185917_h() || this.pushDoor && state.func_177230_c() instanceof BlockDoor)) continue;
                    y2 = axisalignedbb.func_72323_b(this.func_174813_aQ(), y2);
                }
                if (y2 < this.field_70163_u && this.field_70122_E) {
                    if (this.setsFires) {
                        this.setFires();
                    }
                    if (this.shouldExplode()) {
                        this.Explode();
                    } else {
                        this.Dissipate();
                    }
                }
                this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, y2, 0.0));
                for (AxisAlignedBB axisalignedbb1 : list) {
                    mid = AvatarUtils.getMiddleVec3d(axisalignedbb1);
                    pos2 = new BlockPos(mid.field_72450_a, mid.field_72448_b, mid.field_72449_c);
                    state = this.field_70170_p.func_180495_p(pos2);
                    if (this.field_70145_X && (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() instanceof BlockLiquid || !state.func_185913_b() || !state.func_185917_h() || this.pushDoor && state.func_177230_c() instanceof BlockDoor)) continue;
                    x = axisalignedbb1.func_72316_a(this.func_174813_aQ(), x);
                }
                this.func_174826_a(this.func_174813_aQ().func_72317_d(x, 0.0, 0.0));
                for (AxisAlignedBB axisalignedbb2 : list) {
                    mid = AvatarUtils.getMiddleVec3d(axisalignedbb2);
                    pos2 = new BlockPos(mid.field_72450_a, mid.field_72448_b, mid.field_72449_c);
                    state = this.field_70170_p.func_180495_p(pos2);
                    if (this.field_70145_X && (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() instanceof BlockLiquid || !state.func_185913_b() || !state.func_185917_h() || this.pushDoor && state.func_177230_c() instanceof BlockDoor)) continue;
                    z2 = axisalignedbb2.func_72322_c(this.func_174813_aQ(), z2);
                }
                this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, z2));
            }
            if (this.collidedWithSolid) {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
                if (this.setsFires) {
                    this.setFires();
                }
            }
            if (origX != x) {
                this.field_70159_w = 0.0;
            }
            if (origY != y2) {
                this.field_70181_x = 0.0;
            }
            if (origZ != z2) {
                this.field_70179_y = 0.0;
            }
        }
        if (this.onCollideWithSolid()) {
            if (this.isProjectile() && this.shouldExplode()) {
                this.Explode();
            }
            if (this.isProjectile() && this.shouldDissipate()) {
                this.Dissipate();
            }
        }
        this.prevVelX = this.field_70159_w;
        this.prevVelY = this.field_70181_x;
        this.prevVelZ = this.field_70179_y;
    }

    @Override
    public EntityLivingBase getController() {
        return this.getOwner();
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        super.onCollideWithEntity(entity);
        if (!this.isPiercing() && this.isProjectile() && this.shouldExplode()) {
            this.Explode();
        } else if (!this.isPiercing() && this.shouldDissipate()) {
            this.attackEntity(this, entity, false, this.getKnockback());
            this.Dissipate();
        } else if (this.isShockwave()) {
            this.attackEntity(this, entity, false, this.getKnockback(entity));
        } else {
            this.applyPiercingCollision();
        }
        if (entity instanceof AvatarEntity) {
            this.applyElementalContact((AvatarEntity)entity);
        }
        if (this.getSolidEntities().test(entity)) {
            if (this.shouldExplode()) {
                this.Explode();
            } else {
                this.Dissipate();
            }
        }
    }

    @Override
    public Vec3d getKnockback() {
        double x = this.getKnockbackMult().field_72450_a * this.field_70159_w / 2.0;
        double y = Math.min(0.35, (this.field_70181_x + 0.05) * this.getKnockbackMult().field_72448_b);
        double z = this.getKnockbackMult().field_72449_c * this.field_70179_y / 2.0;
        return new Vec3d(x, y, z);
    }

    @Override
    public float getXpPerHit() {
        return this.xp;
    }

    @Override
    public boolean onCollideWithSolid() {
        IBlockState state;
        BlockPos pos;
        double zPos;
        double yPos;
        double xPos;
        double y;
        double z;
        double x;
        boolean collision = !this.field_70170_p.func_184144_a((Entity)this, this.getExpandedHitbox()).isEmpty();
        for (x = 0.0; x <= 1.0; x += 0.5) {
            block1: for (z = 0.0; z <= 1.0; z += 0.5) {
                for (y = 0.0; y <= 1.0; y += 0.5) {
                    xPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72450_a;
                    yPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72448_b;
                    zPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72449_c;
                    pos = new BlockPos(xPos + x * this.getExpandedHitboxWidth() / 2.0, yPos + y * this.getExpandedHitboxHeight() / 2.0, zPos + z * this.getExpandedHitboxWidth() / 2.0);
                    state = this.field_70170_p.func_180495_p(pos);
                    if (collision &= state.func_177230_c() != Blocks.field_150350_a && !(state.func_177230_c() instanceof BlockLiquid) && state.func_185913_b() && state.func_185917_h()) continue block1;
                }
            }
        }
        for (x = 0.0; x >= -1.0; x -= 0.5) {
            block4: for (z = 0.0; z >= -1.0; z -= 0.5) {
                for (y = 0.0; y >= -1.0; y -= 0.5) {
                    xPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72450_a;
                    yPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72448_b;
                    zPos = AvatarEntityUtils.getMiddleOfEntity((Entity)this).field_72449_c;
                    pos = new BlockPos(xPos + x * this.getExpandedHitboxWidth() / 2.0, yPos + y * this.getExpandedHitboxHeight() / 2.0, zPos + z * this.getExpandedHitboxWidth() / 2.0);
                    state = this.field_70170_p.func_180495_p(pos);
                    if (collision &= state.func_177230_c() != Blocks.field_150350_a && !(state.func_177230_c() instanceof BlockLiquid) && state.func_185913_b() && state.func_185917_h()) continue block4;
                }
            }
        }
        return this.field_70132_H || collision;
    }

    @Override
    protected void spawnExtinguishIndicators() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                ParticleBuilder.create(ParticleBuilder.Type.SNOW).pos(AvatarEntityUtils.getMiddleOfEntity(this)).scale(Math.min(Math.max(this.getAvgSize() * 2.0f, 0.125f), 1.0f)).vel(this.field_70170_p.field_73012_v.nextGaussian() / 20.0 + this.field_70159_w / 8.0, this.field_70170_p.field_73012_v.nextDouble() / 10.0 + this.field_70181_x / 8.0, this.field_70170_p.field_73012_v.nextGaussian() / 20.0 + this.field_70179_y / 8.0).time(AvatarUtils.getRandomNumberInRange(8, 16) * 2).spawn(this.field_70170_p);
            }
        }
    }

    public int getLifeTime() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_LIFETIME);
    }

    public void setLifeTime(int lifeTime) {
        this.field_70180_af.func_187227_b(SYNC_LIFETIME, (Object)lifeTime);
    }

    @Override
    public float getAoeDamage() {
        return this.explosionDamage;
    }

    @Override
    public Vec3d getKnockbackMult() {
        return new Vec3d((double)this.push, (double)(this.push / 2.0f), (double)this.push);
    }

    @Override
    public EnumParticleTypes getParticle() {
        return AvatarParticles.getParticleFlames();
    }

    @Override
    public int getNumberofParticles() {
        return 50;
    }

    @Override
    public double getParticleSpeed() {
        return 0.02;
    }

    @Override
    public int getPerformanceAmount() {
        return this.performanceAmount;
    }

    public void setPerformanceAmount(int amount) {
        this.performanceAmount = amount;
    }

    @Override
    public float getVolume() {
        return 1.0f + (float)AvatarUtils.getRandomNumberInRange(1, 100) / 500.0f;
    }

    @Override
    public float getPitch() {
        return 1.0f + (float)AvatarUtils.getRandomNumberInRange(1, 100) / 500.0f;
    }

    @Override
    public void setDamageSource(String source) {
        this.damageSource = source;
    }

    @Override
    public DamageSource getDamageSource(Entity source, EntityLivingBase owner) {
        DamageSource dmgSource = AvatarDamageSource.FIRE;
        if (this.damageSource.startsWith("avatar_")) {
            dmgSource = new EntityDamageSourceIndirect(this.damageSource, (Entity)this, (Entity)owner);
            if (this.isProjectile()) {
                dmgSource.func_76349_b();
            }
            dmgSource.func_82726_p();
            if (this.getElement() instanceof Lightningbending) {
                dmgSource.func_76348_h();
            }
            if (this.getElement() instanceof Combustionbending) {
                dmgSource.func_94540_d();
            }
        }
        return dmgSource;
    }

    @Override
    public double getExpandedHitboxWidth() {
        return 0.25;
    }

    @Override
    public double getExpandedHitboxHeight() {
        return 0.25;
    }

    @Override
    public int getFireTime() {
        return this.fireTime;
    }

    public void setFireTime(int time) {
        this.fireTime = time;
    }

    @Override
    public boolean isPiercing() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_PIERCES);
    }

    public void setPiercing(boolean pierces) {
        this.field_70180_af.func_187227_b(SYNC_PIERCES, (Object)pierces);
    }

    @Override
    public boolean shouldDissipate() {
        return false;
    }

    @Override
    public boolean shouldExplode() {
        return true;
    }

    public AxisAlignedBB getExpandedHitbox() {
        return this.getExpandedHitbox(this);
    }

    @Override
    public double getExplosionHitboxGrowth() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_EXPLOSION_SIZE)).floatValue();
    }

    @Override
    public void applyElementalContact(AvatarEntity entity) {
    }

    public void setXp(float xp) {
        this.xp = xp;
    }

    @Override
    public float getChiHit() {
        return this.chiHit;
    }

    public void setChiHit(float chi) {
        this.chiHit = chi;
    }

    @Override
    public boolean func_70104_M() {
        return !this.isPiercing();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    @Override
    public Vec3d getExplosionKnockbackMult() {
        return new Vec3d((double)this.explosionStrength, (double)this.explosionStrength, (double)this.explosionStrength);
    }

    @Override
    public Vec3d getKnockback(Entity target) {
        Vec3d knockback = Vector.getEntityPos(target).minus(Vector.getEntityPos(this)).normalize().toMinecraft();
        return new Vec3d(knockback.field_72450_a * this.getKnockbackMult().field_72450_a, knockback.field_72448_b * this.getKnockbackMult().field_72448_b, knockback.field_72449_c * this.getKnockbackMult().field_72449_c);
    }
}

