/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityRavine
extends EntityOffensive {
    private static final DataParameter<Boolean> SYNC_BREAK_BLOCKS = EntityDataManager.func_187226_a(EntityRavine.class, (DataSerializer)DataSerializers.field_187198_h);
    private Vector initialPosition;
    private double maxTravelDistanceSq;
    private boolean dropEquipment;

    public EntityRavine(World world) {
        super(world);
        this.func_70105_a(0.125f, 0.125f);
        this.field_70145_X = true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_BREAK_BLOCKS, (Object)false);
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    @Override
    public boolean func_70112_a(double distance) {
        return true;
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public double getExpandedHitboxWidth() {
        return 0.5;
    }

    @Override
    public double getExpandedHitboxHeight() {
        return 0.5;
    }

    public void setDistance(double dist) {
        this.maxTravelDistanceSq = dist * dist;
    }

    public void setBreakBlocks(boolean breakBlocks) {
        this.field_70180_af.func_187227_b(SYNC_BREAK_BLOCKS, (Object)breakBlocks);
    }

    public boolean shouldBreakBlocks() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_BREAK_BLOCKS);
    }

    public void setDropEquipment(boolean dropEquipment) {
        this.dropEquipment = dropEquipment;
    }

    public double getSqrDistanceTravelled() {
        return this.position().sqrDist(this.initialPosition);
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public Vec3d getKnockback() {
        return super.getKnockback();
    }

    @Override
    public Vec3d getKnockbackMult() {
        return new Vec3d(ConfigStats.STATS_CONFIG.ravineSettings.push, ConfigStats.STATS_CONFIG.ravineSettings.push * 2.0, ConfigStats.STATS_CONFIG.ravineSettings.push);
    }

    public void spawnEntity() {
        BlockPos pos;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_180495_p((pos = new BlockPos(this.field_70169_q, this.field_70167_r, this.field_70166_s)).func_177977_b()).func_185887_b(this.field_70170_p, pos.func_177977_b()) != -1.0f && !this.field_70170_p.func_175623_d(pos.func_177977_b()) && this.field_70170_p.func_175677_d(pos.func_177977_b(), false) && !this.field_70170_p.func_175677_d(pos, false)) {
            EntityFallingBlock fallingblock = new EntityFallingBlock(this.field_70170_p, this.field_70169_q, this.field_70167_r - 1.0, this.field_70166_s, this.field_70170_p.func_180495_p(new BlockPos(this.field_70169_q, this.field_70167_r - 1.0, this.field_70166_s)));
            fallingblock.field_70181_x = 0.2 + (double)(this.getAvgSize() / 10.0f);
            this.field_70170_p.func_72838_d((Entity)fallingblock);
        }
    }

    public void func_70030_z() {
        IBlockState inBlock;
        super.func_70030_z();
        if (this.initialPosition == null) {
            this.initialPosition = this.position();
        }
        if (!this.field_70170_p.field_72995_K && this.getSqrDistanceTravelled() > this.maxTravelDistanceSq) {
            this.Dissipate();
        }
        if (this.field_70173_aa >= this.getLifeTime()) {
            this.func_70106_y();
        }
        BlockPos below = this.func_180425_c().func_177972_a(EnumFacing.DOWN);
        Block belowBlock = this.field_70170_p.func_180495_p(below).func_177230_c();
        if (this.field_70173_aa % 3 == 0) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.func_180495_p(below).func_177230_c().func_185467_w().func_185845_c(), SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        }
        if (this.shouldBreakBlocks()) {
            BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.breakBlock(pos, 2);
        }
        if (!Earthbending.isBendable(this.field_70170_p, below, this.field_70170_p.func_180495_p(below), 2) && this.field_70170_p.func_72872_a(EntityFallingBlock.class, this.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0)).isEmpty()) {
            if (!Earthbending.isBendable(this.field_70170_p, below.func_177977_b(), this.field_70170_p.func_180495_p(below.func_177977_b()), 2)) {
                this.Dissipate();
            } else {
                this.setPosition(this.position().minusY(1.0));
            }
        }
        if (Earthbending.isBendable(this.field_70170_p, this.func_180425_c(), this.field_70170_p.func_180495_p(this.func_180425_c()), 2) && !this.shouldBreakBlocks()) {
            this.setPosition(this.position().plusY(1.0));
        }
        if (this.field_70170_p.field_72995_K && !(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c() instanceof BlockAir)) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + this.field_70170_p.field_73012_v.nextGaussian() * 0.5, this.field_70163_u + this.field_70170_p.field_73012_v.nextDouble() * 0.5, this.field_70161_v + this.field_70170_p.field_73012_v.nextGaussian() * 0.5, this.field_70170_p.field_73012_v.nextGaussian() * 0.75, this.field_70170_p.field_73012_v.nextGaussian() * 0.75, this.field_70170_p.field_73012_v.nextGaussian() * 0.75, new int[]{Block.func_176210_f((IBlockState)this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()))});
            }
        }
        if ((inBlock = this.field_70170_p.func_180495_p(this.func_180425_c())).func_177230_c() != Blocks.field_150350_a && !inBlock.func_185913_b()) {
            if (inBlock.func_185887_b(this.field_70170_p, this.func_180425_c()) == 0.0f) {
                if (inBlock.func_177230_c() instanceof BlockLiquid) {
                    this.Dissipate();
                }
                this.breakBlock(this.func_180425_c());
            } else if (!this.shouldBreakBlocks()) {
                this.Dissipate();
            }
        }
    }

    @Override
    public boolean isPiercing() {
        return true;
    }

    @Override
    public boolean shouldDissipate() {
        return true;
    }

    @Override
    public int getFireTime() {
        return 0;
    }

    @Override
    public void Dissipate() {
        if (this.onCollideWithSolid() || !Earthbending.isBendable(this.field_70170_p, this.func_180425_c().func_177977_b(), this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()), 2)) {
            if (this.field_70170_p.field_72995_K && this.field_70170_p.func_180495_p(this.func_180425_c()) != null) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.field_73012_v.nextGaussian() / 20.0, this.field_70170_p.field_73012_v.nextDouble() / 20.0, this.field_70170_p.field_73012_v.nextGaussian() / 20.0, new int[]{Block.func_176210_f((IBlockState)this.field_70170_p.func_180495_p(this.func_180425_c()))});
            }
            this.func_70106_y();
        }
    }

    @Override
    public void spawnExplosionParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnDissipateParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnPiercingParticles(World world, Vec3d pos) {
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        super.onCollideWithEntity(entity);
        if (this.canCollideWith(entity) && this.dropEquipment && entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                double chance;
                ItemStack stack = living.func_184582_a(slot);
                if (stack.func_190926_b()) continue;
                double d = chance = slot.func_188453_a() == EntityEquipmentSlot.Type.HAND ? 40.0 : 20.0;
                if (!(this.field_70146_Z.nextDouble() * 100.0 <= chance)) continue;
                living.func_70099_a(stack, 0.0f);
                living.func_184201_a(slot, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public boolean onCollideWithSolid() {
        IBlockState inBlock = this.field_70170_p.func_180495_p(this.func_180425_c());
        if (inBlock.func_185913_b() && Earthbending.isBendable(this.field_70170_p, this.func_180425_c(), inBlock, 2)) {
            inBlock = this.field_70170_p.func_180495_p(this.func_180425_c().func_177984_a());
            if ((inBlock.func_177230_c() == Blocks.field_150350_a || !inBlock.func_185915_l() && inBlock.func_185887_b(this.field_70170_p, this.func_180425_c().func_177984_a()) == 0.0f) && Earthbending.isBendable(this.field_70170_p, this.func_180425_c(), this.field_70170_p.func_180495_p(this.func_180425_c()), 2)) {
                this.setPosition(this.position().plusY(1.0));
                return false;
            }
            return !this.shouldBreakBlocks();
        }
        return false;
    }

    @Override
    public BendingStyle getElement() {
        return new Earthbending();
    }
}

