/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.Ability;
import com.crowsofwar.avatar.bending.bending.BattlePerformanceScore;
import com.crowsofwar.avatar.bending.bending.sand.Sandbending;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.data.SyncedEntity;
import com.crowsofwar.avatar.util.damageutils.AvatarDamageSource;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.google.common.base.Optional;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class EntitySandPrison
extends AvatarEntity {
    public static final DataParameter<Optional<UUID>> SYNC_IMPRISONED = EntityDataManager.func_187226_a(EntitySandPrison.class, (DataSerializer)DataSerializers.field_187203_m);
    public static final DataParameter<Integer> SYNC_IMPRISONED_TIME = EntityDataManager.func_187226_a(EntitySandPrison.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> SYNC_MAX_IMPRISONED_TIME = EntityDataManager.func_187226_a(EntitySandPrison.class, (DataSerializer)DataSerializers.field_187192_b);
    private double normalBaseValue;
    private final SyncedEntity<EntityLivingBase> imprisonedAttr = new SyncedEntity(this, SYNC_IMPRISONED);
    private boolean damageEntity;
    private boolean applySlowness;
    private boolean vulnerableToAirbending;

    public EntitySandPrison(World world) {
        super(world);
        this.func_70105_a(1.0f, 0.25f);
        this.vulnerableToAirbending = true;
    }

    public static boolean isImprisoned(EntityLivingBase entity) {
        return EntitySandPrison.getPrison(entity) != null;
    }

    public static EntitySandPrison getPrison(EntityLivingBase entity) {
        World world = entity.field_70170_p;
        List prisons = world.func_175644_a(EntitySandPrison.class, prison -> prison.getImprisoned() == entity);
        return prisons.isEmpty() ? null : (EntitySandPrison)((Object)prisons.get(0));
    }

    public static void imprison(EntityLivingBase entity, EntityLivingBase owner, Ability ab) {
        World world = entity.field_70170_p;
        EntitySandPrison prison = new EntitySandPrison(world);
        prison.setImprisoned(entity);
        prison.func_82149_j((Entity)entity);
        prison.setAbility(ab);
        double powerRating = Bender.get(owner).calcPowerRating(Sandbending.ID);
        prison.setStats(AbilityData.get(owner, "sand_prison"), powerRating);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)prison);
        }
        BattlePerformanceScore.addLargeScore(owner);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_IMPRISONED, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SYNC_IMPRISONED_TIME, (Object)100);
        this.field_70180_af.func_187214_a(SYNC_MAX_IMPRISONED_TIME, (Object)100);
    }

    public EntityLivingBase getImprisoned() {
        return this.imprisonedAttr.getEntity();
    }

    public void setImprisoned(EntityLivingBase entity) {
        this.imprisonedAttr.setEntity(entity);
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return false;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        EntityLivingBase imprisoned = this.getImprisoned();
        if (imprisoned != null) {
            IAttributeInstance speed = imprisoned.func_110148_a(SharedMonsterAttributes.field_111263_d);
            if (speed.func_111125_b() != 0.0) {
                this.normalBaseValue = speed.func_111125_b();
                speed.func_111128_a(0.0);
            }
            imprisoned.field_70159_w *= 0.0;
            imprisoned.field_70181_x *= 0.0;
            imprisoned.field_70179_y *= 0.0;
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            imprisoned.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setImprisonedTime(this.getImprisonedTime() - 1);
        }
        if (this.getImprisonedTime() <= 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K && imprisoned != null) {
                this.field_70170_p.func_184133_a(null, imprisoned.func_180425_c(), SoundEvents.field_187747_eB, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (this.damageEntity) {
                    DamageSource ds = AvatarDamageSource.causeSandPrisonDamage((Entity)imprisoned, (Entity)this.getOwner());
                    imprisoned.func_70097_a(ds, 8.0f);
                }
                if (this.applySlowness) {
                    Potion slowness = Potion.func_180142_b((String)"slowness");
                    imprisoned.func_70690_d(new PotionEffect(slowness, 80, 1));
                }
            }
        }
    }

    @Override
    public boolean onAirContact() {
        if (!this.field_70170_p.field_72995_K && this.vulnerableToAirbending) {
            this.func_70106_y();
            return true;
        }
        return false;
    }

    public void func_70106_y() {
        super.func_70106_y();
        EntityLivingBase imprisoned = this.getImprisoned();
        if (imprisoned != null) {
            IAttributeInstance speed = imprisoned.func_110148_a(SharedMonsterAttributes.field_111263_d);
            speed.func_111128_a(this.normalBaseValue);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.imprisonedAttr.readFromNbt(nbt);
        this.normalBaseValue = nbt.func_74769_h("NormalSpeed");
        this.setImprisonedTime(nbt.func_74762_e("ImprisonedTime"));
        this.setMaxImprisonedTime(nbt.func_74762_e("MaxImprisonedTime"));
        this.setVulnerableToAirbending(nbt.func_74767_n("VulnerableToAirbending"));
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.imprisonedAttr.writeToNbt(nbt);
        nbt.func_74780_a("NormalSpeed", this.normalBaseValue);
        nbt.func_74768_a("ImprisonedTime", this.getImprisonedTime());
        nbt.func_74768_a("MaxImprisonedTime", this.getMaxImprisonedTime());
        nbt.func_74757_a("VulnerableToAirbending", this.isVulnerableToAirbending());
    }

    public int getImprisonedTime() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_IMPRISONED_TIME);
    }

    public void setImprisonedTime(int imprisonedTime) {
        this.field_70180_af.func_187227_b(SYNC_IMPRISONED_TIME, (Object)imprisonedTime);
    }

    public int getMaxImprisonedTime() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_MAX_IMPRISONED_TIME);
    }

    public void setMaxImprisonedTime(int maxImprisonedTime) {
        this.field_70180_af.func_187227_b(SYNC_MAX_IMPRISONED_TIME, (Object)maxImprisonedTime);
    }

    public boolean isDamageEntity() {
        return this.damageEntity;
    }

    public void setDamageEntity(boolean damageEntity) {
        this.damageEntity = damageEntity;
    }

    public boolean isApplySlowness() {
        return this.applySlowness;
    }

    public void setApplySlowness(boolean applySlowness) {
        this.applySlowness = applySlowness;
    }

    public boolean isVulnerableToAirbending() {
        return this.vulnerableToAirbending;
    }

    public void setVulnerableToAirbending(boolean vulnerableToAirbending) {
        this.vulnerableToAirbending = vulnerableToAirbending;
    }

    private void setStats(AbilityData abilityData, double powerRating) {
        float imprisonedSeconds = abilityData.getLevel() >= 1 ? 5.0f : 4.0f;
        this.damageEntity = false;
        this.applySlowness = abilityData.getLevel() >= 2;
        this.vulnerableToAirbending = true;
        if (abilityData.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
            this.damageEntity = true;
            imprisonedSeconds = 6.0f;
        }
        if (abilityData.isMasterPath(AbilityData.AbilityTreePath.SECOND)) {
            imprisonedSeconds = 12.0f;
            this.vulnerableToAirbending = false;
        }
        imprisonedSeconds = (float)((double)imprisonedSeconds + powerRating / 50.0);
        this.setImprisonedTime((int)(imprisonedSeconds * 20.0f));
        this.setMaxImprisonedTime((int)(imprisonedSeconds * 20.0f));
    }

    @Override
    public boolean canPush() {
        return false;
    }
}

