/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.sand.Sandbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.config.ConfigClient;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.SandstormMovementHandler;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.gorecore.util.Vector;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySandstorm
extends EntityOffensive {
    private static final DataParameter<Float> SYNC_VELOCITY_MULT = EntityDataManager.func_187226_a(EntitySandstorm.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_STRENGTH = EntityDataManager.func_187226_a(EntitySandstorm.class, (DataSerializer)DataSerializers.field_187193_c);
    private final SandstormMovementHandler movementHandler;
    private boolean damageFlungTargets;
    private boolean damageContactingTargets;
    private boolean vulnerableToAirbending;
    @SideOnly(value=Side.CLIENT)
    private float animationProgress;
    @SideOnly(value=Side.CLIENT)
    private float lastRenderAge;

    public EntitySandstorm(World world) {
        super(world);
        this.func_70105_a(2.2f, 5.2f);
        this.movementHandler = new SandstormMovementHandler(this);
        this.vulnerableToAirbending = true;
        this.field_70138_W = 1.0f;
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.removeStatCtrl();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_VELOCITY_MULT, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_STRENGTH, (Object)Float.valueOf(1.0f));
    }

    @Override
    public double getExpandedHitboxHeight() {
        return super.getExpandedHitboxHeight();
    }

    @Override
    public void func_70071_h_() {
        this.field_70122_E = true;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.movementHandler.update();
        }
        if (!this.field_70170_p.field_72995_K && this.isGroundGap()) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v);
        }
        if (!this.field_70170_p.field_72995_K) {
            Block groundBlock;
            IBlockState groundBlockState = this.getGroundBlock();
            Block block = groundBlock = groundBlockState == null ? null : groundBlockState.func_177230_c();
            if (ConfigStats.STATS_CONFIG.sandBlocks.contains(groundBlock)) {
                this.setStrength(this.getStrength() - 0.005f);
                this.setVelocityMultiplier(this.getVelocityMultiplier() - 0.0025f);
            } else {
                this.setStrength(this.getStrength() - 0.025f);
                this.setVelocityMultiplier(this.getVelocityMultiplier() - 0.025f);
            }
            if (this.getStrength() == 0.0f) {
                this.func_70106_y();
            }
        }
        ArrayList<Vec3d> tornadoPoints = new ArrayList<Vec3d>();
        ArrayList<Vec3d> tornadoVelocity = new ArrayList<Vec3d>();
        if (this.field_70170_p.field_72995_K && this.getOwner() != null) {
            int maxAngle = 360 * Math.max((int)this.getHeight(), 1);
            for (int angle = 0; angle < maxAngle; angle += 10 * Math.max((int)this.getHeight(), 1)) {
                double radAngle = Math.toRadians(angle);
                double radius = 0.01 + (double)((float)angle / ((float)maxAngle / this.getWidth()));
                double x = radius * Math.cos(radAngle);
                double y = (double)angle / ((double)maxAngle / (this.getExpandedHitboxHeight() + (double)this.getHeight()));
                double z = radius * Math.sin(radAngle);
                double speed = this.field_70170_p.field_73012_v.nextDouble() * 2.0 + 1.0;
                double omega = Math.signum(speed * (0.3141592653589793 - speed / (20.0 * radius)));
                Vec3d centre = AvatarEntityUtils.getBottomMiddleOfEntity(this);
                tornadoPoints.add(new Vec3d(x + centre.field_72450_a + this.field_70170_p.field_73012_v.nextGaussian() / 5.0, y + centre.field_72448_b, z + centre.field_72449_c + this.field_70170_p.field_73012_v.nextGaussian() / 5.0));
                tornadoVelocity.add(new Vec3d(x * omega * 0.05, ((double)maxAngle / (this.getExpandedHitboxHeight() + (double)this.getHeight()) - y) / 1250.0, z * omega * (double)0.05f));
            }
            for (int i = 0; i < tornadoPoints.size() - 1; ++i) {
                Vec3d vel = (Vec3d)tornadoVelocity.get(i);
                Vec3d pos = (Vec3d)tornadoPoints.get(i);
                Vec3d pos2 = (Vec3d)tornadoPoints.get(i + 1);
                Vec3d pos3 = null;
                if (i < tornadoPoints.size() - 2) {
                    pos3 = (Vec3d)tornadoPoints.get(i + 2);
                }
                Vec3d[] points = new Vec3d[pos3 == null ? 2 : 3];
                points[0] = pos;
                points[1] = pos2;
                if (pos3 != null) {
                    points[2] = pos3;
                }
                for (int h = 0; h < 360; h += 90) {
                    Vec3d middle = AvatarEntityUtils.getBottomMiddleOfEntity(this);
                    pos = pos.func_178787_e(AvatarUtils.bezierCurve((float)h / 360.0f, points));
                    double radius = pos.field_72450_a - middle.field_72450_a;
                    ParticleBuilder particleBuilder = ParticleBuilder.create(ParticleBuilder.Type.FLASH).pos(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c).clr(220, 180, 130, 25).vel(vel.field_72450_a + this.field_70170_p.field_73012_v.nextGaussian() / 60.0 + this.field_70159_w, vel.field_72448_b + this.field_70181_x, vel.field_72449_c + this.field_70170_p.field_73012_v.nextGaussian() / 60.0 + this.field_70179_y).element(new Sandbending()).spin(Math.abs(radius) / 2.0, this.field_70170_p.field_73012_v.nextGaussian() * 0.125).spawnEntity((Entity)this.getOwner()).time(10 + AvatarUtils.getRandomNumberInRange(0, 4));
                    ConfigClient.CLIENT_CONFIG.particleSettings.getClass();
                    particleBuilder.scale(0.25f * this.getWidth() * 2.0f).spawn(this.field_70170_p);
                }
            }
        }
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    private boolean isGroundGap() {
        BlockPos pos = this.func_180425_c();
        BlockPos belowPos = pos.func_177977_b();
        IBlockState belowBlock = this.field_70170_p.func_180495_p(belowPos);
        boolean liquid = belowBlock.func_177230_c() instanceof BlockLiquid;
        if (belowBlock.func_185890_d((IBlockAccess)this.field_70170_p, belowPos) == null && !liquid) {
            for (int i = 0; i < 3; ++i) {
                BlockPos moreDown = pos.func_177979_c(i + 2);
                if (!this.field_70170_p.isSideSolid(moreDown, EnumFacing.UP)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private IBlockState getGroundBlock() {
        BlockPos pos = this.func_180425_c();
        for (int i = 1; i <= 3; ++i) {
            BlockPos belowPos = pos.func_177979_c(i);
            IBlockState belowBlock = this.field_70170_p.func_180495_p(belowPos);
            boolean liquid = belowBlock.func_177230_c() instanceof BlockLiquid;
            if (!this.field_70170_p.isSideSolid(belowPos, EnumFacing.UP) && !liquid) continue;
            return this.field_70170_p.func_180495_p(belowPos);
        }
        return null;
    }

    @Override
    public boolean canPush() {
        return this.vulnerableToAirbending;
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        double floatingDistance = (double)this.getWidth() + this.getExpandedHitboxHeight();
        double maxPickupRange = this.velocity().magnitude() * 0.75 + (double)(this.getWidth() / 2.0f);
        if (entity == this.getOwner()) {
            return;
        }
        double currentAngle = Vector.getRotationTo(this.position(), Vector.getEntityPos(entity)).y();
        double nextAngle = currentAngle + Math.toRadians(18.0);
        double currentDistance = entity.func_70011_f(this.field_70165_t, this.field_70163_u + floatingDistance, this.field_70161_v);
        double nextDistance = currentDistance + 0.01;
        if (nextDistance < this.velocity().magnitude() / 4.0 + (double)(this.getWidth() / 2.0f)) {
            nextDistance = this.velocity().magnitude() / 4.0 + (double)(this.getWidth() / 2.0f);
        }
        if (nextDistance > this.velocity().magnitude() * 0.675 + (double)(this.getWidth() / 4.0f)) {
            nextDistance = this.velocity().magnitude() / 4.0 + (double)(this.getWidth() / 2.0f);
            this.onPickupEntity();
        } else if (nextDistance > maxPickupRange || AvatarUtils.getRandomNumberInRange(1, 100) < 6) {
            nextDistance = this.velocity().magnitude() / 4.0;
            nextAngle = Vector.getRotationTo(Vector.ZERO, this.velocity()).y();
            this.onFlingEntity(entity);
        }
        Vector nextPos = this.position().plus(Vector.toRectangular(nextAngle, 0.0).times(nextDistance / 4.0)).plusY(floatingDistance);
        Vector delta = nextPos.minus(Vector.getEntityPos(entity));
        Vector nextVelocity = this.velocity().plus(delta.times(this.getPush()));
        entity.field_70159_w = nextVelocity.x() / 20.0;
        entity.field_70181_x = Math.min(nextVelocity.y() / 20.0, floatingDistance / 20.0);
        entity.field_70179_y = nextVelocity.z() / 20.0;
        AvatarUtils.afterVelocityAdded(entity);
        this.onContact(entity);
    }

    public SandstormMovementHandler getMovementHandler() {
        return this.movementHandler;
    }

    private void onPickupEntity() {
    }

    @Override
    public float getAoeDamage() {
        return this.getDamage() / 5.0f;
    }

    @Override
    public int getFireTime() {
        return 0;
    }

    private void onFlingEntity(Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.damageFlungTargets && this.canDamageEntity(entity)) {
            this.attackEntity(this, entity, false, Vec3d.field_186680_a);
        }
    }

    private void onContact(Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.damageContactingTargets) {
            this.attackEntity(this, entity, true, Vec3d.field_186680_a);
        }
    }

    @Override
    public boolean onAirContact() {
        if (this.vulnerableToAirbending) {
            this.func_70106_y();
            return true;
        }
        return false;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public boolean isDamageFlungTargets() {
        return this.damageFlungTargets;
    }

    public void setDamageFlungTargets(boolean damageFlungTargets) {
        this.damageFlungTargets = damageFlungTargets;
    }

    public boolean isDamageContactingTargets() {
        return this.damageContactingTargets;
    }

    public void setDamageContactingTargets(boolean damageContactingTargets) {
        this.damageContactingTargets = damageContactingTargets;
    }

    public boolean isVulnerableToAirbending() {
        return this.vulnerableToAirbending;
    }

    public void setVulnerableToAirbending(boolean vulnerableToAirbending) {
        this.vulnerableToAirbending = vulnerableToAirbending;
    }

    public float getVelocityMultiplier() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_VELOCITY_MULT)).floatValue();
    }

    public void setVelocityMultiplier(float velocityMultiplier) {
        this.field_70180_af.func_187227_b(SYNC_VELOCITY_MULT, (Object)Float.valueOf(velocityMultiplier));
    }

    public float getStrength() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_STRENGTH)).floatValue();
    }

    public void setStrength(float strength) {
        this.field_70180_af.func_187227_b(SYNC_STRENGTH, (Object)Float.valueOf(MathHelper.func_76131_a((float)strength, (float)0.0f, (float)1.0f)));
    }

    @Override
    public boolean shouldDissipate() {
        return true;
    }

    @Override
    public boolean shouldExplode() {
        return false;
    }

    @Override
    public boolean isPiercing() {
        return true;
    }

    @Override
    public void playExplosionSounds(Entity entity) {
    }

    @Override
    public void playPiercingSounds(Entity entity) {
    }

    @Override
    public void playDissipateSounds(Entity entity) {
    }

    @Override
    public void spawnExplosionParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnDissipateParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnPiercingParticles(World world, Vec3d pos) {
    }

    @SideOnly(value=Side.CLIENT)
    public float getAnimationProgress() {
        return this.animationProgress;
    }

    @SideOnly(value=Side.CLIENT)
    public void setAnimationProgress(float animationProgress) {
        this.animationProgress = animationProgress;
    }

    @SideOnly(value=Side.CLIENT)
    public float getLastRenderAge() {
        return this.lastRenderAge;
    }

    @SideOnly(value=Side.CLIENT)
    public void setLastRenderAge(float lastRenderAge) {
        this.lastRenderAge = lastRenderAge;
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setDamageFlungTargets(nbt.func_74767_n("DamageFlungTargets"));
        this.setDamageContactingTargets(nbt.func_74767_n("DamageContactingTargets"));
        this.setVulnerableToAirbending(nbt.func_74767_n("VulnerableToAirbending"));
        this.setVelocityMultiplier(nbt.func_74760_g("VelocityMultiplier"));
        this.setStrength(nbt.func_74760_g("Strength"));
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("DamageFlungTargets", this.isDamageFlungTargets());
        nbt.func_74757_a("DamageContactingTargets", this.isDamageContactingTargets());
        nbt.func_74757_a("VulnerableToAirbending", this.isVulnerableToAirbending());
        nbt.func_74776_a("VelocityMultiplier", this.getVelocityMultiplier());
        nbt.func_74776_a("Strength", this.getStrength());
    }

    private void removeStatCtrl() {
        BendingData bD;
        if (this.getOwner() != null && (bD = BendingData.get(this.getOwner())).hasStatusControl(StatusControlController.SANDSTORM_REDIRECT)) {
            bD.removeStatusControl(StatusControlController.SANDSTORM_REDIRECT);
        }
    }
}

