/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.ICustomHitbox;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.gorecore.util.Vector;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class EntityShield
extends AvatarEntity
implements ICustomHitbox {
    public static final DataParameter<Float> SYNC_HEALTH = EntityDataManager.func_187226_a(EntityShield.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> SYNC_MAX_HEALTH = EntityDataManager.func_187226_a(EntityShield.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> SYNC_SIZE = EntityDataManager.func_187226_a(EntityShield.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final List<String> UNPROTECTED_DAMAGE = Arrays.asList("fall", "poison", "wither", "outOfWorld", "starve", "drown");

    public EntityShield(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_HEALTH, (Object)Float.valueOf(20.0f));
        this.field_70180_af.func_187214_a(SYNC_MAX_HEALTH, (Object)Float.valueOf(20.0f));
        this.field_70180_af.func_187214_a(SYNC_SIZE, (Object)Float.valueOf(2.0f));
        this.putsOutFires = true;
    }

    public boolean contains(AxisAlignedBB box) {
        return Arrays.stream(AvatarEntityUtils.getVertices(box)).allMatch(this::contains);
    }

    public boolean contains(Entity entity) {
        return this.contains(entity.func_174813_aQ());
    }

    @Override
    public Vec3d calculateIntercept(Vec3d origin, Vec3d endpoint, float fuzziness) {
        double rsquared;
        double t;
        Vec3d line = endpoint.func_178788_d(origin);
        Vec3d closestPoint = origin.func_178787_e(line.func_186678_a(t = -origin.func_178788_d(this.func_174791_d()).func_72430_b(line) / line.func_189985_c()));
        double dsquared = closestPoint.func_72436_e(this.func_174791_d());
        if (dsquared > (rsquared = Math.pow(this.getSize() + fuzziness, 2.0))) {
            return null;
        }
        return closestPoint.func_178788_d(line.func_72432_b().func_186678_a((double)MathHelper.func_76133_a((double)(rsquared - dsquared))));
    }

    @Override
    public boolean contains(Vec3d point) {
        return point.func_72438_d(AvatarEntityUtils.getMiddleOfEntity(this)) <= (double)this.getSize();
    }

    @Override
    public EntityLivingBase getController() {
        return this.getOwner();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getOwner() != null) {
            this.setPosition(AvatarEntityUtils.getBottomMiddleOfEntity((Entity)this.getOwner()));
        }
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        EntityLivingBase owner = this.getOwner();
        if (owner == null) {
            this.func_70106_y();
            return;
        }
        if (owner.func_70027_ad()) {
            owner.func_70066_B();
        }
        this.func_70105_a(this.getSize(), this.getSize());
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setHealth(nbt.func_74760_g("Health"));
        this.setMaxHealth(nbt.func_74760_g("MaxHealth"));
        if (this.getOwner() != null) {
            this.setPosition(Vector.getEntityPos((Entity)this.getOwner()));
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("Health", this.getHealth());
        nbt.func_74776_a("MaxHealth", this.getMaxHealth());
    }

    public void func_70634_a(double x, double y, double z) {
        if (this.getOwner() != null) {
            Vec3d pos = AvatarEntityUtils.getBottomMiddleOfEntity((Entity)this.getOwner());
            x = pos.field_72450_a;
            y = pos.field_72448_b;
            z = pos.field_72449_c;
            super.func_70634_a(x, y, z);
        } else {
            super.func_70634_a(x, y, z);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        EntityLivingBase owner = this.getOwner();
        if (owner != null) {
            Bender bender;
            if (!this.field_70170_p.field_72995_K && !UNPROTECTED_DAMAGE.contains(source.func_76355_l()) && !owner.func_180431_b(source) && Bender.isBenderSupported(owner) && (bender = Bender.get(owner)) != null) {
                BendingData data = bender.getData();
                if (bender.consumeChi(this.getChiDamageCost() * amount)) {
                    AbilityData aData = data.getAbilityData(this.getAbilityName());
                    aData.addXp(this.getProtectionXp());
                    aData.addBurnout(this.getAbility().getBurnOut(aData));
                    this.setHealth(this.getHealth() - amount);
                }
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    protected abstract float getChiDamageCost();

    protected abstract float getProtectionXp();

    protected abstract String getAbilityName();

    protected abstract void onDeath();

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_SIZE)).floatValue();
    }

    public void setSize(float size) {
        this.field_70180_af.func_187227_b(SYNC_SIZE, (Object)Float.valueOf(size));
    }

    @Override
    public boolean isShield() {
        return true;
    }

    public float getHealth() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_HEALTH)).floatValue();
    }

    public void setHealth(float health) {
        if (health <= 0.0f && this.getMaxHealth() > 0.0f) {
            this.onDeath();
        }
        if (health > this.getMaxHealth()) {
            health = this.getMaxHealth();
        }
        this.field_70180_af.func_187227_b(SYNC_HEALTH, (Object)Float.valueOf(health));
    }

    public float getMaxHealth() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_MAX_HEALTH)).floatValue();
    }

    public void setMaxHealth(float health) {
        this.field_70180_af.func_187227_b(SYNC_MAX_HEALTH, (Object)Float.valueOf(health));
    }
}

