/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.air.Airbending;
import com.crowsofwar.avatar.client.particle.AvatarParticles;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.ShockwaveBehaviour;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityShockwave
extends EntityOffensive {
    private static final DataParameter<ShockwaveBehaviour> SYNC_BEHAVIOR = EntityDataManager.func_187226_a(EntityShockwave.class, ShockwaveBehaviour.DATA_SERIALIZER);
    private static final DataParameter<String> SYNC_PARTICLE = EntityDataManager.func_187226_a(EntityShockwave.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Float> SYNC_PARTICLE_SPEED = EntityDataManager.func_187226_a(EntityShockwave.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> SYNC_PARTICLE_AMOUNT = EntityDataManager.func_187226_a(EntityShockwave.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SYNC_PARTICLE_WAVES = EntityDataManager.func_187226_a(EntityShockwave.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SYNC_PARTICLE_CONTROLLER = EntityDataManager.func_187226_a(EntityShockwave.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_SPEED = EntityDataManager.func_187226_a(EntityShockwave.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> SYNC_IS_SPHERE = EntityDataManager.func_187226_a(EntityShockwave.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> SYNC_RANGE = EntityDataManager.func_187226_a(EntityShockwave.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> SYNC_RENDER_NORMAL = EntityDataManager.func_187226_a(EntityShockwave.class, (DataSerializer)DataSerializers.field_187198_h);
    public float damage = 1.0f;
    private int performanceAmount = 10;
    private double knockbackHeight = 0.0;
    private int fireTime;
    private Vec3d knockbackMult = new Vec3d(1.0, 2.0, 1.0);

    public EntityShockwave(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_PARTICLE, (Object)"cloud");
        this.field_70180_af.func_187214_a(SYNC_PARTICLE_SPEED, (Object)Float.valueOf(0.1f));
        this.field_70180_af.func_187214_a(SYNC_PARTICLE_AMOUNT, (Object)1);
        this.field_70180_af.func_187214_a(SYNC_PARTICLE_WAVES, (Object)1);
        this.field_70180_af.func_187214_a(SYNC_PARTICLE_CONTROLLER, (Object)Float.valueOf(40.0f));
        this.field_70180_af.func_187214_a(SYNC_SPEED, (Object)Float.valueOf(0.8f));
        this.field_70180_af.func_187214_a(SYNC_IS_SPHERE, (Object)false);
        this.field_70180_af.func_187214_a(SYNC_RANGE, (Object)Float.valueOf(4.0f));
        this.field_70180_af.func_187214_a(SYNC_RENDER_NORMAL, (Object)true);
    }

    public float getParticleController() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_PARTICLE_CONTROLLER)).floatValue();
    }

    public void setParticleController(float amount) {
        this.field_70180_af.func_187227_b(SYNC_PARTICLE_CONTROLLER, (Object)Float.valueOf(amount));
    }

    @Override
    public EnumParticleTypes getParticle() {
        return EnumParticleTypes.func_186831_a((String)((String)this.field_70180_af.func_187225_a(SYNC_PARTICLE))) != null ? EnumParticleTypes.func_186831_a((String)((String)this.field_70180_af.func_187225_a(SYNC_PARTICLE))) : AvatarParticles.getParticleFromName((String)this.field_70180_af.func_187225_a(SYNC_PARTICLE));
    }

    public void setParticle(EnumParticleTypes particle) {
        this.field_70180_af.func_187227_b(SYNC_PARTICLE, (Object)particle.func_179346_b());
    }

    public int getParticleWaves() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_PARTICLE_WAVES);
    }

    public void setParticleWaves(int waves) {
        this.field_70180_af.func_187227_b(SYNC_PARTICLE_WAVES, (Object)waves);
    }

    public int getParticleAmount() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_PARTICLE_AMOUNT);
    }

    public void setParticleAmount(int amount) {
        this.field_70180_af.func_187227_b(SYNC_PARTICLE_AMOUNT, (Object)amount);
    }

    @Override
    public double getParticleSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_PARTICLE_SPEED)).floatValue();
    }

    public void setParticleSpeed(float speed) {
        this.field_70180_af.func_187227_b(SYNC_PARTICLE_SPEED, (Object)Float.valueOf(speed));
    }

    public double getRange() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_RANGE)).floatValue();
    }

    public void setRange(float range) {
        this.field_70180_af.func_187227_b(SYNC_RANGE, (Object)Float.valueOf(range));
    }

    public double getSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_SPEED)).floatValue();
    }

    public void setSpeed(float speed) {
        this.field_70180_af.func_187227_b(SYNC_SPEED, (Object)Float.valueOf(speed));
    }

    public double getKnockbackHeight() {
        return this.knockbackHeight;
    }

    public void setKnockbackHeight(double height) {
        this.knockbackHeight = height;
    }

    public boolean getSphere() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_IS_SPHERE);
    }

    public void setSphere(boolean sphere) {
        this.field_70180_af.func_187227_b(SYNC_IS_SPHERE, (Object)sphere);
    }

    public void setRenderNormal(boolean normal) {
        this.field_70180_af.func_187227_b(SYNC_RENDER_NORMAL, (Object)normal);
    }

    public boolean shouldRenderNormal() {
        return (Boolean)this.field_70180_af.func_187225_a(SYNC_RENDER_NORMAL);
    }

    @Override
    public boolean func_70067_L() {
        return false;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        EnumParticleTypes particle;
        super.func_70071_h_();
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        if ((double)this.field_70173_aa * this.getSpeed() * 0.5 > this.getRange()) {
            this.func_70106_y();
        }
        if (this.field_70173_aa > 140) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && this.getOwner() != null && this.shouldRenderNormal() && this.getParticle() != null && (particle = this.getParticle()) != null && this.field_70173_aa <= this.getParticleWaves()) {
            if (!this.getSphere()) {
                for (double angle = 0.0; angle < Math.PI * 2; angle += Math.PI / (this.getRange() * (double)this.getParticleAmount() * (double)this.field_70173_aa)) {
                    double x2 = this.field_70165_t + (double)this.field_70173_aa * this.getSpeed() * Math.sin(angle);
                    double y2 = this.field_70163_u;
                    double z2 = this.field_70161_v + (double)this.field_70173_aa * this.getSpeed() * Math.cos(angle);
                    Vector speed = new Vector((double)this.field_70173_aa * this.getSpeed() * Math.sin(angle) * (this.getParticleSpeed() * 10.0), this.getParticleSpeed() / 2.0, (double)this.field_70173_aa * this.getSpeed() * Math.cos(angle) * (this.getParticleSpeed() * 10.0));
                    this.field_70170_p.func_175688_a(particle, x2, y2, z2, speed.x(), speed.y(), speed.z(), new int[0]);
                }
            }
            if (this.field_70173_aa <= this.getParticleAmount() && this.getSphere()) {
                for (double theta = 0.0; theta <= 180.0; theta += 1.0) {
                    double dphi = (double)(this.getParticleController() - (float)this.getParticleAmount()) / Math.sin(Math.toRadians(theta));
                    for (double phi = 0.0; phi < 360.0; phi += dphi) {
                        double rphi = Math.toRadians(phi);
                        double rtheta = Math.toRadians(theta);
                        double x1 = (double)this.field_70173_aa * this.getSpeed() * Math.cos(rphi) * Math.sin(rtheta);
                        double y1 = (double)this.field_70173_aa * this.getSpeed() * Math.sin(rphi) * Math.sin(rtheta);
                        double z1 = (double)this.field_70173_aa * this.getSpeed() * Math.cos(rtheta);
                        double xVel = x1 * this.getParticleSpeed() * 10.0;
                        double yVel = y1 * this.getParticleSpeed() * 10.0;
                        double zVel = z1 * this.getParticleSpeed() * 10.0;
                        this.field_70170_p.func_175688_a(particle, x1 + this.field_70165_t, y1 + this.field_70163_u, z1 + this.field_70161_v, xVel, yVel, zVel, new int[0]);
                    }
                }
            }
        }
    }

    @Override
    public boolean pushLevers(BlockPos pos) {
        if (super.pushLevers(pos) && this.getElement() instanceof Airbending && this.getOwner() != null && this.getAbility() != null) {
            AbilityData.get(this.getOwner(), this.getAbility().getName()).addXp(this.getXpPerHit() / 4.0f);
        }
        return super.pushLevers(pos);
    }

    @Override
    public boolean pushButtons(BlockPos pos) {
        if (super.pushButtons(pos) && this.getElement() instanceof Airbending && this.getOwner() != null && this.getAbility() != null) {
            AbilityData.get(this.getOwner(), this.getAbility().getName()).addXp(this.getXpPerHit() / 4.0f);
        }
        return super.pushButtons(pos);
    }

    @Override
    public boolean pushTrapDoors(BlockPos pos) {
        if (super.pushTrapDoors(pos) && this.getElement() instanceof Airbending && this.getOwner() != null && this.getAbility() != null) {
            AbilityData.get(this.getOwner(), this.getAbility().getName()).addXp(this.getXpPerHit() / 4.0f);
        }
        return super.pushTrapDoors(pos);
    }

    @Override
    public boolean pushDoors(BlockPos pos) {
        if (super.pushGates(pos) && this.getElement() instanceof Airbending && this.getOwner() != null && this.getAbility() != null) {
            AbilityData.get(this.getOwner(), this.getAbility().getName()).addXp(this.getXpPerHit() / 4.0f);
        }
        return super.pushGates(pos);
    }

    @Override
    public boolean pushGates(BlockPos pos) {
        if (super.pushGates(pos) && this.getElement() instanceof Airbending && this.getOwner() != null && this.getAbility() != null) {
            AbilityData.get(this.getOwner(), this.getAbility().getName()).addXp(this.getXpPerHit() / 4.0f);
        }
        return super.pushGates(pos);
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    @Override
    public double getExpandedHitboxWidth() {
        return (double)this.field_70173_aa * this.getSpeed() * 0.5;
    }

    @Override
    public double getExpandedHitboxHeight() {
        return (double)this.field_70173_aa * this.getSpeed() * 0.5;
    }

    @Override
    public Vec3d getKnockback(Entity target) {
        double dist = this.getExpandedHitboxWidth() - (double)target.func_70032_d((Entity)this) > 1.0 ? this.getExpandedHitboxWidth() - (double)target.func_70032_d((Entity)this) : 1.0;
        Vec3d velocity = target.func_174791_d().func_178788_d(this.func_174791_d());
        velocity = velocity.func_186678_a(1.0 / dist).func_72441_c(0.0, this.getKnockbackHeight(), 0.0);
        double y = velocity.field_72448_b;
        y = this.getKnockbackHeight() != 0.0 ? Math.min(y * this.getKnockbackMult().field_72448_b, this.getKnockbackHeight()) : y;
        return new Vec3d(velocity.field_72450_a * (double)this.getPush() * this.getSpeed(), y * (double)this.getPush() * this.getSpeed(), velocity.field_72449_c * (double)this.getPush() * this.getSpeed());
    }

    @Override
    public Vec3d getKnockbackMult() {
        double amount = this.getSphere() ? (double)(2.0f / (float)this.field_70173_aa) * this.getSpeed() : (double)(3.0f / (float)this.field_70173_aa) * this.getSpeed();
        return new Vec3d(amount * this.knockbackMult.field_72450_a, amount * this.knockbackMult.field_72448_b, amount * this.knockbackMult.field_72449_c);
    }

    public void setKnockbackMult(Vec3d mult) {
        this.knockbackMult = mult;
    }

    @Override
    public int getPerformanceAmount() {
        return this.performanceAmount;
    }

    @Override
    public void setPerformanceAmount(int amount) {
        this.performanceAmount = amount;
    }

    @Override
    public float getXpPerHit() {
        return 4.0f;
    }

    @Override
    public int getFireTime() {
        return this.fireTime;
    }

    @Override
    public void setFireTime(int time) {
        this.fireTime = time;
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return super.canCollideWith(entity) || entity instanceof EntityArrow || entity instanceof EntityThrowable;
    }

    @Override
    public SoundEvent[] getSounds() {
        return new SoundEvent[0];
    }

    @Override
    public void spawnExplosionParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnDissipateParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnPiercingParticles(World world, Vec3d pos) {
    }

    @Override
    public boolean shouldDissipate() {
        return false;
    }

    @Override
    public boolean shouldExplode() {
        return false;
    }

    @Override
    public boolean isShockwave() {
        return true;
    }
}

