/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import java.util.ArrayList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityTornado
extends EntityOffensive {
    private static final DataParameter<Boolean> SYNC_EXPLODE = EntityDataManager.func_187226_a(EntityTornado.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityTornado(World world) {
        super(world);
    }

    @Override
    public boolean shouldExplode() {
        return false;
    }

    @Override
    public boolean shouldDissipate() {
        return true;
    }

    @Override
    public boolean isPiercing() {
        return true;
    }

    @Override
    public boolean multiHit() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        ArrayList<Vec3d> tornadoPoints = new ArrayList<Vec3d>();
        if (this.field_70170_p.field_72995_K) {
            for (int angle = 0; angle < 120; ++angle) {
                double radAngle = Math.toRadians(angle);
                double angle2 = this.field_70170_p.field_73012_v.nextDouble() * Math.PI * 2.0;
                double radius = 0.01 + (double)angle / (120.0 / ((double)this.getWidth() + this.getExpandedHitboxWidth()));
                double x = radius * Math.cos(radAngle);
                double y = (double)angle / (120.0 / (this.getExpandedHitboxHeight() + (double)this.getHeight()));
                double z = radius * Math.sin(radAngle);
                double speed = this.field_70170_p.field_73012_v.nextDouble() * 2.0 + 1.0;
                double omega = Math.signum(speed * (0.3141592653589793 - speed / (20.0 * radius)));
                angle2 += omega;
                Vec3d centre = AvatarEntityUtils.getBottomMiddleOfEntity(this);
                tornadoPoints.add(new Vec3d(x + centre.field_72450_a, y + centre.field_72448_b, z + centre.field_72449_c));
            }
            for (int i = 0; i < tornadoPoints.size() - 1; ++i) {
                Vec3d pos = (Vec3d)tornadoPoints.get(i);
                Vec3d pos2 = (Vec3d)tornadoPoints.get(i + 1);
                Vec3d pos3 = null;
                if (i < tornadoPoints.size() - 2) {
                    pos3 = (Vec3d)tornadoPoints.get(i + 2);
                }
                Vec3d[] points = new Vec3d[]{pos, pos2, pos3};
                for (int h = 0; h < 360; h += 3) {
                    pos = AvatarUtils.bezierCurve((float)h / 360.0f, points);
                    ParticleBuilder.create(ParticleBuilder.Type.FLASH);
                }
            }
        }
    }
}

