/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityWallSegment;
import com.crowsofwar.avatar.entity.data.SyncedEntity;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.gorecore.util.GoreCoreNBTUtil;
import com.crowsofwar.gorecore.util.Vector;
import com.google.common.base.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class EntityWall
extends AvatarEntity {
    private static final DataParameter<Integer> SYNC_DIRECTION = EntityDataManager.func_187226_a(EntityWall.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>>[] SYNC_SEGMENTS = new DataParameter[100];
    private final SyncedEntity<EntityWallSegment>[] segments = new SyncedEntity[100];
    private int nextSegment = 0;
    private boolean dropTypePlace = false;

    public EntityWall(World world) {
        super(world);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new SyncedEntity(this, SYNC_SEGMENTS[i]);
            this.segments[i].preventNullSaving();
        }
        this.func_70105_a(0.0f, 0.0f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_DIRECTION, (Object)EnumFacing.NORTH.ordinal());
        for (DataParameter<Optional<UUID>> syncSegment : SYNC_SEGMENTS) {
            this.field_70180_af.func_187214_a(syncSegment, (Object)Optional.absent());
        }
    }

    @Override
    public EntityLivingBase getController() {
        return this.getOwner();
    }

    @Override
    public void func_70071_h_() {
        EntityWallSegment seg;
        if (this.getOwner() == null) {
            this.func_70106_y();
        }
        double slowest = 2.147483647E9;
        double lowest = 2.147483647E9;
        for (SyncedEntity<EntityWallSegment> ref : this.segments) {
            double topPos;
            seg = ref.getEntity();
            if (seg == null) continue;
            if (Math.abs(seg.velocity().y()) < Math.abs(slowest)) {
                slowest = seg.velocity().y();
            }
            if (!((topPos = seg.position().y() + (double)seg.field_70131_O) < lowest)) continue;
            lowest = topPos;
        }
        for (SyncedEntity<EntityWallSegment> ref : this.segments) {
            seg = ref.getEntity();
            if (seg == null) continue;
            Vector vel = seg.velocity();
            Vector pos = seg.position();
            if (!(slowest > (double)((float)seg.getSegmentHeight() / 10.0f))) continue;
            seg.setVelocity(vel.withY(slowest));
        }
        this.setVelocity(Vector.ZERO);
        this.field_70145_X = true;
        this.func_70091_d(MoverType.SELF, 0.0, slowest / 20.0, 0.0);
    }

    void addSegment(EntityWallSegment segment) {
        this.segments[this.nextSegment].setEntity(segment);
        ++this.nextSegment;
    }

    public EntityWallSegment getSegment(int i) {
        return this.segments[i].getEntity();
    }

    public EnumFacing getDirection() {
        return EnumFacing.values()[(Integer)this.field_70180_af.func_187225_a(SYNC_DIRECTION)];
    }

    public void setDirection(EnumFacing direction) {
        if (direction.func_176740_k().func_176720_b()) {
            throw new IllegalArgumentException("Cannot face up/down: " + direction);
        }
        this.field_70180_af.func_187227_b(SYNC_DIRECTION, (Object)direction.ordinal());
    }

    @Override
    public BendingStyle getElement() {
        return new Earthbending();
    }

    @Override
    public boolean isShield() {
        return true;
    }

    public void setDropTypePlace(boolean place) {
        this.dropTypePlace = place;
    }

    public void func_70106_y() {
        BendingData bD;
        for (SyncedEntity<EntityWallSegment> ref : this.segments) {
            EntityWallSegment entity = ref.getEntity();
            if (entity == null) continue;
            entity.field_70128_L = true;
            if (this.dropTypePlace) {
                entity.placeBlocks();
                continue;
            }
            entity.dropBlocks();
        }
        if (this.getOwner() != null && (bD = BendingData.getFromEntity(this.getOwner())) != null) {
            bD.removeStatusControl(StatusControlController.PLACE_WALL);
            bD.removeStatusControl(StatusControlController.DROP_WALL);
        }
        super.func_70106_y();
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].readFromNbt(GoreCoreNBTUtil.nestedCompound(nbt, "Wall" + i));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i].writeToNbt(GoreCoreNBTUtil.nestedCompound(nbt, "Wall" + i));
        }
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return super.canCollideWith(entity) && !(entity instanceof EntityWall) && !(entity instanceof EntityWallSegment);
    }

    static {
        for (int i = 0; i < SYNC_SEGMENTS.length; ++i) {
            EntityWall.SYNC_SEGMENTS[i] = EntityDataManager.func_187226_a(EntityWall.class, (DataSerializer)DataSerializers.field_187203_m);
        }
    }
}

