/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BattlePerformanceScore;
import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityWall;
import com.crowsofwar.avatar.entity.data.SyncedEntity;
import com.crowsofwar.avatar.entity.data.WallBehavior;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.gorecore.util.GoreCoreNBTUtil;
import com.crowsofwar.gorecore.util.Vector;
import com.google.common.base.Optional;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityWallSegment
extends AvatarEntity
implements IEntityAdditionalSpawnData {
    public static final DataParameter<Integer> SYNC_SEGMENT_HEIGHT = EntityDataManager.func_187226_a(EntityWallSegment.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> SYNC_WALL = EntityDataManager.func_187226_a(EntityWallSegment.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<WallBehavior> SYNC_BEHAVIOR = EntityDataManager.func_187226_a(EntityWallSegment.class, WallBehavior.SERIALIZER);
    private static final DataParameter<Optional<IBlockState>>[] SYNC_BLOCKS_DATA = new DataParameter[100];
    private final SyncedEntity<EntityWall> wallReference = new SyncedEntity(this, SYNC_WALL);
    private boolean restrictToVertical;
    private Vector initialPos;
    private EnumFacing direction;
    private int offset;

    public EntityWallSegment(World world) {
        super(world);
        this.wallReference.preventNullSaving();
        this.func_70105_a(0.9f, 5.0f);
        this.restrictToVertical = true;
        this.initialPos = Vector.fromVec3d(this.func_174791_d());
    }

    @Override
    public BendingStyle getElement() {
        return new Earthbending();
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_WALL, (Object)Optional.absent());
        for (DataParameter<Optional<IBlockState>> sync : SYNC_BLOCKS_DATA) {
            this.field_70180_af.func_187214_a(sync, (Object)Optional.of((Object)Blocks.field_150348_b.func_176223_P()));
        }
        this.field_70180_af.func_187214_a(SYNC_BEHAVIOR, (Object)new WallBehavior.Rising());
        this.field_70180_af.func_187214_a(SYNC_SEGMENT_HEIGHT, (Object)5);
    }

    public EntityWall getWall() {
        return this.wallReference.getEntity();
    }

    @Override
    public boolean isShield() {
        return true;
    }

    public void setRestrictToVertical(boolean value) {
        this.restrictToVertical = value;
    }

    public Vector getInitialPos() {
        return this.initialPos;
    }

    public void setInitialPos(Vector pos) {
        this.initialPos = pos;
    }

    public void attachToWall(EntityWall wall) {
        this.wallReference.setEntity(wall);
        wall.addSegment(this);
    }

    public IBlockState getBlock(int i) {
        IBlockState state = (IBlockState)((Optional)this.field_70180_af.func_187225_a(SYNC_BLOCKS_DATA[i])).orNull();
        return state == null ? Blocks.field_150350_a.func_176223_P() : state;
    }

    public void setBlock(int i, IBlockState block) {
        this.field_70180_af.func_187227_b(SYNC_BLOCKS_DATA[i], (Object)(block == null ? Optional.of((Object)Blocks.field_150350_a.func_176223_P()) : Optional.of((Object)block)));
    }

    public WallBehavior getBehavior() {
        return (WallBehavior)this.field_70180_af.func_187225_a(SYNC_BEHAVIOR);
    }

    public void setBehavior(WallBehavior behavior) {
        this.field_70180_af.func_187227_b(SYNC_BEHAVIOR, (Object)behavior);
        if (behavior instanceof WallBehavior.Drop && this.getOwner() != null) {
            BendingData.get(this.getOwner()).removeStatusControl(StatusControlController.DROP_WALL);
            BendingData.get(this.getOwner()).removeStatusControl(StatusControlController.PLACE_WALL);
            BendingData.get(this.getOwner()).removeStatusControl(StatusControlController.SHOOT_WALL);
            BendingData.get(this.getOwner()).removeStatusControl(StatusControlController.PUSH_WALL);
            BendingData.get(this.getOwner()).removeStatusControl(StatusControlController.PULL_WALL);
        }
    }

    public int getSegmentHeight() {
        return (Integer)this.field_70180_af.func_187225_a(SYNC_SEGMENT_HEIGHT);
    }

    public void setSegmentHeight(int height) {
        this.field_70180_af.func_187227_b(SYNC_SEGMENT_HEIGHT, (Object)height);
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public void setDirection(EnumFacing dir) {
        this.direction = dir;
    }

    public int getBlocksOffset() {
        return this.offset;
    }

    public void setBlocksOffset(int offset) {
        this.offset = offset;
    }

    public void func_70107_b(double x, double y, double z) {
        this.setInitialPos(new Vector(x, y, z));
        super.func_70107_b(x, y, z);
    }

    @Override
    public void setPosition(Vector position) {
        this.setInitialPos(position);
        super.setPosition(position);
    }

    @Override
    public void setPosition(Vec3d position) {
        super.setPosition(position);
    }

    public void func_70105_a(float width, float height) {
        super.func_70105_a(width, height);
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.getWall() != null) {
            this.getWall().func_70106_y();
        }
    }

    public void dropBlocks() {
        for (int i = 0; i < this.getSegmentHeight(); ++i) {
            IBlockState state = this.getBlock(i);
            if (state.func_177230_c() == Blocks.field_150350_a) continue;
            this.field_70170_p.func_175656_a(new BlockPos((Entity)this).func_177981_b(i + this.getBlocksOffset()), state);
        }
    }

    public void placeBlocks() {
        for (int i = 0; i < this.getSegmentHeight(); ++i) {
            IBlockState state = this.getBlock(i);
            if (state.func_177230_c() == Blocks.field_150350_a) continue;
            this.field_70170_p.func_175656_a(new BlockPos((Entity)this).func_177981_b(i + this.getBlocksOffset() + 1), state);
        }
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70158_ak = true;
        if (this.getOwner() == null) {
            this.func_70106_y();
        }
        if (this.restrictToVertical) {
            this.setVelocity(this.velocity().withX(0.0).withZ(0.0));
        }
        WallBehavior next = (WallBehavior)this.getBehavior().onUpdate(this);
        if (this.getBehavior() != next) {
            this.setBehavior(next);
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand stack) {
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K && player.field_71075_bZ.field_75098_d && player.func_70093_af()) {
            this.func_70106_y();
            this.dropBlocks();
            this.func_70018_K();
            return true;
        }
        return false;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.wallReference.readFromNbt(GoreCoreNBTUtil.nestedCompound(nbt, "Parent"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.wallReference.writeToNbt(GoreCoreNBTUtil.nestedCompound(nbt, "Parent"));
    }

    public boolean func_70112_a(double distance) {
        return true;
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeFloat(this.field_70131_O);
        buf.writeInt(this.offset);
    }

    public void readSpawnData(ByteBuf buf) {
        this.func_70105_a(this.field_70130_N, buf.readFloat());
        this.offset = buf.readInt();
    }

    public void func_70024_g(double x, double y, double z) {
    }

    @Override
    public boolean canPush() {
        return false;
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        List entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ());
        if (entities.size() > 0) {
            for (Entity entity : entities) {
                if (!(entity instanceof EntityPlayer)) continue;
                if (this.getBehavior().getClass() == WallBehavior.Rising.class) {
                    entity.func_70024_g(entity.field_70159_w, entity.field_70181_x + 0.25, entity.field_70179_y);
                    continue;
                }
                Vec3d vel = entity.func_174791_d().func_178788_d(this.func_174791_d()).func_186678_a(0.1);
                entity.func_70024_g(vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
            }
        }
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        if (entity != this.getOwner()) {
            boolean ns;
            double amt = 0.05;
            boolean bl = ns = this.direction == EnumFacing.NORTH || this.direction == EnumFacing.SOUTH;
            if (ns) {
                if (entity.field_70161_v > this.field_70161_v) {
                    entity.field_70161_v = this.field_70161_v + 1.1;
                } else {
                    amt = -amt;
                    entity.field_70161_v = this.field_70161_v - 1.1;
                }
            } else if (entity.field_70165_t > this.field_70165_t) {
                entity.field_70165_t = this.field_70165_t + 1.1;
            } else {
                amt = -amt;
                entity.field_70165_t = this.field_70165_t - 1.1;
            }
            if (ns) {
                entity.field_70179_y = amt;
            } else {
                entity.field_70159_w = amt;
            }
            entity.field_70181_x = 0.01;
            entity.field_70160_al = true;
            AvatarUtils.afterVelocityAdded(entity);
            if (entity instanceof AvatarEntity) {
                Vector velocity = ((AvatarEntity)entity).velocity();
                velocity = ns ? velocity.withZ(amt) : velocity.withX(amt);
            }
            if (entity instanceof AvatarEntity) {
                AvatarEntity avEnt = (AvatarEntity)entity;
                avEnt.onCollideWithSolid();
                if (avEnt.onCollideWithSolid()) {
                    entity.func_70106_y();
                    EntityLivingBase owner = this.getOwner();
                    if (owner != null) {
                        BendingData data = BendingData.get(owner);
                        data.getAbilityData("wall").addXp(ConfigSkills.SKILLS_CONFIG.wallBlockedAttack);
                        BattlePerformanceScore.addLargeScore(this.getOwner());
                    }
                }
            }
        }
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        AbilityData data;
        boolean notWall = !(entity instanceof EntityWall) && !(entity instanceof EntityWallSegment);
        boolean friendlyProjectile = false;
        if (this.getOwner() != null && (data = Bender.get(this.getOwner()).getData().getAbilityData("wall")).isMaxLevel() && data.getPath() == AbilityData.AbilityTreePath.FIRST) {
            friendlyProjectile = entity instanceof AvatarEntity && ((AvatarEntity)entity).getOwner() == this.getOwner();
        }
        return notWall && !friendlyProjectile;
    }

    static {
        for (int i = 0; i < 100; ++i) {
            EntityWallSegment.SYNC_BLOCKS_DATA[i] = EntityDataManager.func_187226_a(EntityWallSegment.class, (DataSerializer)DataSerializers.field_187197_g);
        }
    }
}

