/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.water.AbilityWaterArc;
import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.ControlPoint;
import com.crowsofwar.avatar.entity.EntityArc;
import com.crowsofwar.avatar.entity.IShieldEntity;
import com.crowsofwar.avatar.entity.data.WaterArcBehavior;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.gorecore.util.Vector;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityWaterArc
extends EntityArc<WaterControlPoint>
implements IShieldEntity {
    private static final DataParameter<WaterArcBehavior> SYNC_BEHAVIOR = EntityDataManager.func_187226_a(EntityWaterArc.class, WaterArcBehavior.DATA_SERIALIZER);
    private static final DataParameter<Float> SYNC_GRAVITY = EntityDataManager.func_187226_a(EntityWaterArc.class, (DataSerializer)DataSerializers.field_187193_c);
    private int lastPlayedSplash;
    private boolean isSpear;
    private float damageMult;
    private float velocityMultiplier;

    public EntityWaterArc(World world) {
        super(world);
        this.func_70105_a(0.2f, 0.2f);
        this.lastPlayedSplash = -1;
        this.damageMult = 1.0f;
        this.putsOutFires = true;
        this.velocityMultiplier = 10.0f;
    }

    public float getDamageMult() {
        return this.damageMult;
    }

    public void setDamageMult(float mult) {
        this.damageMult = mult;
    }

    public void isSpear(boolean isSpear) {
        this.isSpear = isSpear;
    }

    public float getGravity() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_GRAVITY)).floatValue();
    }

    public void setGravity(float gravity) {
        this.field_70180_af.func_187227_b(SYNC_GRAVITY, (Object)Float.valueOf(gravity));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_BEHAVIOR, (Object)new WaterArcBehavior.Idle());
        this.field_70180_af.func_187214_a(SYNC_GRAVITY, (Object)Float.valueOf(9.82f));
    }

    @Override
    public void spawnExplosionParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnDissipateParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnPiercingParticles(World world, Vec3d pos) {
    }

    @Override
    @Nullable
    public SoundEvent[] getSounds() {
        SoundEvent[] events = new SoundEvent[]{SoundEvents.field_187547_bF};
        return events;
    }

    @Override
    public boolean onCollideWithSolid() {
        if (!this.field_70170_p.func_184144_a((Entity)this, this.getExpandedHitbox()).isEmpty() && this.field_70132_H) {
            if (!this.field_70170_p.field_72995_K && this.getBehavior() instanceof WaterArcBehavior.Thrown && !this.isSpear && this.field_70170_p.field_72995_K) {
                double offZ;
                double offY;
                double offX;
                double zVel;
                double yVel;
                double xVel;
                Random random = new Random();
                if (this.field_70124_G) {
                    xVel = 5.0;
                    yVel = 3.5;
                    zVel = 5.0;
                    offX = 0.0;
                    offY = 0.6;
                    offZ = 0.0;
                } else {
                    xVel = 7.0;
                    yVel = 2.0;
                    zVel = 7.0;
                    offX = 0.6;
                    offY = 0.2;
                    offZ = 0.6;
                }
                xVel *= 0.0;
                yVel *= 0.0;
                zVel *= 0.0;
                int particles = random.nextInt(3) + 4;
                for (int i = 0; i < particles; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + random.nextGaussian() * offX, this.field_70163_u + random.nextGaussian() * offY + 0.2, this.field_70161_v + random.nextGaussian() * offZ, random.nextGaussian() * xVel, random.nextGaussian() * yVel, random.nextGaussian() * zVel, new int[0]);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void applyElementalContact(AvatarEntity entity) {
        super.applyElementalContact(entity);
        if (entity.getTier() <= this.getTier()) {
            entity.onMajorWaterContact();
        } else {
            entity.onMinorWaterContact();
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.cleanup();
    }

    @Override
    public void func_70071_h_() {
        WaterArcBehavior behavior;
        WaterArcBehavior next;
        super.func_70071_h_();
        if (this.lastPlayedSplash > -1) {
            ++this.lastPlayedSplash;
            if (this.lastPlayedSplash > 20) {
                this.lastPlayedSplash = -1;
            }
        }
        if ((next = (WaterArcBehavior)(behavior = this.getBehavior()).onUpdate(this)) != behavior) {
            this.setBehavior(next);
        }
        if (this.getOwner() == null) {
            this.func_70106_y();
        }
        this.setEntitySize(this.getAvgSize());
        if (this.getBehavior() != null && this.getBehavior() instanceof WaterArcBehavior.PlayerControlled) {
            this.velocityMultiplier = 5.0f;
        }
        if (this.getAbility() instanceof AbilityWaterArc && !this.field_70170_p.field_72995_K && this.getOwner() != null) {
            if (this.getBehavior() != null && this.getBehavior() instanceof WaterArcBehavior.Thrown) {
                AbilityData aD = AbilityData.get(this.getOwner(), "water_arc");
                int lvl = aD.getLevel();
                this.velocityMultiplier = lvl >= 1 ? (float)(8 + 2 * lvl) : 8.0f;
            }
        } else if (this.getBehavior() != null && this.getBehavior() instanceof WaterArcBehavior.Thrown) {
            this.velocityMultiplier = 12.0f;
        }
        if (this.getOwner() != null) {
            EntityWaterArc arc = AvatarEntity.lookupControlledEntity(this.field_70170_p, EntityWaterArc.class, this.getOwner());
            BendingData bD = BendingData.get(this.getOwner());
            if (arc == null && bD.hasStatusControl(StatusControlController.THROW_WATER)) {
                bD.removeStatusControl(StatusControlController.THROW_WATER);
            }
            if (arc != null && arc.getBehavior() instanceof WaterArcBehavior.PlayerControlled && !bD.hasStatusControl(StatusControlController.THROW_WATER)) {
                bD.addStatusControl(StatusControlController.THROW_WATER);
            }
        }
        if (this.field_70170_p.field_72995_K && this.getOwner() != null) {
            int i;
            Vec3d[] points = new Vec3d[this.getAmountOfControlPoints()];
            for (i = 0; i < points.length; ++i) {
                points[i] = ((WaterControlPoint)this.getControlPoint(i)).position().toMinecraft();
            }
            for (i = 0; i < this.getAmountOfControlPoints() - 1; ++i) {
                int h;
                Vec3d pos = ((WaterControlPoint)this.getControlPoint(points.length - i - 1)).position().toMinecraft();
                Vec3d pos2 = i < points.length - 1 ? ((WaterControlPoint)this.getControlPoint(Math.max(points.length - i - 2, 0))).position().toMinecraft() : Vec3d.field_186680_a;
                for (h = 0; h < 3; ++h) {
                    pos = pos.func_178787_e(AvatarUtils.bezierCurve(((double)(points.length - i) - 1.0 / (double)(h + 1)) / (double)points.length, points));
                    pos2 = pos2.func_178787_e(AvatarUtils.bezierCurve(Math.min((double)(i + 1) / ((double)h + 1.0) / (double)points.length, 1.0), points));
                    Vec3d circlePos = Vector.getOrthogonalVector(this.func_70040_Z(), (double)(this.field_70173_aa % 360 * 20 + h * 120), (double)(this.getAvgSize() / 3.25f)).toMinecraft().func_178787_e(pos);
                    Vec3d targetPos = i < points.length - 1 ? Vector.getOrthogonalVector(this.func_70040_Z(), (double)(this.field_70173_aa % 360 * 20 + h * 120 + 20), (double)(this.getAvgSize() / 3.25f)).toMinecraft().func_178787_e(pos2) : Vec3d.field_186680_a;
                    Vec3d vel = new Vec3d(this.field_70170_p.field_73012_v.nextGaussian() / 240.0, this.field_70170_p.field_73012_v.nextGaussian() / 240.0, this.field_70170_p.field_73012_v.nextGaussian() / 240.0);
                    if (targetPos != circlePos) {
                        vel = targetPos == Vec3d.field_186680_a ? vel : targetPos.func_178788_d(circlePos).func_72432_b().func_186678_a(0.075).func_178787_e(vel);
                    }
                    ParticleBuilder.create(ParticleBuilder.Type.CUBE).pos(circlePos).spawnEntity(this).vel(vel).clr(0, 102, 255, 145).scale(this.getAvgSize() * 1.75f).target(targetPos == Vec3d.field_186680_a ? pos : targetPos).time(8 + AvatarUtils.getRandomNumberInRange(0, 2)).collide(true).collideParticles(true).element(new Waterbending()).spawn(this.field_70170_p);
                }
                for (h = 0; h < 2; ++h) {
                    pos = pos.func_178787_e(AvatarUtils.bezierCurve(((double)(points.length - i) - 1.0 / (double)(h + 1)) / (double)points.length, points));
                    ParticleBuilder.create(ParticleBuilder.Type.CUBE).pos(pos).spawnEntity(this).vel(this.field_70170_p.field_73012_v.nextGaussian() / 120.0, this.field_70170_p.field_73012_v.nextGaussian() / 120.0, this.field_70170_p.field_73012_v.nextGaussian() / 120.0).clr(0, 102, 255, 185).time(10 + AvatarUtils.getRandomNumberInRange(0, 2)).scale(this.getAvgSize() * 1.75f).collide(true).collideParticles(true).element(new Waterbending()).spawn(this.field_70170_p);
                }
                for (h = 0; h < 1; ++h) {
                    pos = pos.func_178787_e(AvatarUtils.bezierCurve(((double)(points.length - i) - 1.0 / (double)(h + 1)) / (double)points.length, points));
                    ParticleBuilder.create(ParticleBuilder.Type.CUBE).pos(pos).spawnEntity(this).vel(this.field_70170_p.field_73012_v.nextGaussian() / 20.0, this.field_70170_p.field_73012_v.nextDouble() / 12.0, this.field_70170_p.field_73012_v.nextGaussian() / 20.0).clr(0, 102, 255, 185).time(6 + AvatarUtils.getRandomNumberInRange(0, 2)).scale(this.getAvgSize() * 1.5f).gravity(true).collide(true).collideParticles(true).element(new Waterbending()).spawn(this.field_70170_p);
                }
            }
        }
    }

    @Override
    public int getFireTime() {
        return 0;
    }

    @Override
    protected WaterControlPoint createControlPoint(float size, int index) {
        return new WaterControlPoint(this, size, this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public boolean canPlaySplash() {
        return this.lastPlayedSplash == -1;
    }

    public void playSplash() {
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187549_bG, SoundCategory.PLAYERS, 0.3f, 1.5f, false);
        this.lastPlayedSplash = 0;
    }

    public WaterArcBehavior getBehavior() {
        return (WaterArcBehavior)this.field_70180_af.func_187225_a(SYNC_BEHAVIOR);
    }

    public void setBehavior(WaterArcBehavior behavior) {
        this.field_70180_af.func_187227_b(SYNC_BEHAVIOR, (Object)behavior);
    }

    @Override
    public EntityLivingBase getController() {
        return this.getBehavior() instanceof WaterArcBehavior.PlayerControlled ? this.getOwner() : null;
    }

    public void cleanup() {
        BendingData data;
        if (this.getOwner() != null && (data = Objects.requireNonNull(Bender.get(this.getOwner())).getData()) != null) {
            data.removeStatusControl(StatusControlController.THROW_WATER);
        }
    }

    private void breakCollidingBlocks() {
        double expansion = 0.1;
        AxisAlignedBB hitbox = this.func_174813_aQ().func_72314_b(expansion, expansion, expansion);
        for (int ix = 0; ix <= 1; ++ix) {
            for (int iz = 0; iz <= 1; ++iz) {
                double x = ix == 0 ? hitbox.field_72340_a : hitbox.field_72336_d;
                double y = hitbox.field_72338_b;
                double z = iz == 0 ? hitbox.field_72339_c : hitbox.field_72334_f;
                BlockPos pos = new BlockPos(x, y, z);
                this.tryBreakBlock(this.field_70170_p.func_180495_p(pos), pos);
            }
        }
    }

    private void tryBreakBlock(IBlockState state, BlockPos pos) {
        if (state.func_177230_c() == Blocks.field_150350_a || !ConfigStats.STATS_CONFIG.waterArcBreakableBlocks.contains(state.func_177230_c())) {
            return;
        }
        float hardness = state.func_185887_b(this.field_70170_p, pos);
        if (hardness <= 4.0f) {
            this.breakBlock(pos);
            this.setVelocity(this.velocity().times(0.75));
        }
    }

    @Override
    protected double getVelocityMultiplier() {
        return this.velocityMultiplier;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public float getHealth() {
        return 0.0f;
    }

    @Override
    public void setHealth(float health) {
    }

    @Override
    public float getMaxHealth() {
        return 0.0f;
    }

    @Override
    public void setMaxHealth(float maxHealth) {
    }

    @Override
    protected double getControlPointTeleportDistanceSq() {
        return this.getControlPointMaxDistanceSq() * (double)this.getAmountOfControlPoints();
    }

    @Override
    protected double getControlPointMaxDistanceSq() {
        return 0.725f;
    }

    @Override
    public int getAmountOfControlPoints() {
        return 7;
    }

    @Override
    public boolean shouldExplode() {
        return this.getBehavior() instanceof WaterArcBehavior.Thrown;
    }

    static class WaterControlPoint
    extends ControlPoint {
        private WaterControlPoint(EntityArc arc, float size, double x, double y, double z) {
            super(arc, size, x, y, z);
        }
    }
}

