/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.fire.Firebending;
import com.crowsofwar.avatar.bending.bending.lightning.Lightningbending;
import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.IShieldEntity;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.entity.data.WaterBubbleBehavior;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.gorecore.util.Vector;
import java.util.Random;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityWaterBubble
extends EntityOffensive
implements IShieldEntity {
    private static final DataParameter<WaterBubbleBehavior> SYNC_BEHAVIOR = EntityDataManager.func_187226_a(EntityWaterBubble.class, WaterBubbleBehavior.DATA_SERIALIZER);
    private static final DataParameter<Float> SYNC_SIZE = EntityDataManager.func_187226_a(EntityWaterBubble.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_HEALTH = EntityDataManager.func_187226_a(EntityWaterBubble.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_DEGREES_PER_SECOND = EntityDataManager.func_187226_a(EntityWaterBubble.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> SYNC_MAX_SIZE = EntityDataManager.func_187226_a(EntityWaterBubble.class, (DataSerializer)DataSerializers.field_187193_c);
    private boolean sourceBlock;

    public EntityWaterBubble(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.8f);
        this.putsOutFires = true;
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_SIZE)).floatValue();
    }

    public void setSize(float size) {
        this.field_70180_af.func_187227_b(SYNC_SIZE, (Object)Float.valueOf(size));
    }

    public float getMaxSize() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_MAX_SIZE)).floatValue();
    }

    public void setMaxSize(float maxSize) {
        this.field_70180_af.func_187227_b(SYNC_MAX_SIZE, (Object)Float.valueOf(maxSize));
    }

    @Override
    public float getHealth() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_HEALTH)).floatValue();
    }

    @Override
    public float getMaxHealth() {
        return 0.0f;
    }

    @Override
    public void setHealth(float health) {
        this.field_70180_af.func_187227_b(SYNC_HEALTH, (Object)Float.valueOf(health));
    }

    @Override
    public void setMaxHealth(float maxHealth) {
    }

    public float getDegreesPerSecond() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_DEGREES_PER_SECOND)).floatValue();
    }

    public void setDegreesPerSecond(float degrees) {
        this.field_70180_af.func_187227_b(SYNC_DEGREES_PER_SECOND, (Object)Float.valueOf(degrees));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_BEHAVIOR, (Object)new WaterBubbleBehavior.Drop());
        this.field_70180_af.func_187214_a(SYNC_SIZE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(SYNC_MAX_SIZE, (Object)Float.valueOf(1.5f));
        this.field_70180_af.func_187214_a(SYNC_HEALTH, (Object)Float.valueOf(3.0f));
        this.field_70180_af.func_187214_a(SYNC_DEGREES_PER_SECOND, (Object)Float.valueOf(5.0f));
    }

    @Override
    public void func_70071_h_() {
        int moisture;
        BlockPos down;
        IBlockState downState;
        WaterBubbleBehavior nextBehavior;
        WaterBubbleBehavior currentBehavior;
        super.func_70071_h_();
        this.func_70105_a(this.getSize(), this.getSize());
        if (this.getBehavior() != null && this.getBehavior() instanceof WaterBubbleBehavior.Lobbed) {
            this.setVelocity(this.velocity().times(0.9));
        }
        if (this.getHealth() == 0.0f) {
            this.func_70106_y();
        }
        if ((currentBehavior = this.getBehavior()) != (nextBehavior = (WaterBubbleBehavior)currentBehavior.onUpdate(this))) {
            this.setBehavior(nextBehavior);
        }
        if (this.field_70173_aa % 5 == 0 && (downState = this.field_70170_p.func_180495_p(down = this.func_180425_c().func_177977_b())).func_177230_c() == Blocks.field_150458_ak && (moisture = ((Integer)downState.func_177229_b((IProperty)BlockFarmland.field_176531_a)).intValue()) < 7) {
            this.field_70170_p.func_175656_a(down, Blocks.field_150458_ak.func_176223_P().func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(moisture + 1)));
        }
        boolean inWaterSource = false;
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 2 == 1 && this.field_70173_aa > 10) {
            block0: for (int x = 0; x <= 1; ++x) {
                for (int z = 0; z <= 1; ++z) {
                    BlockPos pos = new BlockPos(this.field_70165_t + (double)((float)x * this.field_70130_N), this.field_70163_u, this.field_70161_v + (double)((float)z * this.field_70130_N));
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    if (state.func_177230_c() != Blocks.field_150355_j || (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) continue;
                    inWaterSource = true;
                    continue block0;
                }
            }
        }
        if (this.getOwner() == null) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && this.getOwner() != null) {
            for (double h = 0.0; h < (double)this.field_70130_N; h += 0.5) {
                Random random = new Random();
                AxisAlignedBB boundingBox = this.func_174813_aQ();
                double spawnX = boundingBox.field_72340_a + random.nextDouble() * (boundingBox.field_72336_d - boundingBox.field_72340_a);
                double spawnY = boundingBox.field_72338_b + random.nextDouble() * (boundingBox.field_72337_e - boundingBox.field_72338_b);
                double spawnZ = boundingBox.field_72339_c + random.nextDouble() * (boundingBox.field_72334_f - boundingBox.field_72339_c);
                ParticleBuilder.create(ParticleBuilder.Type.CUBE).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 60.0, this.field_70170_p.field_73012_v.nextGaussian() / 60.0, this.field_70170_p.field_73012_v.nextGaussian() / 60.0).time(15 + AvatarUtils.getRandomNumberInRange(0, 10)).clr(0, 102, 255, 255).scale(this.getSize()).element(this.getElement()).spawnEntity((Entity)this.getOwner()).element(new Waterbending()).spawn(this.field_70170_p);
                ParticleBuilder.create(ParticleBuilder.Type.CUBE).pos(spawnX, spawnY, spawnZ).vel(this.field_70170_p.field_73012_v.nextGaussian() / 60.0, this.field_70170_p.field_73012_v.nextGaussian() / 60.0, this.field_70170_p.field_73012_v.nextGaussian() / 60.0).time(15 + AvatarUtils.getRandomNumberInRange(0, 10)).clr(0, 102, 255, 255).scale(this.getSize()).element(this.getElement()).spawnEntity((Entity)this.getOwner()).element(new Waterbending()).spawn(this.field_70170_p);
            }
        }
    }

    @Override
    public boolean shouldExplode() {
        return !(this.getBehavior() instanceof WaterBubbleBehavior.PlayerControlled);
    }

    @Override
    public void spawnExplosionParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnDissipateParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnPiercingParticles(World world, Vec3d pos) {
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        float damage;
        if (entity instanceof AvatarEntity) {
            ((AvatarEntity)entity).onMajorWaterContact();
            if (((AvatarEntity)entity).getAbility() != null && ((AvatarEntity)entity).getOwner() != null && this.getBehavior() != null && this.getBehavior() instanceof WaterBubbleBehavior.PlayerControlled) {
                damage = AbilityData.get(((AvatarEntity)entity).getOwner(), ((AvatarEntity)entity).getAbility().getName()).getLevel();
                if (((AvatarEntity)entity).getElement() instanceof Firebending) {
                    damage = (float)((double)damage * 0.5);
                }
                if (((AvatarEntity)entity).getElement() instanceof Lightningbending) {
                    damage *= 2.0f;
                }
                if (((AvatarEntity)entity).getElement() instanceof Waterbending) {
                    damage = (float)((double)damage * 0.75);
                }
                ((AvatarEntity)entity).onCollideWithSolid();
                this.setHealth(this.getHealth() - damage);
            }
        }
        if (this.getBehavior() instanceof WaterBubbleBehavior.PlayerControlled && entity instanceof EntityArrow) {
            damage = (float)((EntityArrow)entity).func_70242_d();
            Vector vel = Vector.getVelocity(entity).times(-1.0);
            entity.func_70024_g(vel.x(), 0.0, vel.z());
            this.setHealth(this.getHealth() - damage);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setBehavior((WaterBubbleBehavior)Behavior.lookup(compound.func_74762_e("Behavior"), this));
        this.getBehavior().load(compound);
        this.setSourceBlock(compound.func_74767_n("SourceBlock"));
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Behavior", this.getBehavior().getId());
        this.getBehavior().save(compound);
        compound.func_74757_a("SourceBlock", this.sourceBlock);
    }

    public WaterBubbleBehavior getBehavior() {
        return (WaterBubbleBehavior)this.field_70180_af.func_187225_a(SYNC_BEHAVIOR);
    }

    public void setBehavior(WaterBubbleBehavior behavior) {
        this.field_70180_af.func_187227_b(SYNC_BEHAVIOR, (Object)behavior);
    }

    public boolean isSourceBlock() {
        return this.sourceBlock;
    }

    public void setSourceBlock(boolean sourceBlock) {
        this.sourceBlock = sourceBlock;
    }

    @Override
    public EntityLivingBase getController() {
        return this.getBehavior() instanceof WaterBubbleBehavior.PlayerControlled ? this.getOwner() : null;
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }
}

