/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BendingStyle;
import com.crowsofwar.avatar.bending.bending.water.Waterbending;
import com.crowsofwar.avatar.client.particle.ParticleBuilder;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.ControlPoint;
import com.crowsofwar.avatar.entity.EntityArc;
import com.crowsofwar.avatar.entity.EntityWaterArc;
import com.crowsofwar.avatar.entity.IShieldEntity;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.gorecore.util.Vector;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityWaterCannon
extends EntityArc<WaterControlPoint>
implements IShieldEntity {
    private static final DataParameter<Float> SYNC_SPEED = EntityDataManager.func_187226_a(EntityWaterArc.class, (DataSerializer)DataSerializers.field_187193_c);
    private final float velocityMultiplier;
    private int lastPlayedSplash;
    private boolean isSpear;
    private float damageMult;

    public EntityWaterCannon(World world) {
        super(world);
        this.func_70105_a(0.2f, 0.2f);
        this.lastPlayedSplash = -1;
        this.field_70145_X = true;
        this.damageMult = 1.0f;
        this.putsOutFires = true;
        this.velocityMultiplier = 5.0f;
    }

    public float getDamageMult() {
        return this.damageMult;
    }

    public void setDamageMult(float mult) {
        this.damageMult = mult;
    }

    public void isSpear(boolean isSpear) {
        this.isSpear = isSpear;
    }

    public float getSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_SPEED)).floatValue();
    }

    public void setSpeed(float speed) {
        this.field_70180_af.func_187227_b(SYNC_SPEED, (Object)Float.valueOf(speed));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_SPEED, (Object)Float.valueOf(30.0f));
    }

    @Override
    public void spawnExplosionParticles(World world, Vec3d pos) {
        if (world.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                for (int h = 0; h < 6; ++h) {
                    Vec3d circlePos = Vector.getOrthogonalVector(this.func_70040_Z(), (double)(this.field_70173_aa % 360 * 20 + h * 60), (double)(this.getAvgSize() / 2.0f)).toMinecraft().func_178787_e(pos);
                    Vec3d vel = new Vec3d(world.field_73012_v.nextGaussian() / 10.0, world.field_73012_v.nextGaussian() / 10.0, world.field_73012_v.nextGaussian() / 10.0);
                    ParticleBuilder.create(ParticleBuilder.Type.CUBE).pos(circlePos).spawnEntity(this).vel(vel).clr(0, 102, 255, 145).scale(this.getAvgSize()).time(16 + AvatarUtils.getRandomNumberInRange(0, 4)).collide(true).collideParticles(true).element(new Waterbending()).spawn(world);
                }
            }
        }
    }

    @Override
    public void spawnDissipateParticles(World world, Vec3d pos) {
    }

    @Override
    public void spawnPiercingParticles(World world, Vec3d pos) {
    }

    @Override
    @Nullable
    public SoundEvent[] getSounds() {
        SoundEvent[] events = new SoundEvent[]{SoundEvents.field_187547_bF};
        return events;
    }

    @Override
    public boolean onCollideWithSolid() {
        if (super.onCollideWithSolid()) {
            this.setVelocity(Vector.ZERO);
            this.setLifeTime(30);
            this.setDamageMult(0.0f);
        }
        return super.onCollideWithSolid();
    }

    @Override
    public void applyElementalContact(AvatarEntity entity) {
        super.applyElementalContact(entity);
        if (entity.getTier() <= this.getTier()) {
            entity.onMajorWaterContact();
        } else {
            entity.onMinorWaterContact();
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    @Override
    protected void updateCpBehavior() {
        ((WaterControlPoint)this.getLeader()).setPosition(this.position().plusY(this.field_70131_O / 2.0f).plus(Vector.getLookRectangular(this).times(this.getAvgSize() / 4.0f)));
        ((WaterControlPoint)this.getLeader()).setVelocity(this.velocity());
        for (int i = 1; i < this.points.size(); ++i) {
            ControlPoint leader = (ControlPoint)this.points.get(i - 1);
            ControlPoint p = (ControlPoint)this.points.get(i);
            Vector leadPos = leader.position();
            double sqrDist = p.position().sqrDist(leadPos);
            if (sqrDist > this.getControlPointTeleportDistanceSq() && this.getControlPointTeleportDistanceSq() != -1.0) {
                Vector toFollowerDir = p.position().minus(leader.position()).normalize();
                double idealDist = Math.sqrt(this.getControlPointTeleportDistanceSq());
                if (idealDist > 1.0) {
                    idealDist -= 1.0;
                }
                Vector revisedOffset = leader.position().plus(toFollowerDir.times(idealDist));
                p.setPosition(revisedOffset);
                leader.setPosition(revisedOffset);
                p.setVelocity(Vector.ZERO);
                continue;
            }
            if (!(sqrDist > this.getControlPointMaxDistanceSq()) || this.getControlPointMaxDistanceSq() == -1.0) continue;
            Vector diff = leader.position().minus(p.position());
            diff = diff.normalize().times(this.getVelocityMultiplier());
            p.setVelocity(p.velocity().plus(diff));
        }
    }

    @Override
    public Vec3d getKnockback() {
        return super.getKnockback();
    }

    @Override
    public Vec3d getKnockbackMult() {
        return new Vec3d(0.75, 0.5, 0.75);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.lastPlayedSplash > -1) {
            ++this.lastPlayedSplash;
            if (this.lastPlayedSplash > 20) {
                this.lastPlayedSplash = -1;
            }
        }
        if (this.getOwner() == null) {
            this.func_70106_y();
        }
        this.setEntitySize(this.getAvgSize());
        if (this.field_70170_p.field_72995_K && this.getOwner() != null && this.field_70173_aa % 2 == 0) {
            int i;
            Vec3d[] points = new Vec3d[this.getAmountOfControlPoints()];
            for (i = 0; i < points.length; ++i) {
                points[i] = ((WaterControlPoint)this.getControlPoint(i)).position().toMinecraft();
            }
            for (i = 0; i < this.getAmountOfControlPoints(); ++i) {
                int h;
                Vec3d pos = ((WaterControlPoint)this.getControlPoint(points.length - i - 1)).position().toMinecraft();
                Vec3d pos2 = i < points.length - 1 ? ((WaterControlPoint)this.getControlPoint(Math.max(points.length - i - 2, 0))).position().toMinecraft() : Vec3d.field_186680_a;
                for (h = 0; h < 5; ++h) {
                    pos = pos.func_178787_e(AvatarUtils.bezierCurve(((double)(points.length - i) - 1.0 / (double)(h + 1)) / (double)points.length, points));
                    pos2 = pos2.func_178787_e(AvatarUtils.bezierCurve(Math.min((double)(i + 1) / ((double)h + 1.0) / (double)points.length, 1.0), points));
                    Vec3d circlePos = Vector.getOrthogonalVector(this.func_70040_Z(), (double)(this.field_70173_aa % 360 * 20 + h * 72), (double)(this.getAvgSize() / 2.0f)).toMinecraft().func_178787_e(pos);
                    Vec3d targetPos = i < points.length - 1 ? Vector.getOrthogonalVector(this.func_70040_Z(), (double)(this.field_70173_aa % 360 * 20 + h * 72 + 20), (double)(this.getAvgSize() / 2.0f)).toMinecraft().func_178787_e(pos2) : Vec3d.field_186680_a;
                    Vec3d vel = new Vec3d(this.field_70170_p.field_73012_v.nextGaussian() / 240.0, this.field_70170_p.field_73012_v.nextGaussian() / 240.0, this.field_70170_p.field_73012_v.nextGaussian() / 240.0);
                    if (targetPos != circlePos) {
                        vel = targetPos == Vec3d.field_186680_a ? vel : targetPos.func_178788_d(circlePos).func_72432_b().func_186678_a(0.15).func_178787_e(vel);
                    }
                    ParticleBuilder.create(ParticleBuilder.Type.CUBE).pos(circlePos).spawnEntity(this).vel(vel).clr(0, 102, 255, 145).scale(this.getAvgSize()).target(targetPos == Vec3d.field_186680_a ? pos : targetPos).time(14 + AvatarUtils.getRandomNumberInRange(0, 4)).collide(true).collideParticles(true).element(new Waterbending()).spawn(this.field_70170_p);
                }
                for (h = 0; h < 6; ++h) {
                    pos = pos.func_178787_e(AvatarUtils.bezierCurve(((double)(points.length - i) - 1.0 / (double)(h + 1)) / (double)points.length, points));
                    ParticleBuilder.create(ParticleBuilder.Type.CUBE).pos(pos).spawnEntity(this).vel(this.field_70170_p.field_73012_v.nextGaussian() / 40.0 * (double)this.getAvgSize(), this.field_70170_p.field_73012_v.nextGaussian() / 40.0 * (double)this.getAvgSize(), this.field_70170_p.field_73012_v.nextGaussian() / 40.0 * (double)this.getAvgSize()).scale(this.getAvgSize()).clr(0, 102, 255, 185).time(12 + AvatarUtils.getRandomNumberInRange(0, 5)).collide(true).collideParticles(true).element(new Waterbending()).spawn(this.field_70170_p);
                }
                for (h = 0; h < 1; ++h) {
                    pos = pos.func_178787_e(AvatarUtils.bezierCurve(((double)(points.length - i) - 1.0 / (double)(h + 1)) / (double)points.length, points));
                    ParticleBuilder.create(ParticleBuilder.Type.CUBE).pos(pos).spawnEntity(this).vel(this.field_70170_p.field_73012_v.nextGaussian() / 20.0, this.field_70170_p.field_73012_v.nextDouble() / 12.0, this.field_70170_p.field_73012_v.nextGaussian() / 20.0).clr(0, 102, 255, 185).time(6 + AvatarUtils.getRandomNumberInRange(0, 3)).target(pos).scale(this.getAvgSize()).gravity(true).collide(true).collideParticles(true).element(new Waterbending()).spawn(this.field_70170_p);
                }
            }
        }
    }

    @Override
    public int getFireTime() {
        return 0;
    }

    @Override
    protected WaterControlPoint createControlPoint(float size, int index) {
        return new WaterControlPoint(this, size, this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    public boolean canPlaySplash() {
        return this.lastPlayedSplash == -1;
    }

    public void playSplash() {
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187549_bG, SoundCategory.PLAYERS, 0.3f, 1.5f, false);
        this.lastPlayedSplash = 0;
    }

    @Override
    public boolean multiHit() {
        return true;
    }

    @Override
    public EntityLivingBase getController() {
        return this.getOwner();
    }

    @Override
    protected double getVelocityMultiplier() {
        return this.velocityMultiplier;
    }

    @Override
    public boolean isProjectile() {
        return true;
    }

    @Override
    public boolean shouldDissipate() {
        return true;
    }

    @Override
    public boolean isPiercing() {
        return true;
    }

    @Override
    public float getHealth() {
        return 0.0f;
    }

    @Override
    public void setHealth(float health) {
    }

    @Override
    public float getMaxHealth() {
        return 0.0f;
    }

    @Override
    public void setMaxHealth(float maxHealth) {
    }

    @Override
    protected double getControlPointTeleportDistanceSq() {
        return this.getControlPointMaxDistanceSq() * (double)this.getAmountOfControlPoints();
    }

    @Override
    protected double getControlPointMaxDistanceSq() {
        return 5.0;
    }

    @Override
    public int getAmountOfControlPoints() {
        return 8;
    }

    @Override
    public boolean shouldExplode() {
        return true;
    }

    @Override
    public boolean setVelocity() {
        return false;
    }

    @Override
    public BendingStyle getElement() {
        return new Waterbending();
    }

    static class WaterControlPoint
    extends ControlPoint {
        private WaterControlPoint(EntityWaterCannon arc, float size, double x, double y, double z) {
            super(arc, size, x, y, z);
        }
    }
}

