/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BattlePerformanceScore;
import com.crowsofwar.avatar.config.ConfigSkills;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.util.damageutils.AvatarDamageSource;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityWave
extends AvatarEntity {
    private static final DataParameter<Float> SYNC_SIZE = EntityDataManager.func_187226_a(EntityWave.class, (DataSerializer)DataSerializers.field_187193_c);
    private float damageMult;
    private boolean createExplosion;
    private float Size = 2.0f;
    private Vector initialSpeed;
    private int groundTime;

    public EntityWave(World world) {
        super(world);
        this.func_70105_a(this.Size, this.Size * 0.75f);
        this.damageMult = 1.0f;
        this.putsOutFires = true;
        this.initialSpeed = this.velocity();
        this.groundTime = 0;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SYNC_SIZE, (Object)Float.valueOf(this.Size));
    }

    public void setDamageMultiplier(float damageMult) {
        this.damageMult = damageMult;
    }

    public float getWaveSize() {
        return ((Float)this.field_70180_af.func_187225_a(SYNC_SIZE)).floatValue();
    }

    public void setWaveSize(float size) {
        this.field_70180_af.func_187227_b(SYNC_SIZE, (Object)Float.valueOf(size));
    }

    @Override
    public boolean func_70067_L() {
        return false;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70145_X = true;
        if (this.velocity() == Vector.ZERO || this.velocity().magnitude() < this.initialSpeed.magnitude() / 100.0) {
            this.func_70106_y();
        }
        this.func_70105_a(this.getWaveSize(), this.getWaveSize() * 0.75f);
        if (!this.field_70171_ac) {
            this.setVelocity(this.velocity().dividedBy(40.0));
            ++this.groundTime;
        }
        EntityLivingBase owner = this.getOwner();
        Vector move = this.velocity().dividedBy(20.0);
        Vector newPos = this.position().plus(move);
        this.func_70107_b(newPos.x(), newPos.y(), newPos.z());
        if (!this.field_70170_p.field_72995_K) {
            WorldServer World2 = (WorldServer)this.field_70170_p;
            World2.func_175739_a(EnumParticleTypes.WATER_WAKE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 300, (double)this.getWaveSize() / 2.5, (double)(this.getWaveSize() / 5.0f), (double)this.getWaveSize() / 2.5, 0.0, new int[0]);
            World2.func_175739_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t, this.field_70163_u + (double)(this.Size * 0.75f), this.field_70161_v, 1, (double)(this.getWaveSize() / 5.0f), (double)(this.getWaveSize() / 20.0f), (double)(this.getWaveSize() / 5.0f), 0.0, new int[0]);
            World2.func_175739_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t, this.field_70163_u + (double)(this.Size * 0.75f), this.field_70161_v, 30, (double)(this.getWaveSize() / 5.0f), 0.0, (double)(this.getWaveSize() / 5.0f), 0.0, new int[0]);
            List collided = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), entity -> entity != owner);
            for (Entity entity2 : collided) {
                if (!this.canCollideWith(entity2)) continue;
                Vector motion = this.velocity().dividedBy(20.0).times(ConfigStats.STATS_CONFIG.waveSettings.push);
                motion = motion.withY((double)this.Size * 0.75 / 10.0);
                entity2.func_70024_g(motion.x(), motion.y(), motion.z());
                if (!this.canDamageEntity(entity2)) continue;
                if (entity2.func_70097_a(AvatarDamageSource.causeWaveDamage(entity2, (Entity)owner), ConfigStats.STATS_CONFIG.waveSettings.damage * this.damageMult)) {
                    AbilityData.get(owner, this.getAbility().getName()).addXp(ConfigSkills.SKILLS_CONFIG.waveHit);
                    BattlePerformanceScore.addLargeScore(this.getOwner());
                }
                if (!this.createExplosion) continue;
                this.field_70170_p.func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2.0f, false);
            }
        }
        if (this.groundTime >= 30) {
            this.func_70106_y();
        }
        if (this.field_70173_aa >= 250) {
            this.func_70106_y();
        }
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        if (entity instanceof AvatarEntity) {
            ((AvatarEntity)entity).onMajorWaterContact();
        }
    }

    @Override
    public boolean onCollideWithSolid() {
        return false;
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public void setCreateExplosion(boolean createExplosion) {
        this.createExplosion = createExplosion;
    }
}

