/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity;

import com.crowsofwar.avatar.bending.bending.BattlePerformanceScore;
import com.crowsofwar.avatar.client.particle.AvatarParticles;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.mob.EntityBender;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.AvatarUtils;
import com.crowsofwar.avatar.util.damageutils.AvatarDamageSource;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public interface IOffensiveEntity {
    default public void Explode(World world, AvatarEntity entity, EntityLivingBase owner) {
        if (owner != null) {
            this.spawnExplosionParticles(world, AvatarEntityUtils.getMiddleOfEntity(entity));
            this.playExplosionSounds(entity);
            List collided = world.func_175674_a((Entity)entity, entity.func_174813_aQ().func_72314_b(this.getExplosionHitboxGrowth(), this.getExplosionHitboxGrowth(), this.getExplosionHitboxGrowth()), entity1 -> entity1 != entity.getOwner());
            if (!collided.isEmpty()) {
                for (Entity entity12 : collided) {
                    if (entity.getOwner() == null || entity12 == entity.getOwner() || entity12 == entity || world.field_72995_K) continue;
                    this.attackEntity(entity, entity12, false, this.getKnockback());
                    double dist = this.getExplosionHitboxGrowth() - (double)entity12.func_70032_d((Entity)entity) > 1.0 ? this.getExplosionHitboxGrowth() - (double)entity12.func_70032_d((Entity)entity) : 1.0;
                    Vec3d velocity = entity12.func_174791_d().func_178788_d(entity.func_174791_d());
                    velocity = velocity.func_186678_a((double)0.025f).func_186678_a(dist).func_72441_c(0.0, this.getExplosionHitboxGrowth() / 50.0, 0.0);
                    double x = velocity.field_72450_a;
                    double y = velocity.field_72448_b > 0.0 ? velocity.field_72449_c : (double)0.15f;
                    double z = velocity.field_72449_c;
                    this.attackEntity(entity, entity12, true, new Vec3d(x *= this.getExplosionKnockbackMult().field_72450_a, y *= this.getExplosionKnockbackMult().field_72448_b, z *= this.getExplosionKnockbackMult().field_72449_c));
                }
            }
            entity.func_70106_y();
        }
    }

    default public void applyPiercingCollision(AvatarEntity entity) {
        List collided = entity.field_70170_p.func_175674_a((Entity)entity, this.getExpandedHitbox(entity), entity1 -> entity1 != entity.getOwner() && entity1 != entity && entity.canCollideWith((Entity)entity1));
        if (!collided.isEmpty()) {
            for (Entity hit : collided) {
                if (entity.getOwner() == null || hit == entity.getOwner() || hit == null || !entity.canCollideWith(hit)) continue;
                this.attackEntity(entity, hit, false, this.getKnockback());
                this.playPiercingSounds(entity);
                this.spawnPiercingParticles(entity.field_70170_p, AvatarEntityUtils.getMiddleOfEntity(entity));
            }
        }
    }

    default public void Dissipate(AvatarEntity entity) {
        if (entity.getOwner() != null) {
            this.spawnDissipateParticles(entity.field_70170_p, AvatarEntityUtils.getMiddleOfEntity(entity));
            this.playDissipateSounds(entity);
        }
        entity.func_70106_y();
    }

    default public void attackEntity(AvatarEntity attacker, Entity hit, boolean explosionDamage, Vec3d vel) {
        vel = new Vec3d(vel.field_72450_a * this.getKnockbackMult().field_72450_a, vel.field_72448_b * this.getKnockbackMult().field_72448_b, vel.field_72449_c * this.getKnockbackMult().field_72449_c);
        if (attacker.getOwner() != null && hit != null && hit != attacker && !attacker.field_70170_p.field_72995_K) {
            AbilityData data = AbilityData.get(attacker.getOwner(), attacker.getAbility().getName());
            if ((explosionDamage ? this.getAoeDamage() > 0.0f : this.getDamage() > 0.0f) && attacker.canDamageEntity(hit)) {
                boolean ds = hit.func_70097_a(this.getDamageSource(hit, attacker.getOwner()), explosionDamage ? this.getAoeDamage() : this.getDamage());
                if (data != null) {
                    if (!ds && hit instanceof EntityDragon) {
                        BendingData bendingData;
                        ((EntityDragon)hit).func_70965_a(((EntityDragon)hit).field_70987_i, this.getDamageSource(hit, attacker.getOwner()), explosionDamage ? this.getAoeDamage() : this.getDamage());
                        BattlePerformanceScore.addScore(attacker.getOwner(), this.getPerformanceAmount());
                        data.addXp(this.getXpPerHit());
                        if (!(attacker.getOwner() == null || (bendingData = BendingData.getFromEntity(attacker.getOwner())) == null || bendingData.chi() == null || !(attacker.getOwner() instanceof EntityBender) && attacker.getOwner() instanceof EntityPlayer && ((EntityPlayer)attacker.getOwner()).func_184812_l_())) {
                            bendingData.chi().changeAvailableChi(this.getChiHit());
                        }
                    } else if (ds) {
                        BendingData bendingData;
                        BattlePerformanceScore.addScore(attacker.getOwner(), this.getPerformanceAmount());
                        data.addXp(this.getXpPerHit());
                        hit.func_70015_d(this.getFireTime());
                        if (this.setVelocity()) {
                            AvatarUtils.setVelocity(hit, vel);
                        } else {
                            hit.func_70024_g(vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
                        }
                        AvatarUtils.afterVelocityAdded(hit);
                        if (!(attacker.getOwner() == null || (bendingData = BendingData.getFromEntity(attacker.getOwner())) == null || bendingData.chi() == null || !(attacker.getOwner() instanceof EntityBender) && attacker.getOwner() instanceof EntityPlayer && ((EntityPlayer)attacker.getOwner()).func_184812_l_())) {
                            bendingData.chi().changeAvailableChi(this.getChiHit());
                        }
                    }
                }
            }
            if (data != null && !attacker.canDamageEntity(hit) && attacker.canCollideWith(hit) || attacker instanceof IOffensiveEntity && ((IOffensiveEntity)((Object)attacker)).multiHit()) {
                BendingData bendingData;
                if (hit instanceof EntityItem) {
                    vel = vel.func_186678_a(0.05);
                }
                if (!(hit instanceof AvatarEntity)) {
                    BattlePerformanceScore.addScore(attacker.getOwner(), this.getPerformanceAmount());
                }
                if (!(attacker instanceof IOffensiveEntity) || !((IOffensiveEntity)((Object)attacker)).multiHit()) {
                    data.addXp(this.getXpPerHit());
                }
                hit.func_70015_d(this.getFireTime());
                if (hit instanceof EntityOffensive) {
                    ((EntityOffensive)hit).applyElementalContact(attacker);
                }
                if (this.setVelocity()) {
                    AvatarUtils.setVelocity(hit, vel);
                } else if (hit instanceof EntityArrow || hit instanceof EntityThrowable) {
                    hit.func_70024_g(vel.field_72450_a / 5.0, vel.field_72448_b / 2.5, vel.field_72449_c / 5.0);
                } else {
                    hit.func_70024_g(vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
                }
                AvatarUtils.afterVelocityAdded(hit);
                if (!(attacker.getOwner() == null || (bendingData = BendingData.getFromEntity(attacker.getOwner())) == null || bendingData.chi() == null || !(attacker.getOwner() instanceof EntityBender) && attacker.getOwner() instanceof EntityPlayer && ((EntityPlayer)attacker.getOwner()).func_184812_l_())) {
                    bendingData.chi().changeAvailableChi(this.getChiHit());
                }
            }
        }
    }

    default public float getAoeDamage() {
        return 1.0f;
    }

    default public float getDamage() {
        return 3.0f;
    }

    default public float getXpPerHit() {
        return 3.0f;
    }

    default public float getChiHit() {
        return 1.0f;
    }

    default public float getPush() {
        return 1.0f;
    }

    default public Vec3d getKnockback() {
        return new Vec3d(this.getKnockbackMult().field_72450_a, this.getKnockbackMult().field_72448_b, this.getKnockbackMult().field_72449_c);
    }

    default public Vec3d getKnockback(Entity target) {
        return new Vec3d(this.getKnockbackMult().field_72450_a, this.getKnockbackMult().field_72448_b, this.getKnockbackMult().field_72449_c);
    }

    default public Vec3d getKnockbackMult() {
        return new Vec3d((double)this.getPush(), (double)(this.getPush() / 2.0f), (double)this.getPush());
    }

    default public Vec3d getExplosionKnockbackMult() {
        return new Vec3d(0.5, 0.5, 0.5);
    }

    default public void spawnExplosionParticles(World world, Vec3d pos) {
        if (world instanceof WorldServer && !world.field_72995_K) {
            WorldServer World2 = (WorldServer)world;
            if (this.getParticle() != null) {
                World2.func_175739_a(this.getParticle(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, this.getNumberofParticles(), 0.0, 0.0, 0.0, this.getParticleSpeed(), new int[0]);
            }
        }
    }

    default public void spawnDissipateParticles(World world, Vec3d pos) {
        if (world instanceof WorldServer && !world.field_72995_K) {
            WorldServer World2 = (WorldServer)world;
            if (this.getParticle() != null) {
                World2.func_175739_a(this.getParticle(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, this.getNumberofParticles(), 0.0, 0.0, 0.0, this.getParticleSpeed(), new int[0]);
            }
        }
    }

    default public void spawnPiercingParticles(World world, Vec3d pos) {
        if (world instanceof WorldServer && !world.field_72995_K) {
            WorldServer World2 = (WorldServer)world;
            if (this.getParticle() != null) {
                World2.func_175739_a(this.getParticle(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, this.getNumberofParticles(), 0.0, 0.0, 0.0, this.getParticleSpeed(), new int[0]);
            }
        }
    }

    default public void playExplosionSounds(Entity entity) {
        if (this.getSounds() != null) {
            for (int i = 0; i < this.getSounds().length; ++i) {
                entity.field_70170_p.func_184133_a(null, new BlockPos(entity), this.getSounds()[i], entity.func_184176_by(), this.getVolume(), this.getPitch());
            }
        }
    }

    default public void playPiercingSounds(Entity entity) {
        if (this.getSounds() != null) {
            for (int i = 0; i < this.getSounds().length; ++i) {
                entity.field_70170_p.func_184133_a(null, new BlockPos(entity), this.getSounds()[i], entity.func_184176_by(), this.getVolume(), this.getPitch());
            }
        }
    }

    default public void playDissipateSounds(Entity entity) {
        if (this.getSounds() != null) {
            for (int i = 0; i < this.getSounds().length; ++i) {
                entity.field_70170_p.func_184133_a(null, new BlockPos(entity), this.getSounds()[i], entity.func_184176_by(), this.getVolume(), this.getPitch());
            }
        }
    }

    default public EnumParticleTypes getParticle() {
        return AvatarParticles.getParticleFlames();
    }

    default public int getNumberofParticles() {
        return 50;
    }

    default public double getParticleSpeed() {
        return 0.02;
    }

    default public int getPerformanceAmount() {
        return 10;
    }

    @Nullable
    default public SoundEvent[] getSounds() {
        return new SoundEvent[]{SoundEvents.field_187557_bK};
    }

    default public float getVolume() {
        return 1.0f + (float)AvatarUtils.getRandomNumberInRange(1, 100) / 500.0f;
    }

    default public float getPitch() {
        return 1.0f + (float)AvatarUtils.getRandomNumberInRange(1, 100) / 500.0f;
    }

    default public void setDamageSource(String source) {
    }

    default public DamageSource getDamageSource(Entity source, EntityLivingBase owner) {
        return AvatarDamageSource.causeFireDamage(source, (Entity)owner);
    }

    default public double getExpandedHitboxWidth() {
        return 0.25;
    }

    default public double getExpandedHitboxHeight() {
        return 0.25;
    }

    default public int getFireTime() {
        return 0;
    }

    default public boolean isPiercing() {
        return false;
    }

    default public boolean isShockwave() {
        return false;
    }

    default public boolean shouldDissipate() {
        return false;
    }

    default public boolean shouldExplode() {
        return true;
    }

    default public boolean multiHit() {
        return false;
    }

    default public AxisAlignedBB getExpandedHitbox(AvatarEntity entity) {
        return entity.func_174813_aQ().func_72314_b(this.getExpandedHitboxWidth(), this.getExpandedHitboxHeight(), this.getExpandedHitboxWidth());
    }

    default public double getExplosionHitboxGrowth() {
        return 1.0;
    }

    default public boolean setVelocity() {
        return false;
    }

    default public void applyElementalContact(AvatarEntity entity) {
    }
}

