/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.ai;

import com.crowsofwar.avatar.config.ConfigMobs;
import com.crowsofwar.avatar.entity.data.AnimalCondition;
import com.crowsofwar.avatar.entity.data.BisonSpawnData;
import com.crowsofwar.avatar.entity.mob.EntitySkyBison;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class EntityAiBisonBreeding
extends EntityAIBase {
    private final EntitySkyBison bison;

    public EntityAiBisonBreeding(EntitySkyBison bison) {
        this.bison = bison;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        AnimalCondition cond = this.bison.getCondition();
        return cond.isReadyToBreed() && this.getNearbyBison() > 0;
    }

    public void func_75249_e() {
    }

    public boolean func_75253_b() {
        if (!this.func_75250_a()) {
            return false;
        }
        double range = 100.0;
        Vector pos = Vector.getEntityPos((Entity)this.bison);
        Vector min = pos.minus(range / 2.0, range / 2.0, range / 2.0);
        Vector max = pos.plus(range / 2.0, range / 2.0, range / 2.0);
        AxisAlignedBB aabb = new AxisAlignedBB(min.x(), min.y(), min.z(), max.x(), max.y(), max.z());
        List mates = this.bison.field_70170_p.func_175647_a(EntitySkyBison.class, aabb, b -> b != this.bison && b.getCondition().isReadyToBreed());
        if (!mates.isEmpty()) {
            EntitySkyBison mate = (EntitySkyBison)((Object)mates.get(0));
            if (this.getNearbyBison() < 15) {
                this.bison.func_70605_aq().func_75642_a(mate.field_70165_t, mate.field_70163_u, mate.field_70161_v, 1.0);
                if (this.bison.func_70068_e((Entity)mate) <= 7.0) {
                    this.spawnBaby(mate);
                    this.bison.getCondition().setBreedTimer(this.generateBreedTimer());
                    mate.getCondition().setBreedTimer(this.generateBreedTimer());
                    return true;
                }
            }
        }
        return true;
    }

    private void spawnBaby(EntitySkyBison mate) {
        World world = this.bison.field_70170_p;
        AnimalCondition cond = this.bison.getCondition();
        EntitySkyBison child = new EntitySkyBison(world);
        if (child != null) {
            child.getCondition().setAge(0);
            child.func_70012_b(this.bison.field_70165_t, this.bison.field_70163_u, this.bison.field_70161_v, 0.0f, 0.0f);
            child.func_180482_a(world.func_175649_E(this.bison.func_180425_c()), new BisonSpawnData(true));
            world.func_72838_d((Entity)child);
            Random random = this.bison.func_70681_au();
            for (int i = 0; i < 7; ++i) {
                double mx = random.nextGaussian() * 0.02;
                double my = random.nextGaussian() * 0.02;
                double mz = random.nextGaussian() * 0.02;
                double dx = random.nextDouble() * (double)this.bison.field_70130_N * 2.0 - (double)this.bison.field_70130_N;
                double dy = 0.5 + random.nextDouble() * (double)this.bison.field_70131_O;
                double dz = random.nextDouble() * (double)this.bison.field_70130_N * 2.0 - (double)this.bison.field_70130_N;
                world.func_175688_a(EnumParticleTypes.HEART, this.bison.field_70165_t + dx, this.bison.field_70163_u + dy, this.bison.field_70161_v + dz, mx, my, mz, new int[0]);
            }
            if (world.func_82736_K().func_82766_b("doMobLoot")) {
                world.func_72838_d((Entity)new EntityXPOrb(world, this.bison.field_70165_t, this.bison.field_70163_u, this.bison.field_70161_v, random.nextInt(7) + 1));
            }
        }
    }

    private int generateBreedTimer() {
        Random random = this.bison.func_70681_au();
        float min = ConfigMobs.MOBS_CONFIG.bisonSettings.bisonBreedMinMinutes;
        float max = ConfigMobs.MOBS_CONFIG.bisonSettings.bisonBreedMaxMinutes;
        float minutes = min + random.nextFloat() * (max - min);
        return (int)(minutes * 1200.0f);
    }

    private int getNearbyBison() {
        World world = this.bison.field_70170_p;
        AxisAlignedBB aabb = new AxisAlignedBB(this.bison.field_70165_t - 32.0, 0.0, this.bison.field_70161_v - 32.0, this.bison.field_70165_t + 32.0, 255.0, this.bison.field_70161_v + 32.0);
        return world.func_175647_a(EntitySkyBison.class, aabb, b -> b != this.bison).size();
    }
}

