/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.ai;

import com.crowsofwar.avatar.entity.mob.EntitySkyBison;
import net.minecraft.block.Block;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityAiBisonEatGrass
extends EntityAIBase {
    private final EntitySkyBison bison;
    private int eatGrassTime;

    public EntityAiBisonEatGrass(EntitySkyBison bison) {
        this.bison = bison;
        this.eatGrassTime = -1;
        this.func_75248_a(0);
    }

    public boolean isEatingGrass() {
        return this.eatGrassTime > -1;
    }

    public int getEatGrassTime() {
        return this.eatGrassTime;
    }

    public boolean func_75250_a() {
        Block standingOn = this.bison.field_70170_p.func_180495_p(this.bison.func_180425_c().func_177977_b()).func_177230_c();
        return this.bison.wantsGrass() && this.isOnGround() && (!this.bison.isSitting() || standingOn == Blocks.field_150349_c);
    }

    public void func_75249_e() {
        this.func_75253_b();
    }

    public boolean func_75253_b() {
        boolean keepExecuting = !this.bison.isFull() && this.isOnGround();
        World world = this.bison.field_70170_p;
        EntityMoveHelper mh = this.bison.func_70605_aq();
        if (!this.isEatingGrass()) {
            this.eatGrassTime = 0;
        }
        this.tryEatGrass();
        if (!this.bison.isSitting()) {
            this.bison.func_191986_a(0.0f, 5.0f, 0.0f);
        }
        this.addRotations(0.0f, 4.0f);
        if (this.eatGrassTime > 80) {
            keepExecuting = false;
        }
        if (!keepExecuting) {
            this.eatGrassTime = -1;
        }
        return keepExecuting;
    }

    private void tryEatGrass() {
        ++this.eatGrassTime;
        if (this.eatGrassTime % 30 == 29) {
            BlockPos downPos = this.bison.func_180425_c().func_177977_b();
            World world = this.bison.field_70170_p;
            boolean mobGriefing = world.func_82736_K().func_82766_b("mobGriefing");
            BlockPos ediblePos = null;
            Block block = world.func_180495_p(downPos).func_177230_c();
            if (block == Blocks.field_150349_c) {
                ediblePos = downPos;
            } else {
                block = world.func_180495_p(downPos.func_177984_a()).func_177230_c();
                if (block == Blocks.field_150329_H || block == Blocks.field_150327_N || block == Blocks.field_150328_O) {
                    ediblePos = downPos.func_177984_a();
                }
            }
            if (ediblePos != null) {
                if (mobGriefing) {
                    world.func_175718_b(2001, ediblePos, Block.func_149682_b((Block)Blocks.field_150349_c));
                    if (block == Blocks.field_150349_c) {
                        world.func_180501_a(ediblePos, Blocks.field_150346_d.func_176223_P(), 2);
                    }
                }
                this.bison.func_70615_aA();
            } else {
                this.addRotations(100.0f, 160.0f);
            }
            if (this.bison.isSitting()) {
                this.eatGrassTime = 81;
            }
        }
    }

    private boolean isSolidBlock(BlockPos pos) {
        World world = this.bison.field_70170_p;
        return world.func_175677_d(pos, false);
    }

    private boolean isOnGround() {
        BlockPos downPos = this.bison.func_180425_c().func_177977_b();
        return this.isSolidBlock(downPos);
    }

    private void addRotations(float min, float max) {
        int sign = this.bison.func_70681_au().nextBoolean() ? 1 : -1;
        this.bison.field_70177_z += (float)sign * (min + this.bison.func_70681_au().nextFloat() * (max - min));
        this.bison.field_70177_z %= 360.0f;
    }
}

