/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.ai;

import com.crowsofwar.avatar.entity.mob.EntitySkyBison;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityAiBisonLand
extends EntityAIBase {
    private final EntitySkyBison bison;
    private int lastLandAttempt;

    public EntityAiBisonLand(EntitySkyBison bison) {
        this.bison = bison;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        return this.bison.wantsGrass() && this.bison.field_70173_aa - this.lastLandAttempt > 100;
    }

    public void func_75249_e() {
        Vector landing;
        boolean isValidPosition;
        this.lastLandAttempt = this.bison.field_70173_aa;
        World world = this.bison.field_70170_p;
        int tries = 0;
        do {
            landing = this.findLandingPoint().plusY(1.0);
            Block block = world.func_180495_p(landing.toBlockPos().func_177977_b()).func_177230_c();
            boolean bl = isValidPosition = (block == Blocks.field_150349_c || block == Blocks.field_150329_H) && this.canFit(landing) && this.canGetTo(landing);
        } while (!isValidPosition && ++tries < 5);
        if (isValidPosition) {
            landing = landing.plusY(1.0);
            this.bison.func_70605_aq().func_75642_a(landing.x(), landing.y() - 1.0, landing.z(), 1.0);
        }
    }

    public boolean func_75253_b() {
        EntityMoveHelper mh = this.bison.func_70605_aq();
        if (this.bison.func_70092_e(mh.func_179917_d(), mh.func_179919_e(), mh.func_179918_f()) <= 5.0) {
            this.bison.func_70605_aq().field_188491_h = EntityMoveHelper.Action.WAIT;
        }
        return !this.bison.isFull() && this.bison.isEatingGrass();
    }

    private Vector findLandingPoint() {
        int y;
        double maxDist = 2.0;
        double x = this.bison.field_70165_t + (this.bison.func_70681_au().nextDouble() * 2.0 - 1.0) * maxDist;
        double z = this.bison.field_70161_v + (this.bison.func_70681_au().nextDouble() * 2.0 - 1.0) * maxDist;
        for (y = (int)this.bison.field_70163_u; !this.isSolidBlock(new BlockPos(x, (double)y, z)) && y >= 0; --y) {
        }
        return new Vector(x, y, z);
    }

    private boolean canFit(Vector pos) {
        double minX = pos.x() - (double)(this.bison.field_70130_N / 2.0f);
        double maxX = pos.x() + (double)(this.bison.field_70130_N / 2.0f);
        double minY = pos.y();
        double maxY = pos.y() + (double)this.bison.field_70131_O;
        double minZ = pos.z() - (double)(this.bison.field_70130_N / 2.0f);
        double maxZ = pos.z() + (double)(this.bison.field_70130_N / 2.0f);
        int x = MathHelper.func_76128_c((double)minX);
        while ((double)x <= maxX) {
            int y = MathHelper.func_76128_c((double)minY);
            while ((double)y <= maxY) {
                int z = MathHelper.func_76128_c((double)minZ);
                while ((double)z <= maxZ) {
                    if (this.isSolidBlock(new BlockPos(x, y, z))) {
                        return false;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return true;
    }

    private boolean canGetTo(Vector target) {
        double range;
        Vector direction;
        Vector current = Vector.getEntityPos((Entity)this.bison);
        Raytrace.Result raytrace = Raytrace.raytrace(this.bison.field_70170_p, current, direction = target.minus(current).normalize(), (range = current.dist(target)) + 1.0, false);
        Vector hitPos = raytrace.getPosPrecise() == null ? null : raytrace.getPosPrecise().plusY(1.0);
        return hitPos == null || hitPos.sqrDist(target) <= 2.0;
    }

    private boolean isSolidBlock(BlockPos pos) {
        World world = this.bison.field_70170_p;
        return world.func_175677_d(pos, false);
    }
}

