/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.ai;

import com.crowsofwar.avatar.config.ConfigMobs;
import com.crowsofwar.avatar.entity.mob.EntitySkyBison;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class EntityAiBisonTempt
extends EntityAIBase {
    private final EntitySkyBison bison;
    private final double maxDistSq;
    private EntityPlayer following;

    public EntityAiBisonTempt(EntitySkyBison bison, double maxDist) {
        this.bison = bison;
        this.maxDistSq = maxDist * maxDist;
        this.following = null;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.bison.getCondition().getFoodPoints() >= 25.0f) {
            return false;
        }
        List players = this.bison.field_70170_p.func_175644_a(EntityPlayer.class, player -> {
            if (this.bison.func_70068_e((Entity)player) > this.maxDistSq) {
                return false;
            }
            return this.isHoldingFood((EntityPlayer)player);
        });
        players.sort((p1, p2) -> {
            double d2;
            double d1 = this.bison.func_70068_e((Entity)p1);
            return d1 < (d2 = this.bison.func_70068_e((Entity)p2)) ? -1 : (d1 > d2 ? 1 : 0);
        });
        if (!players.isEmpty()) {
            this.following = (EntityPlayer)players.get(0);
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.bison.func_70605_aq().func_75642_a(this.following.field_70165_t, this.following.field_70163_u + (double)this.following.eyeHeight - (double)this.bison.func_70047_e(), this.following.field_70161_v, 1.0);
    }

    public boolean func_75253_b() {
        if (!this.following.field_70128_L && this.bison.func_70068_e((Entity)this.following) <= this.maxDistSq && this.isHoldingFood(this.following)) {
            this.bison.func_70605_aq().func_75642_a(this.following.field_70165_t, this.following.field_70163_u + (double)this.following.eyeHeight - (double)this.bison.func_70047_e(), this.following.field_70161_v, 1.0);
            return true;
        }
        this.following = null;
        this.bison.func_70605_aq().field_188491_h = EntityMoveHelper.Action.WAIT;
        return false;
    }

    private boolean isHoldingFood(EntityPlayer player) {
        for (EnumHand hand : EnumHand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (stack == ItemStack.field_190927_a || !ConfigMobs.MOBS_CONFIG.isBisonFood(stack.func_77973_b())) continue;
            return true;
        }
        return false;
    }
}

