/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.data;

import com.crowsofwar.avatar.config.ConfigMobs;
import net.minecraft.entity.EntityCreature;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;

public class AnimalCondition {
    private final DataParameter<Float> syncFood;
    private final DataParameter<Integer> syncDomestication;
    private final DataParameter<Integer> syncAge;
    private final EntityCreature animal;
    private final float maxFoodPoints;
    private final float foodRegenPoints;
    private float lastDistance;
    private int breedTimer;
    private boolean sterile;

    public AnimalCondition(EntityCreature animal, float maxFoodPoints, float foodRegenPoints, DataParameter<Float> syncFood, DataParameter<Integer> syncDomestication, DataParameter<Integer> syncAge) {
        this.animal = animal;
        this.syncDomestication = syncDomestication;
        this.syncFood = syncFood;
        this.syncAge = syncAge;
        this.maxFoodPoints = maxFoodPoints;
        this.foodRegenPoints = foodRegenPoints;
        this.lastDistance = animal.field_70140_Q;
        this.breedTimer = -1;
        this.sterile = true;
    }

    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74776_a("FoodPoints", this.getFoodPoints());
        nbt.func_74768_a("Domestication", this.getDomestication());
        nbt.func_74768_a("Age", this.getAge());
        nbt.func_74768_a("BreedTimer", this.getBreedTimer());
        nbt.func_74757_a("Sterile", this.isSterile());
    }

    public void readFromNbt(NBTTagCompound nbt) {
        this.setFoodPoints(nbt.func_74760_g("FoodPoints"));
        this.setDomestication(nbt.func_74762_e("Domestication"));
        this.setAge(nbt.func_74762_e("Age"));
        this.setSterile(nbt.func_74767_n("Sterile"));
        this.setBreedTimer(nbt.func_74762_e("BreedTimer"));
    }

    public void onUpdate() {
        float distance = this.animal.field_70140_Q;
        if (Float.isNaN(distance)) {
            distance = this.lastDistance;
        }
        float diff = distance - this.lastDistance;
        this.addHunger(diff * 0.05f);
        this.lastDistance = distance;
        if (!this.animal.field_70170_p.field_72995_K) {
            boolean correctTime;
            boolean enoughFood = this.getFoodPoints() >= this.foodRegenPoints;
            boolean bl = correctTime = this.animal.field_70173_aa % 40 == 0;
            if (enoughFood && correctTime) {
                this.animal.func_70691_i(1.0f);
                this.addHunger(1.0f);
            }
            this.addAge(1);
            if (!this.isSterile() && this.isAdult()) {
                this.addBreedTimer(-1);
            }
        }
    }

    public int getDomestication() {
        return (Integer)this.animal.func_184212_Q().func_187225_a(this.syncDomestication);
    }

    public void setDomestication(int domestication) {
        if (domestication < 0) {
            domestication = 0;
        }
        if (domestication > 1000) {
            domestication = 1000;
        }
        this.animal.func_184212_Q().func_187227_b(this.syncDomestication, (Object)domestication);
    }

    public void addDomestication(int domestication) {
        this.setDomestication(this.getDomestication() + domestication);
    }

    public boolean canHaveOwner() {
        return this.getDomestication() >= ConfigMobs.MOBS_CONFIG.bisonSettings.bisonOwnableTameness;
    }

    public int getMaxRiders() {
        if (this.getAgeDays() >= (float)((int)((float)this.getAdultAge() / this.getAgeDays()))) {
            return 1 + (int)Math.min(this.getAgeDays() - (float)((int)((float)this.getAdultAge() / this.getAgeDays())), (float)this.getAdultAge());
        }
        if (this.canHaveOwner()) {
            double pctToTame = 1.0 * (double)(this.getDomestication() - ConfigMobs.MOBS_CONFIG.bisonSettings.bisonOwnableTameness) / (double)(1000 - ConfigMobs.MOBS_CONFIG.bisonSettings.bisonOwnableTameness);
            return 1 + (int)(pctToTame * 4.0);
        }
        if (this.getDomestication() >= ConfigMobs.MOBS_CONFIG.bisonSettings.bisonRiderTameness) {
            return 1;
        }
        return 0;
    }

    public boolean isFullyDomesticated() {
        return this.getDomestication() == 1000;
    }

    public float getFoodPoints() {
        return ((Float)this.animal.func_184212_Q().func_187225_a(this.syncFood)).floatValue();
    }

    public void setFoodPoints(float points) {
        this.animal.func_184212_Q().func_187227_b(this.syncFood, (Object)Float.valueOf(points));
    }

    public void addHunger(float hunger) {
        this.addFood(-hunger);
    }

    public void addFood(float food) {
        float foodPoints = this.getFoodPoints();
        if ((foodPoints += food) < 0.0f) {
            foodPoints = 0.0f;
        }
        if (foodPoints > this.maxFoodPoints) {
            foodPoints = this.maxFoodPoints;
        }
        this.setFoodPoints(foodPoints);
    }

    public float getSpeedMultiplier() {
        return 0.6f + 0.4f * this.getFoodPoints() / this.maxFoodPoints;
    }

    public int getAge() {
        return (Integer)this.animal.func_184212_Q().func_187225_a(this.syncAge);
    }

    public void setAge(int age) {
        if (age < 0) {
            age = 0;
        }
        this.animal.func_184212_Q().func_187227_b(this.syncAge, (Object)age);
    }

    public void addAge(int age) {
        this.setAge(this.getAge() + age);
    }

    public float getAgeDays() {
        return (float)this.getAge() / 24000.0f;
    }

    public void setAgeDays(float days) {
        this.setAge((int)(days * 24000.0f));
    }

    public float getSizeMultiplier() {
        float adultSize = this.getAgeDays() < 5.0f ? this.getAgeDays() / (float)this.getAdultAge() : 1.666777f;
        return this.isAdult() ? adultSize : 0.1f + this.getAgeDays() / (float)this.getAdultAge() * 0.9f;
    }

    public boolean isAdult() {
        return this.getAgeDays() >= (float)this.getAdultAge();
    }

    public int getAdultAge() {
        return 7;
    }

    public int getBreedTimer() {
        return this.sterile ? -1 : this.breedTimer;
    }

    public void setBreedTimer(int breedTimer) {
        if (!this.isSterile()) {
            if (breedTimer < 0) {
                breedTimer = 0;
            }
            this.breedTimer = breedTimer;
        }
    }

    public void addBreedTimer(int amount) {
        this.setBreedTimer(this.getBreedTimer() + amount);
    }

    public boolean isReadyToBreed() {
        return this.isAdult() && this.getBreedTimer() == 0;
    }

    public boolean isSterile() {
        return this.sterile;
    }

    public void setSterile(boolean sterile) {
        this.sterile = sterile;
    }
}

