/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.data;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.entity.data.EarthspikesBehavior;
import com.crowsofwar.avatar.entity.data.FireballBehavior;
import com.crowsofwar.avatar.entity.data.FloatingBlockBehavior;
import com.crowsofwar.avatar.entity.data.LightCylinderBehaviour;
import com.crowsofwar.avatar.entity.data.LightOrbBehavior;
import com.crowsofwar.avatar.entity.data.LightningSpearBehavior;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.entity.data.ShockwaveBehaviour;
import com.crowsofwar.avatar.entity.data.WallBehavior;
import com.crowsofwar.avatar.entity.data.WaterArcBehavior;
import com.crowsofwar.avatar.entity.data.WaterBubbleBehavior;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;

public abstract class Behavior<E extends Entity> {
    private static int nextId = 1;
    private static Map<Integer, Class<? extends Behavior>> behaviorIdToClass;
    private static Map<Class<? extends Behavior>, Integer> classToBehaviorId;

    public static void registerBehaviours() {
        FloatingBlockBehavior.register();
        WaterArcBehavior.register();
        WaterBubbleBehavior.register();
        WallBehavior.register();
        EarthspikesBehavior.register();
        FireballBehavior.register();
        LightningSpearBehavior.register();
        LightOrbBehavior.register();
        LightCylinderBehaviour.register();
        OffensiveBehaviour.register();
        ShockwaveBehaviour.register();
    }

    protected static int registerBehavior(Class<? extends Behavior> behaviorClass) {
        if (behaviorIdToClass == null) {
            behaviorIdToClass = new HashMap<Integer, Class<? extends Behavior>>();
            classToBehaviorId = new HashMap<Class<? extends Behavior>, Integer>();
            nextId = 1;
        }
        int id = nextId++;
        behaviorIdToClass.put(id, behaviorClass);
        classToBehaviorId.put(behaviorClass, id);
        return id;
    }

    public static Behavior lookup(int id, Entity entity) {
        try {
            Behavior behavior = behaviorIdToClass.get(id).newInstance();
            return behavior;
        }
        catch (Exception e) {
            AvatarLog.error("Error constructing behavior...");
            e.printStackTrace();
            return null;
        }
    }

    public int getId() {
        return classToBehaviorId.get(this.getClass());
    }

    public abstract Behavior onUpdate(E var1);

    public void renderUpdate(E entity) {
    }

    public abstract void fromBytes(PacketBuffer var1);

    public abstract void toBytes(PacketBuffer var1);

    public abstract void load(NBTTagCompound var1);

    public abstract void save(NBTTagCompound var1);

    public static class BehaviorSerializer<B extends Behavior<? extends Entity>>
    implements DataSerializer<B> {
        public void write(PacketBuffer buf, B value) {
            buf.writeInt(((Behavior)value).getId());
            ((Behavior)value).toBytes(buf);
        }

        public B read(PacketBuffer buf) throws IOException {
            try {
                Behavior behavior = (Behavior)((Class)behaviorIdToClass.get(buf.readInt())).newInstance();
                behavior.fromBytes(buf);
                return (B)behavior;
            }
            catch (Exception e) {
                AvatarLog.error("Error reading Behavior from bytes");
                e.printStackTrace();
                return null;
            }
        }

        public DataParameter<B> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public B copyValue(B behavior) {
            return behavior;
        }
    }
}

