/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.data;

import com.crowsofwar.avatar.entity.EntityCloudBall;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;

public abstract class CloudburstBehavior
extends OffensiveBehaviour {
    public static final DataSerializer<CloudburstBehavior> DATA_SERIALIZER = new Behavior.BehaviorSerializer<CloudburstBehavior>();
    public static int ID_NOTHING;
    public static int ID_PLAYER_CONTROL;
    public static int ID_THROWN;

    public static void register() {
        DataSerializers.func_187189_a(DATA_SERIALIZER);
        ID_NOTHING = CloudburstBehavior.registerBehavior(Idle.class);
        ID_PLAYER_CONTROL = CloudburstBehavior.registerBehavior(PlayerControlled.class);
        ID_THROWN = CloudburstBehavior.registerBehavior(Thrown.class);
    }

    public static class PlayerControlled
    extends CloudburstBehavior {
        public CloudburstBehavior onUpdate(EntityOffensive entity) {
            if (entity instanceof EntityCloudBall) {
                EntityLivingBase owner = entity.getOwner();
                if (owner == null) {
                    return this;
                }
                Vector forward = Vector.getLookRectangular((Entity)owner);
                Vector eye = Vector.getEyePos((Entity)owner).minusY(0.5);
                Vector target = forward.times(1.5).plus(eye);
                Vector motion = target.minus(Vector.getEntityPos(entity)).times(6.0);
                entity.setVelocity(motion);
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Thrown
    extends CloudburstBehavior {
        int time = 0;

        public CloudburstBehavior onUpdate(EntityOffensive entity) {
            ++this.time;
            entity.func_70024_g(0.0, -0.008333333767950535, 0.0);
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Idle
    extends CloudburstBehavior {
        public CloudburstBehavior onUpdate(EntityOffensive entity) {
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

