/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.data;

import com.crowsofwar.avatar.bending.bending.earth.Earthbending;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityEarthspike;
import com.crowsofwar.avatar.entity.EntityEarthspikeSpawner;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.gorecore.util.Vector;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public abstract class EarthspikesBehavior
extends Behavior<EntityEarthspikeSpawner> {
    public static final UUID MOVEMENT_MODIFIER_ID = UUID.fromString("78723aa8-8d42-11e8-9eb6-529269fb1459");
    public static DataSerializer<EarthspikesBehavior> SERIALIZER = new Behavior.BehaviorSerializer<EarthspikesBehavior>();

    public static void register() {
        DataSerializers.func_187189_a(SERIALIZER);
        EarthspikesBehavior.registerBehavior(Line.class);
        EarthspikesBehavior.registerBehavior(Octopus.class);
        EarthspikesBehavior.registerBehavior(Init.class);
    }

    public static class Octopus
    extends EarthspikesBehavior {
        int ticks = 0;
        boolean spawned = false;

        @Override
        public Behavior onUpdate(EntityEarthspikeSpawner entity) {
            ++this.ticks;
            if (entity.func_130014_f_().field_72995_K) {
                return this;
            }
            World world = entity.func_130014_f_();
            EntityLivingBase owner = entity.getOwner();
            AbilityData abilityData = AbilityData.get(owner, entity.getAbility().getName());
            float xpModifier = abilityData.getTotalXp() / 400.0f;
            float movementMultiplier = 0.6f - 0.7f * MathHelper.func_76129_c((float)((float)this.ticks / 40.0f));
            double damage = ConfigStats.STATS_CONFIG.earthspikeSettings.damage * 2.5;
            float size = ConfigStats.STATS_CONFIG.earthspikeSettings.size * 1.25f;
            size = size + (float)this.ticks / 45.0f + xpModifier;
            damage = (damage + (double)xpModifier) * Bender.get(owner).getDamageMult(Earthbending.ID);
            if (!this.spawned) {
                for (int i = 0; i < 8; ++i) {
                    Vector direction1 = Vector.toRectangular(Math.toRadians(entity.field_70177_z + (float)(i * 45)), 0.0).times(1.4).withY(0.0);
                    EntityEarthspike earthspike = new EntityEarthspike(world);
                    earthspike.func_70107_b(direction1.x() + entity.field_70165_t, entity.field_70163_u, direction1.z() + entity.field_70161_v);
                    earthspike.setAbility(abilityData.getAbility());
                    world.func_72838_d((Entity)earthspike);
                    if (world.field_72995_K) continue;
                    WorldServer World2 = (WorldServer)world;
                    for (int degree = 0; degree < 360; ++degree) {
                        double radians = Math.toRadians(degree);
                        double x = Math.cos(radians) / 2.0 + earthspike.field_70165_t;
                        double y = earthspike.field_70163_u;
                        double z = Math.sin(radians) / 2.0 + earthspike.field_70161_v;
                        World2.func_175739_a(EnumParticleTypes.CRIT, x, y, z, 1, 0.0, 0.0, 0.0, 0.5, new int[0]);
                    }
                }
                this.spawned = true;
                return this;
            }
            assert (owner != null);
            this.applyMovementModifier(owner, MathHelper.func_76131_a((float)movementMultiplier, (float)0.1f, (float)1.0f));
            if (this.ticks % 15 == 0 && owner.field_70122_E) {
                for (int i = 0; i < 8; ++i) {
                    Vector direction1 = Vector.toRectangular(Math.toRadians(owner.field_70177_z + (float)(i * 45)), 0.0).withY(0.0).times((float)this.ticks / 5.0f);
                    EntityEarthspike earthspike = new EntityEarthspike(world);
                    if (direction1.x() + owner.field_70165_t != owner.field_70165_t && direction1.z() + owner.field_70161_v != owner.field_70161_v) {
                        earthspike.func_70107_b(direction1.x() + owner.field_70165_t, owner.field_70163_u, direction1.z() + owner.field_70161_v);
                    }
                    world.func_72838_d((Entity)earthspike);
                    BlockPos below = earthspike.func_180425_c().func_177972_a(EnumFacing.DOWN);
                    Block belowBlock = world.func_180495_p(below).func_177230_c();
                    world.func_184148_a(null, earthspike.field_70165_t, earthspike.field_70163_u, earthspike.field_70161_v, belowBlock.func_185467_w().func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (world.field_72995_K) continue;
                    WorldServer World3 = (WorldServer)world;
                    for (int degree = 0; degree < 360; ++degree) {
                        double radians = Math.toRadians(degree);
                        double x = Math.cos(radians) / 2.0 + earthspike.field_70165_t;
                        double y = earthspike.field_70163_u;
                        double z = Math.sin(radians) / 2.0 + earthspike.field_70161_v;
                        World3.func_175739_a(EnumParticleTypes.CRIT, x, y, z, 1, 0.0, 0.0, 0.0, 0.5, new int[0]);
                    }
                }
            }
            if (this.ticks >= 30) {
                owner.func_110148_a(SharedMonsterAttributes.field_111263_d).func_188479_b(MOVEMENT_MODIFIER_ID);
            }
            return this;
        }

        private void applyMovementModifier(EntityLivingBase entity, float multiplier) {
            IAttributeInstance moveSpeed = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
            moveSpeed.func_188479_b(MOVEMENT_MODIFIER_ID);
            moveSpeed.func_111121_a(new AttributeModifier(MOVEMENT_MODIFIER_ID, "Earthspikes modifier", (double)(multiplier - 1.0f), 1));
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Line
    extends EarthspikesBehavior {
        int ticks = 0;
        boolean spawned = false;

        @Override
        public Behavior onUpdate(EntityEarthspikeSpawner entity) {
            ++this.ticks;
            if (entity.func_130014_f_().field_72995_K) {
                return this;
            }
            World world = entity.func_130014_f_();
            EntityLivingBase owner = entity.getOwner();
            AbilityData abilityData = AbilityData.get(owner, entity.getAbility().getName());
            float frequency = ConfigStats.STATS_CONFIG.earthspikeSettings.frequency;
            double damage = ConfigStats.STATS_CONFIG.earthspikeSettings.damage;
            float size = ConfigStats.STATS_CONFIG.earthspikeSettings.size * 0.25f;
            float xpModifier = abilityData.getTotalXp() / 400.0f;
            switch (abilityData.getLevel()) {
                case 1: {
                    damage = ConfigStats.STATS_CONFIG.earthspikeSettings.damage * 1.33;
                    size = ConfigStats.STATS_CONFIG.earthspikeSettings.size * 0.5f;
                    break;
                }
                case 2: {
                    frequency = ConfigStats.STATS_CONFIG.earthspikeSettings.frequency * 0.75f;
                    damage = ConfigStats.STATS_CONFIG.earthspikeSettings.damage * 1.66;
                    size = ConfigStats.STATS_CONFIG.earthspikeSettings.size * 0.75f;
                    break;
                }
                case 3: {
                    frequency = ConfigStats.STATS_CONFIG.earthspikeSettings.frequency * 0.5f;
                    damage = ConfigStats.STATS_CONFIG.earthspikeSettings.damage * 2.25;
                    size = ConfigStats.STATS_CONFIG.earthspikeSettings.size * 1.0f;
                }
            }
            size += (float)this.ticks / 45.0f;
            size += xpModifier;
            damage += (double)xpModifier;
            damage *= Objects.requireNonNull(Bender.get(owner)).getDamageMult(Earthbending.ID);
            if (entity != null && (float)this.ticks % frequency == 0.0f && (float)this.ticks > frequency / 3.0f) {
                double duration = entity.getDuration();
                EntityEarthspike earthspike = new EntityEarthspike(world);
                earthspike.field_70165_t = entity.field_70165_t;
                earthspike.field_70163_u = entity.field_70163_u;
                earthspike.field_70161_v = entity.field_70161_v;
                earthspike.setAbility(Objects.requireNonNull(abilityData.getAbility()));
                world.func_72838_d((Entity)earthspike);
                BlockPos below = earthspike.func_180425_c().func_177972_a(EnumFacing.DOWN);
                Block belowBlock = world.func_180495_p(below).func_177230_c();
                world.func_184148_a(null, earthspike.field_70165_t, earthspike.field_70163_u, earthspike.field_70161_v, belowBlock.func_185467_w().func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!world.field_72995_K) {
                    WorldServer World2 = (WorldServer)world;
                    World2.func_175739_a(EnumParticleTypes.CRIT, earthspike.field_70165_t, earthspike.field_70163_u, earthspike.field_70161_v, 100, 0.0, 0.0, 0.0, 0.5, new int[0]);
                }
            }
            return this;
        }

        @Override
        public void renderUpdate(EntityEarthspikeSpawner entity) {
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Init
    extends EarthspikesBehavior {
        @Override
        public Behavior onUpdate(EntityEarthspikeSpawner entity) {
            return entity.getType() == EntityEarthspikeSpawner.SpikesType.LINE ? new Line() : new Octopus();
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

