/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.data;

import com.crowsofwar.avatar.entity.EntityFireball;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;

public abstract class FireballBehavior
extends OffensiveBehaviour {
    public static void register() {
        FireballBehavior.registerBehavior(PlayerControlled.class);
        FireballBehavior.registerBehavior(Thrown.class);
    }

    public static class PlayerControlled
    extends FireballBehavior {
        public OffensiveBehaviour onUpdate(EntityOffensive entity) {
            EntityLivingBase owner = entity.getOwner();
            if (owner == null || !(entity instanceof EntityFireball)) {
                return this;
            }
            Vector forward = Vector.getLookRectangular((Entity)owner);
            Vector eye = Vector.getEyePos((Entity)owner);
            Vector target = forward.times(2.5).plus(eye);
            Vec3d motion = target.minus(Vector.getEntityPos(entity)).times(0.5).toMinecraft();
            int angle = (int)entity.field_70170_p.func_72820_D();
            List fireballs = entity.field_70170_p.func_72872_a(EntityFireball.class, owner.func_174813_aQ().func_72314_b(4.0, 4.0, 4.0));
            fireballs = fireballs.stream().filter(fireball -> fireball.getOwner() == owner).collect(Collectors.toList());
            fireballs.sort((b1, b2) -> b1.getOrbitID() > b2.getOrbitID() ? 1 : -1);
            int index = fireballs.indexOf(entity);
            if (index < 0) {
                return this;
            }
            if (!fireballs.isEmpty() && fireballs.size() > 1) {
                angle *= 10;
                double radians = Math.toRadians(angle += 360 / fireballs.size() * index);
                double x = 2.5 * Math.cos(radians);
                double z = 2.5 * Math.sin(radians);
                Vec3d pos = new Vec3d(x, 0.0, z);
                pos = pos.func_72441_c(owner.field_70165_t, owner.func_174813_aQ().field_72338_b + 1.5, owner.field_70161_v);
                motion = pos.func_178788_d(entity.func_174791_d()).func_186678_a(0.5);
            }
            entity.setVelocity(motion);
            BendingData data = BendingData.getFromEntity(owner);
            if (data != null && !data.hasStatusControl(StatusControlController.THROW_FIREBALL)) {
                data.addStatusControl(StatusControlController.THROW_FIREBALL);
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Thrown
    extends FireballBehavior {
        public FireballBehavior onUpdate(EntityOffensive entity) {
            entity.addVelocity(Vector.DOWN.times(0.025f));
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

