/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.data;

import com.crowsofwar.avatar.entity.EntityFloatingBlock;
import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class FloatingBlockBehavior
extends OffensiveBehaviour {
    public static final DataSerializer<FloatingBlockBehavior> DATA_SERIALIZER = new Behavior.BehaviorSerializer<FloatingBlockBehavior>();
    public static int ID_NOTHING;
    public static int ID_FALL;
    public static int ID_PICKUP;
    public static int ID_PLACE;
    public static int ID_PLAYER_CONTROL;
    public static int ID_THROWN;

    public static void register() {
        DataSerializers.func_187189_a(DATA_SERIALIZER);
        ID_NOTHING = FloatingBlockBehavior.registerBehavior(Idle.class);
        ID_FALL = FloatingBlockBehavior.registerBehavior(Fall.class);
        ID_PICKUP = FloatingBlockBehavior.registerBehavior(PickUp.class);
        ID_PLACE = FloatingBlockBehavior.registerBehavior(Place.class);
        ID_PLAYER_CONTROL = FloatingBlockBehavior.registerBehavior(PlayerControlled.class);
        ID_THROWN = FloatingBlockBehavior.registerBehavior(Thrown.class);
    }

    public static class Fall
    extends FloatingBlockBehavior {
        public FloatingBlockBehavior onUpdate(EntityOffensive entity) {
            if (entity instanceof EntityFloatingBlock) {
                entity.addVelocity(Vector.DOWN.times(0.49050000000000005));
                if (entity.onCollideWithSolid() && !entity.field_70170_p.field_72995_K) {
                    entity.Dissipate();
                }
                entity.setEntitySize(0.9f);
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class PlayerControlled
    extends FloatingBlockBehavior {
        public FloatingBlockBehavior onUpdate(EntityOffensive entity) {
            EntityLivingBase owner = entity.getOwner();
            if (owner == null || !(entity instanceof EntityFloatingBlock)) {
                return this;
            }
            entity.setEntitySize(0.9f);
            Vec3d forward = owner.func_70676_i(1.0f);
            Vec3d eye = owner.func_174824_e(1.0f);
            Vec3d target = forward.func_186678_a(2.5).func_178787_e(eye);
            Vec3d motion = target.func_178788_d(AvatarEntityUtils.getBottomMiddleOfEntity(entity)).func_186678_a(0.5);
            int angle = (int)entity.field_70170_p.func_72820_D();
            List blocks = entity.field_70170_p.func_72872_a(EntityFloatingBlock.class, owner.func_174813_aQ().func_72314_b(4.0, 4.0, 4.0));
            blocks.sort((b1, b2) -> b1.getID() > b2.getID() ? 1 : -1);
            int index = blocks.indexOf(entity);
            if (index < 0) {
                return this;
            }
            if (!blocks.isEmpty() && blocks.size() > 1) {
                angle *= 5;
                double radians = Math.toRadians(angle += 360 / blocks.size() * index);
                double x = 2.5 * Math.cos(radians);
                double z = 2.5 * Math.sin(radians);
                Vec3d pos = new Vec3d(x, 0.0, z);
                pos = pos.func_72441_c(owner.field_70165_t, owner.func_174813_aQ().field_72338_b + 1.5, owner.field_70161_v);
                motion = pos.func_178788_d(AvatarEntityUtils.getBottomMiddleOfEntity(entity)).func_186678_a(0.5);
            }
            entity.setVelocity(motion);
            BendingData data = BendingData.getFromEntity(owner);
            if (!(data == null || data.hasStatusControl(StatusControlController.THROW_BLOCK) && data.hasStatusControl(StatusControlController.PLACE_BLOCK))) {
                data.addStatusControls(StatusControlController.THROW_BLOCK, StatusControlController.PLACE_BLOCK);
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class PickUp
    extends FloatingBlockBehavior {
        public FloatingBlockBehavior onUpdate(EntityOffensive entity) {
            entity.addVelocity(Vector.DOWN.times(0.49050000000000005));
            Vector velocity = entity.velocity();
            if (velocity.y() <= 0.0 && entity.getOwner() != null) {
                entity.setVelocity(velocity.withY(0.0));
                Vec3d forward = entity.getOwner().func_70676_i(1.0f);
                Vec3d eye = entity.getOwner().func_174824_e(1.0f);
                Vec3d target = forward.func_186678_a(2.5).func_178787_e(eye);
                Vec3d motion = target.func_178788_d(entity.func_174791_d()).func_186678_a(0.05);
                entity.setVelocity(motion);
                return new PlayerControlled();
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Thrown
    extends FloatingBlockBehavior {
        public FloatingBlockBehavior onUpdate(EntityOffensive entity) {
            entity.setEntitySize(1.0f);
            entity.addVelocity(Vector.DOWN.times(0.327));
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Place
    extends FloatingBlockBehavior {
        private BlockPos placeAt;

        public Place() {
        }

        public Place(BlockPos placeAt) {
            this.placeAt = placeAt;
        }

        public FloatingBlockBehavior onUpdate(EntityOffensive entity) {
            if (entity instanceof EntityFloatingBlock) {
                entity.field_70145_X = true;
                World world = entity.field_70170_p;
                Vector placeAtVec = new Vector((double)this.placeAt.func_177958_n() + 0.5, this.placeAt.func_177956_o(), (double)this.placeAt.func_177952_p() + 0.5);
                Vector thisPos = new Vector(entity);
                Vector force = placeAtVec.minus(thisPos);
                force = force.normalize().times(3.0);
                entity.setVelocity(force);
                if (placeAtVec.sqrDist(thisPos) < 0.005) {
                    ((EntityFloatingBlock)entity).placeBlock();
                    entity.Dissipate();
                    SoundType sound = ((EntityFloatingBlock)entity).getBlock().func_185467_w();
                    if (sound != null) {
                        entity.field_70170_p.func_184133_a(null, entity.func_180425_c(), sound.func_185841_e(), SoundCategory.PLAYERS, sound.func_185843_a(), sound.func_185847_b());
                    }
                }
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
            this.placeAt = buf.func_179259_c();
        }

        @Override
        public void toBytes(PacketBuffer buf) {
            buf.func_179255_a(this.placeAt);
        }

        @Override
        public void load(NBTTagCompound nbt) {
            this.placeAt = new BlockPos(nbt.func_74762_e("PlaceX"), nbt.func_74762_e("PlaceY"), nbt.func_74762_e("PlaceZ"));
        }

        @Override
        public void save(NBTTagCompound nbt) {
            nbt.func_74768_a("PlaceX", this.placeAt.func_177958_n());
            nbt.func_74768_a("PlaceY", this.placeAt.func_177956_o());
            nbt.func_74768_a("PlaceZ", this.placeAt.func_177952_p());
        }
    }

    public static class Idle
    extends FloatingBlockBehavior {
        public FloatingBlockBehavior onUpdate(EntityOffensive entity) {
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

