/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.data;

import com.crowsofwar.avatar.bending.bending.fire.AbilityFlameStrike;
import com.crowsofwar.avatar.bending.bending.fire.AbilityImmolate;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityLightOrb;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.util.AvatarUtils;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.MathHelper;

public abstract class LightOrbBehavior
extends Behavior<EntityLightOrb> {
    public static final DataSerializer<LightOrbBehavior> DATA_SERIALIZER = new Behavior.BehaviorSerializer<LightOrbBehavior>();

    public static void register() {
        DataSerializers.func_187189_a(DATA_SERIALIZER);
        LightOrbBehavior.registerBehavior(Idle.class);
        LightOrbBehavior.registerBehavior(FollowEntity.class);
        LightOrbBehavior.registerBehavior(ShiftColourRandomly.class);
        LightOrbBehavior.registerBehavior(ShiftColour.class);
        LightOrbBehavior.registerBehavior(FollowPlayer.class);
        LightOrbBehavior.registerBehavior(AbilityFlameStrike.FlameStrikeLightOrb.class);
        LightOrbBehavior.registerBehavior(AbilityImmolate.ImmolateLightOrbBehaviour.class);
    }

    public static class ShiftColour
    extends LightOrbBehavior {
        @Override
        public Behavior onUpdate(EntityLightOrb entity) {
            return null;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class ShiftColourRandomly
    extends LightOrbBehavior {
        @Override
        public Behavior onUpdate(EntityLightOrb entity) {
            if (entity.getColourShiftRange() != 0.0f) {
                float range = entity.getColourShiftRange() / 2.0f;
                float r = entity.getInitialColourR();
                float g = entity.getInitialColourG();
                float b = entity.getInitialColourB();
                float a = entity.getInitialColourA();
                block6: for (int i = 0; i < 4; ++i) {
                    float rMin = r < range ? 0.0f : r - range;
                    float gMin = g < range ? 0.0f : r - range;
                    float bMin = b < range ? 0.0f : r - range;
                    float aMin = a < range ? 0.0f : a - range;
                    float rMax = r + range;
                    float gMax = b + range;
                    float bMax = g + range;
                    float aMax = a + range;
                    switch (i) {
                        case 0: {
                            float amountR = (float)AvatarUtils.getRandomNumberInRange(0, (int)(100.0f / rMax)) / 100.0f * entity.getColourShiftInterval();
                            float red = entity.field_70170_p.field_73012_v.nextBoolean() ? r + amountR : r - amountR;
                            red = MathHelper.func_76131_a((float)red, (float)rMin, (float)rMax);
                            entity.setColorR(red);
                            continue block6;
                        }
                        case 1: {
                            float amountG = (float)AvatarUtils.getRandomNumberInRange(0, (int)(100.0f / gMax)) / 100.0f * entity.getColourShiftInterval();
                            float green = entity.field_70170_p.field_73012_v.nextBoolean() ? g + amountG : g - amountG;
                            green = MathHelper.func_76131_a((float)green, (float)gMin, (float)gMax);
                            entity.setColorG(green);
                            continue block6;
                        }
                        case 2: {
                            float amountB = (float)AvatarUtils.getRandomNumberInRange(0, (int)(100.0f / bMax)) / 100.0f * entity.getColourShiftInterval();
                            float blue = entity.field_70170_p.field_73012_v.nextBoolean() ? b + amountB : b - amountB;
                            blue = MathHelper.func_76131_a((float)blue, (float)bMin, (float)bMax);
                            entity.setColorB(blue);
                            continue block6;
                        }
                        case 3: {
                            float amountA = (float)AvatarUtils.getRandomNumberInRange(0, (int)(100.0f / aMax)) / 100.0f * entity.getColourShiftInterval();
                            float alpha = entity.field_70170_p.field_73012_v.nextBoolean() ? a + amountA : a - amountA;
                            alpha = MathHelper.func_76131_a((float)alpha, (float)aMin, (float)aMax);
                            entity.setColorA(alpha);
                        }
                    }
                }
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class FollowPlayer
    extends LightOrbBehavior {
        @Override
        public Behavior onUpdate(EntityLightOrb entity) {
            Entity emitter = entity.getEmittingEntity();
            if (emitter != null) {
                entity.field_70159_w = emitter.field_70159_w;
                entity.field_70181_x = emitter.field_70181_x;
                entity.field_70179_y = emitter.field_70179_y;
                entity.field_70165_t = emitter.field_70165_t;
                entity.field_70163_u = emitter.field_70163_u + (double)(entity.field_70131_O / 2.0f);
                entity.field_70161_v = emitter.field_70161_v;
            } else if (entity.field_70173_aa > 1) {
                entity.func_70106_y();
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class FollowEntity
    extends LightOrbBehavior {
        @Override
        public Behavior onUpdate(EntityLightOrb entity) {
            Entity emitter = entity.getEmittingEntity();
            if (emitter != null) {
                entity.field_70165_t = emitter.field_70165_t;
                entity.field_70163_u = emitter.field_70163_u + (double)(entity.field_70131_O * 2.0f);
                entity.field_70161_v = emitter.field_70161_v;
                if (emitter instanceof AvatarEntity) {
                    entity.setVelocity(((AvatarEntity)emitter).velocity());
                }
            } else if (entity.field_70173_aa > 1) {
                entity.func_70106_y();
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Idle
    extends LightOrbBehavior {
        public LightOrbBehavior onUpdate(EntityLightOrb entity) {
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buffer) {
        }

        @Override
        public void toBytes(PacketBuffer buffer) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

