/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.data;

import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class LightningFloodFill {
    private final World world;
    private final Consumer<EntityLivingBase> entityCallback;
    private final BlockPos originalPos;
    private final int expansionSq;
    private final Queue<BlockPos> waterBlocksQueue;
    private final Set<BlockPos> processedBlocks;

    public LightningFloodFill(World world, BlockPos initialPos, int expansion, Consumer<EntityLivingBase> entityCallback) {
        this.world = world;
        this.waterBlocksQueue = new PriorityQueue<BlockPos>(expansion * expansion * expansion);
        this.processedBlocks = new TreeSet<BlockPos>();
        this.entityCallback = entityCallback;
        this.originalPos = initialPos;
        this.expansionSq = expansion * expansion;
        this.waterBlocksQueue.add(initialPos);
        this.processedBlocks.add(initialPos);
    }

    public boolean tick() {
        for (int i = 0; i < 20 && !this.waterBlocksQueue.isEmpty(); ++i) {
            this.processBlock();
        }
        return this.waterBlocksQueue.isEmpty();
    }

    private void processBlock() {
        BlockPos pos = this.waterBlocksQueue.poll();
        List entities = this.world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos));
        for (EntityLivingBase entity : entities) {
            this.entityCallback.accept(entity);
        }
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos searchPos = pos.func_177972_a(facing);
            if (!(searchPos.func_177951_i((Vec3i)this.originalPos) <= (double)this.expansionSq)) continue;
            boolean waterBlock = this.world.func_180495_p(searchPos).func_177230_c() == Blocks.field_150355_j;
            boolean processedHere = this.processedBlocks.contains(searchPos);
            if (!waterBlock || processedHere) continue;
            this.waterBlocksQueue.add(searchPos);
            this.processedBlocks.add(searchPos);
        }
    }
}

