/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.data;

import com.crowsofwar.avatar.bending.bending.lightning.AbilityLightningSpear;
import com.crowsofwar.avatar.entity.AvatarEntity;
import com.crowsofwar.avatar.entity.EntityLightningSpear;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public abstract class LightningSpearBehavior
extends Behavior<EntityLightningSpear> {
    public static final DataSerializer<LightningSpearBehavior> DATA_SERIALIZER = new Behavior.BehaviorSerializer<LightningSpearBehavior>();
    public static int ID_NOTHING;
    public static int ID_PLAYER_CONTROL;
    public static int ID_THROWN;

    public static void register() {
        DataSerializers.func_187189_a(DATA_SERIALIZER);
        ID_NOTHING = LightningSpearBehavior.registerBehavior(Idle.class);
        ID_PLAYER_CONTROL = LightningSpearBehavior.registerBehavior(PlayerControlled.class);
        ID_THROWN = LightningSpearBehavior.registerBehavior(Thrown.class);
    }

    public static class PlayerControlled
    extends LightningSpearBehavior {
        float maxSize = 1.6f;
        float maxDamage = 4.0f;

        public LightningSpearBehavior onUpdate(EntityLightningSpear entity) {
            Vector target;
            Raytrace.Result res;
            EntityLightningSpear spear;
            EntityLivingBase owner = entity.getOwner();
            if (owner == null || entity.field_70170_p.field_72995_K) {
                return this;
            }
            BendingData data = BendingData.get(owner);
            if (!data.hasStatusControl(StatusControlController.THROW_LIGHTNINGSPEAR) && (spear = AvatarEntity.lookupControlledEntity(entity.field_70170_p, EntityLightningSpear.class, entity.getOwner())) != null) {
                data.addStatusControl(StatusControlController.THROW_LIGHTNINGSPEAR);
            }
            if ((res = Raytrace.getTargetBlock(owner, 3.0, false)).hitSomething()) {
                target = res.getPosPrecise();
            } else {
                Vector look = Vector.toRectangular(Math.toRadians(owner.field_70177_z), Math.toRadians(owner.field_70125_A));
                target = Vector.getEyePos((Entity)owner).plus(look.times(1.0f + entity.getAvgSize()));
            }
            assert (target != null);
            Vector motion = target.minus(entity.position());
            motion = motion.times(10.0);
            entity.setVelocity(motion);
            Vector direction = entity.position().minus(Vector.getEyePos((Entity)owner)).toSpherical();
            entity.field_70177_z = (float)Math.toDegrees(direction.y());
            entity.field_70125_A = (float)Math.toDegrees(direction.x());
            entity.field_70145_X = true;
            float size = entity.getAvgSize();
            float damage = entity.getDamage();
            if (entity.getAbility() instanceof AbilityLightningSpear && !entity.field_70170_p.field_72995_K) {
                AbilityData aD = AbilityData.get(entity.getOwner(), "lightning_spear");
                int lvl = aD.getLevel();
                if (lvl == 1) {
                    this.maxSize = 1.8f;
                    this.maxDamage = 5.0f;
                }
                if (lvl == 2) {
                    this.maxSize = 2.0f;
                    this.maxDamage = 6.0f;
                }
                if (aD.isMasterPath(AbilityData.AbilityTreePath.SECOND)) {
                    this.maxSize = 2.6f;
                    this.maxDamage = 7.0f;
                }
                if (aD.isMasterPath(AbilityData.AbilityTreePath.FIRST)) {
                    this.maxDamage = 8.0f;
                }
            }
            if (size < this.maxSize && entity.field_70173_aa % 4 == 0) {
                entity.setEntitySize(size + 0.005f);
            }
            if (damage < this.maxDamage && entity.field_70173_aa % 4 == 0) {
                entity.setDamage(damage + 0.005f);
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Thrown
    extends LightningSpearBehavior {
        int time = 0;

        public LightningSpearBehavior onUpdate(EntityLightningSpear entity) {
            AxisAlignedBB box;
            List collidedList;
            ++this.time;
            entity.field_70145_X = false;
            World world = entity.field_70170_p;
            if (!(entity.field_70128_L || world.field_72995_K || (collidedList = world.func_72872_a(Entity.class, box = new AxisAlignedBB(entity.field_70165_t + (double)entity.getAvgSize(), entity.field_70163_u + (double)entity.getAvgSize(), entity.field_70161_v + (double)entity.getAvgSize(), entity.field_70165_t - (double)entity.getAvgSize(), entity.field_70163_u - (double)entity.getAvgSize(), entity.field_70161_v - (double)entity.getAvgSize()))).isEmpty())) {
                for (Entity collided : collidedList) {
                    if (collided == entity.getOwner() || !entity.canCollideWith(collided) && (!collided.func_70067_L() || !collided.func_70104_M()) || collided == entity) continue;
                    this.collision(collided, entity, entity.isGroupAttack());
                }
            }
            return this;
        }

        private void collision(Entity collided, EntityLightningSpear entity, boolean triggerGroupAttack) {
            if (!entity.canDamageEntity(collided) || collided == entity.getOwner() || collided != entity) {
                // empty if block
            }
            if (triggerGroupAttack) {
                double radius = 2.0;
                AxisAlignedBB aabb = new AxisAlignedBB(entity.field_70165_t - radius, entity.field_70163_u - radius, entity.field_70161_v - radius, entity.field_70165_t + radius, entity.field_70163_u + radius, entity.field_70161_v + radius);
                List targets = entity.field_70170_p.func_72872_a(Entity.class, aabb);
                for (Entity target : targets) {
                    if (target.func_70068_e((Entity)entity) > radius * radius) continue;
                    this.collision(target, entity, false);
                }
            }
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Idle
    extends LightningSpearBehavior {
        public LightningSpearBehavior onUpdate(EntityLightningSpear entity) {
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

