/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.data;

import com.crowsofwar.avatar.AvatarLog;
import com.crowsofwar.avatar.util.data.CachedEntity;
import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;

public class SyncedEntity<T extends Entity> {
    private final Entity using;
    private final DataParameter<Optional<UUID>> sync;
    private final CachedEntity<T> cache;
    private boolean allowNullSaving;

    public SyncedEntity(Entity entity, DataParameter<Optional<UUID>> sync) {
        this.using = entity;
        this.sync = sync;
        this.cache = new CachedEntity(null);
        this.allowNullSaving = true;
    }

    public void preventNullSaving() {
        this.allowNullSaving = false;
    }

    @Nullable
    public T getEntity() {
        Optional optional = (Optional)this.using.func_184212_Q().func_187225_a(this.sync);
        this.cache.setEntityId((UUID)optional.orNull());
        return this.cache.getEntity(this.using.field_70170_p);
    }

    public void setEntity(@Nullable T entity) {
        this.cache.setEntity(entity);
        this.using.func_184212_Q().func_187227_b(this.sync, (Object)Optional.fromNullable((Object)this.cache.getEntityId()));
    }

    @Nullable
    public UUID getEntityId() {
        return this.cache.getEntityId();
    }

    public void setEntityId(@Nullable UUID entityId) {
        this.cache.setEntityId(entityId);
        this.using.func_184212_Q().func_187227_b(this.sync, (Object)Optional.fromNullable((Object)entityId));
    }

    public void readFromNbt(NBTTagCompound nbt) {
        this.cache.readFromNbt(nbt);
        this.using.func_184212_Q().func_187227_b(this.sync, (Object)Optional.fromNullable((Object)this.cache.getEntityId()));
        if (!this.allowNullSaving && this.getEntity() == null) {
            this.using.func_70106_y();
            AvatarLog.warn(AvatarLog.WarningType.INVALID_SAVE, "Entity reference was null on load and removed entity for safety: " + this.using);
        }
    }

    public void writeToNbt(NBTTagCompound nbt) {
        this.cache.writeToNbt(nbt);
    }
}

