/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.data;

import com.crowsofwar.avatar.bending.bending.Abilities;
import com.crowsofwar.avatar.bending.bending.earth.AbilityWall;
import com.crowsofwar.avatar.config.ConfigStats;
import com.crowsofwar.avatar.entity.EntityWallSegment;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.util.AvatarEntityUtils;
import com.crowsofwar.avatar.util.data.AbilityData;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.gorecore.util.Vector;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;

public abstract class WallBehavior
extends Behavior<EntityWallSegment> {
    public static DataSerializer<WallBehavior> SERIALIZER = new Behavior.BehaviorSerializer<WallBehavior>();

    public static void register() {
        DataSerializers.func_187189_a(SERIALIZER);
        WallBehavior.registerBehavior(Drop.class);
        WallBehavior.registerBehavior(Place.class);
        WallBehavior.registerBehavior(Rising.class);
        WallBehavior.registerBehavior(Waiting.class);
        WallBehavior.registerBehavior(Push.class);
        WallBehavior.registerBehavior(Pull.class);
    }

    public static class Pull
    extends WallBehavior {
        private int ticks = 0;
        private double lastApplied;

        @Override
        public Behavior onUpdate(EntityWallSegment entity) {
            if (entity == null) {
                return this;
            }
            if (entity.getWall() == null) {
                return this;
            }
            ++this.ticks;
            EnumFacing cardinalToPush = entity.getDirection();
            if (cardinalToPush == null) {
                return this;
            }
            entity.setRestrictToVertical(false);
            if (this.ticks == 1) {
                double velocity;
                double pushDistance = new Vector(entity.func_174791_d()).withY(0.0).dist(entity.getInitialPos().withY(0.0));
                this.lastApplied = velocity = ConfigStats.STATS_CONFIG.wallMomentum / 5.0 * pushDistance / 20.0;
                AvatarEntityUtils.applyMotionToEntityInDirection(entity, cardinalToPush, -velocity);
                BendingData.get(entity.getOwner()).chi().consumeChi(ConfigStats.STATS_CONFIG.chiPushWall * 2.0f);
            } else {
                entity.field_70181_x = 0.0;
                double velocity = this.lastApplied * 0.9;
                AvatarEntityUtils.applyMotionToEntityInDirection(entity, cardinalToPush, -velocity);
                this.lastApplied = velocity;
            }
            List collidingEntities = entity.func_130014_f_().func_72839_b((Entity)entity, entity.func_70114_g(entity));
            if (collidingEntities.size() > 0) {
                for (Entity current : collidingEntities) {
                    AvatarEntityUtils.applyMotionToEntityInDirection(current, cardinalToPush, -0.4);
                }
            }
            return this.ticks > 100 ? new Waiting() : this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Push
    extends WallBehavior {
        private int ticks = 0;
        private double lastApplied;

        public WallBehavior onUpdate(EntityWallSegment entity) {
            boolean done;
            if (entity == null || entity.getOwner() == null) {
                return this;
            }
            if (entity.getWall() == null) {
                return this;
            }
            ++this.ticks;
            EnumFacing cardinalToPush = entity.getDirection();
            if (cardinalToPush == null) {
                return this;
            }
            entity.setRestrictToVertical(false);
            if (this.ticks == 1) {
                double velocity;
                entity.setInitialPos(new Vector(entity.func_174791_d()));
                entity.field_70181_x = 0.1;
                int pushDistance = 4;
                this.lastApplied = velocity = ConfigStats.STATS_CONFIG.wallMomentum / 5.0 * (double)pushDistance / 20.0;
                AvatarEntityUtils.applyMotionToEntityInDirection(entity, cardinalToPush, velocity);
                AbilityData abilityData = AbilityData.get(entity.getOwner(), "wall");
                AbilityWall wall = (AbilityWall)Abilities.get("wall");
                if (wall != null && abilityData != null) {
                    BendingData.get(entity.getOwner()).chi().consumeChi(wall.getChiCost(abilityData) / 2.0f);
                }
            } else {
                entity.field_70181_x = 0.0;
                double velocity = this.lastApplied * 0.9;
                AvatarEntityUtils.applyMotionToEntityInDirection(entity, cardinalToPush, velocity);
                this.lastApplied = velocity;
            }
            List collidingEntities = entity.func_130014_f_().func_72839_b((Entity)entity, entity.func_174813_aQ());
            if (collidingEntities.size() > 0) {
                for (Entity current : collidingEntities) {
                    AvatarEntityUtils.applyMotionToEntityInDirection(current, cardinalToPush, 0.4);
                }
            }
            boolean bl = done = this.ticks > 50;
            if (done) {
                BendingData.get(entity.getOwner()).addStatusControl(StatusControlController.PULL_WALL);
            }
            return done ? new Waiting() : this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Waiting
    extends WallBehavior {
        private int ticks = 0;

        @Override
        public Behavior onUpdate(EntityWallSegment entity) {
            if (entity == null) {
                return this;
            }
            if (entity.getWall() == null) {
                return this;
            }
            entity.setVelocity(Vector.ZERO);
            ++this.ticks;
            return (double)this.ticks >= ConfigStats.STATS_CONFIG.wallWaitTime * 20.0 ? new Drop() : this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Rising
    extends WallBehavior {
        private int ticks = 0;

        public WallBehavior onUpdate(EntityWallSegment entity) {
            if (entity == null) {
                return this;
            }
            if (entity.getWall() == null) {
                return this;
            }
            if (this.ticks == 1) {
                int maxHeight = entity.getSegmentHeight();
                for (int i = 0; i < entity.getSegmentHeight(); ++i) {
                    EntityWallSegment seg = entity.getWall().getSegment(i);
                    if (!(seg.field_70131_O > (float)maxHeight)) continue;
                    maxHeight = (int)seg.field_70131_O;
                }
                entity.field_70181_x = Math.sqrt(entity.getSegmentHeight()) / 5.75 + (double)0.135f;
            } else {
                double height = entity.func_174791_d().field_72448_b - entity.getInitialPos().y();
                double vel = (double)entity.getSegmentHeight() * (1.0 / ((double)entity.getSegmentHeight() + 1.0));
                entity.field_70181_x *= Math.sqrt(vel) * (1.0 - height / (double)entity.getSegmentHeight() / 32.0);
            }
            if (!entity.field_70170_p.field_72995_K) {
                ++this.ticks;
            }
            return (double)this.ticks > Math.sqrt(entity.getSegmentHeight()) * 50.0 && entity.velocity().y() < Math.sqrt(entity.getSegmentHeight()) / 6.75 || (double)(entity.getInitialPos().toBlockPos().func_177956_o() + entity.getSegmentHeight()) + 0.25 <= entity.func_174791_d().field_72448_b || entity.velocity().y() < 0.05 && this.ticks > 4 ? new Waiting() : this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Place
    extends WallBehavior {
        private int ticks = 0;

        @Override
        public Behavior onUpdate(EntityWallSegment entity) {
            if (entity == null) {
                return this;
            }
            if (entity.getWall() == null) {
                return this;
            }
            ++this.ticks;
            if (this.ticks == 2) {
                entity.setVelocity(Vector.ZERO);
                entity.getWall().setDropTypePlace(true);
                entity.getWall().func_70106_y();
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Drop
    extends WallBehavior {
        @Override
        public Behavior onUpdate(EntityWallSegment entity) {
            if (entity == null) {
                return this;
            }
            if (entity.getWall() == null) {
                return this;
            }
            entity.addVelocity(Vector.DOWN.times(0.35));
            int nbOnGround = 0;
            for (int i = 0; i < 7; ++i) {
                EntityWallSegment current = entity.getWall().getSegment(i);
                if (current == null || current.field_70122_E) continue;
                ++nbOnGround;
            }
            if (nbOnGround == 0) {
                entity.dropBlocks();
                entity.func_70106_y();
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

