/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.data;

import com.crowsofwar.avatar.entity.EntityOffensive;
import com.crowsofwar.avatar.entity.EntityWaterArc;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.entity.data.OffensiveBehaviour;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.avatar.util.data.StatusControlController;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;

public abstract class WaterArcBehavior
extends OffensiveBehaviour {
    public static final DataSerializer<WaterArcBehavior> DATA_SERIALIZER = new Behavior.BehaviorSerializer<WaterArcBehavior>();

    WaterArcBehavior() {
    }

    public static void register() {
        DataSerializers.func_187189_a(DATA_SERIALIZER);
        WaterArcBehavior.registerBehavior(PlayerControlled.class);
        WaterArcBehavior.registerBehavior(Thrown.class);
        WaterArcBehavior.registerBehavior(Idle.class);
    }

    public static class Idle
    extends WaterArcBehavior {
        public WaterArcBehavior onUpdate(EntityOffensive entity) {
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Thrown
    extends WaterArcBehavior {
        float ticks = 0.0f;

        public WaterArcBehavior onUpdate(EntityOffensive entity) {
            this.ticks += 1.0f;
            entity.func_70024_g(0.0, -0.008333333767950535, 0.0);
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class PlayerControlled
    extends WaterArcBehavior {
        public WaterArcBehavior onUpdate(EntityOffensive water) {
            Vector target;
            EntityLivingBase owner = water.getOwner();
            if (owner == null || !(water instanceof EntityWaterArc)) {
                return this;
            }
            Raytrace.Result res = Raytrace.getTargetBlock(owner, 3.0, false);
            if (res.hitSomething()) {
                target = res.getPosPrecise();
            } else {
                Vector look = Vector.toRectangular(Math.toRadians(owner.field_70177_z), Math.toRadians(owner.field_70125_A));
                target = Vector.getEyePos((Entity)owner).plus(look.times(3.0));
            }
            assert (target != null);
            Vector motion = target.minus(water.position());
            motion = motion.times(10.0);
            water.setVelocity(motion);
            water.field_70177_z = owner.field_70177_z;
            water.field_70125_A = owner.field_70125_A;
            if (water.field_70170_p.field_72995_K && ((EntityWaterArc)water).canPlaySplash() && motion.sqrMagnitude() >= 0.004) {
                ((EntityWaterArc)water).playSplash();
            }
            if (water.field_70173_aa % 10 == 0) {
                BendingData.get(owner).addStatusControl(StatusControlController.THROW_WATER);
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

