/*
 * Decompiled with CFR 0.152.
 */
package com.crowsofwar.avatar.entity.data;

import com.crowsofwar.avatar.entity.EntityWaterBubble;
import com.crowsofwar.avatar.entity.data.Behavior;
import com.crowsofwar.avatar.util.Raytrace;
import com.crowsofwar.avatar.util.data.AvatarWorldData;
import com.crowsofwar.avatar.util.data.Bender;
import com.crowsofwar.avatar.util.data.BendingData;
import com.crowsofwar.gorecore.util.Vector;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;

public abstract class WaterBubbleBehavior
extends Behavior<EntityWaterBubble> {
    public static final DataSerializer<WaterBubbleBehavior> DATA_SERIALIZER = new Behavior.BehaviorSerializer<WaterBubbleBehavior>();

    protected WaterBubbleBehavior() {
    }

    public static void register() {
        DataSerializers.func_187189_a(DATA_SERIALIZER);
        WaterBubbleBehavior.registerBehavior(Drop.class);
        WaterBubbleBehavior.registerBehavior(PlayerControlled.class);
        WaterBubbleBehavior.registerBehavior(Lobbed.class);
    }

    public static class Lobbed
    extends WaterBubbleBehavior {
        @Override
        public Behavior onUpdate(EntityWaterBubble entity) {
            entity.addVelocity(Vector.DOWN.times(0.8));
            if (entity.getOwner() == null) {
                return this;
            }
            if (entity.field_70132_H) {
                IBlockState state = Blocks.field_150358_i.func_176223_P();
                if (!entity.field_70170_p.field_72995_K) {
                    entity.field_70170_p.func_180501_a(entity.func_180425_c(), state, 3);
                    entity.func_70106_y();
                    if (!entity.isSourceBlock()) {
                        AvatarWorldData wd = AvatarWorldData.getDataFromWorld(entity.field_70170_p);
                        wd.addTemporaryWaterLocation(entity.func_180425_c());
                    }
                }
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class PlayerControlled
    extends WaterBubbleBehavior {
        @Override
        public Behavior onUpdate(EntityWaterBubble entity) {
            Vector target;
            EntityLivingBase owner = entity.getOwner();
            if (owner == null) {
                return this;
            }
            BendingData data = Bender.get(owner).getData();
            Raytrace.Result raytrace = Raytrace.getTargetBlock(owner, 3.0, false);
            if (raytrace.hitSomething()) {
                target = raytrace.getPosPrecise().plus(0.0, 0.2, 0.0);
            } else {
                double yaw = Math.toRadians(owner.field_70177_z);
                double pitch = Math.toRadians(owner.field_70125_A);
                Vector forward = Vector.toRectangular(yaw, pitch);
                Vector eye = Vector.getEyePos((Entity)owner);
                target = forward.times(3.0).plus(eye);
            }
            Vector motion = target.minus(Vector.getEntityPos(entity)).times(3.0);
            entity.setVelocity(motion);
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }

    public static class Drop
    extends WaterBubbleBehavior {
        @Override
        public Behavior onUpdate(EntityWaterBubble entity) {
            entity.addVelocity(Vector.DOWN.times(0.981));
            if (entity.field_70132_H) {
                entity.func_70106_y();
            }
            return this;
        }

        @Override
        public void fromBytes(PacketBuffer buf) {
        }

        @Override
        public void toBytes(PacketBuffer buf) {
        }

        @Override
        public void load(NBTTagCompound nbt) {
        }

        @Override
        public void save(NBTTagCompound nbt) {
        }
    }
}

